/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.config.hosts;

import io.jenkins.cli.shaded.org.apache.sshd.client.config.hosts.HostPatternsHolder;
import io.jenkins.cli.shaded.org.apache.sshd.client.config.hosts.KnownHostHashValue;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.PublicKeyEntry;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.input.NoCloseInputStream;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.input.NoCloseReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamCorruptedException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class KnownHostEntry
extends HostPatternsHolder {
    public static final char MARKER_INDICATOR = '@';
    public static final String STD_HOSTS_FILENAME = "known_hosts";
    private String line;
    private String marker;
    private AuthorizedKeyEntry keyEntry;
    private KnownHostHashValue hashedEntry;

    public KnownHostEntry() {
    }

    public KnownHostEntry(String line) {
        this.line = line;
    }

    public String getConfigLine() {
        return this.line;
    }

    public void setConfigLine(String line) {
        this.line = line;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public AuthorizedKeyEntry getKeyEntry() {
        return this.keyEntry;
    }

    public void setKeyEntry(AuthorizedKeyEntry keyEntry) {
        this.keyEntry = keyEntry;
    }

    public KnownHostHashValue getHashedEntry() {
        return this.hashedEntry;
    }

    public void setHashedEntry(KnownHostHashValue hashedEntry) {
        this.hashedEntry = hashedEntry;
    }

    @Override
    public boolean isHostMatch(String host, int port) {
        if (super.isHostMatch(host, port)) {
            return true;
        }
        KnownHostHashValue hash = this.getHashedEntry();
        return hash != null && hash.isHostMatch(host, port);
    }

    public String toString() {
        return this.getConfigLine();
    }

    public static Path getDefaultKnownHostsFile() {
        return LazyDefaultConfigFileHolder.HOSTS_FILE;
    }

    public static List<KnownHostEntry> readKnownHostEntries(Path path, OpenOption ... options) throws IOException {
        try (InputStream input = Files.newInputStream(path, options);){
            List<KnownHostEntry> list = KnownHostEntry.readKnownHostEntries(input, true);
            return list;
        }
    }

    public static List<KnownHostEntry> readKnownHostEntries(URL url) throws IOException {
        try (InputStream input = url.openStream();){
            List<KnownHostEntry> list = KnownHostEntry.readKnownHostEntries(input, true);
            return list;
        }
    }

    public static List<KnownHostEntry> readKnownHostEntries(InputStream inStream, boolean okToClose) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(NoCloseInputStream.resolveInputStream(inStream, okToClose), StandardCharsets.UTF_8);){
            List<KnownHostEntry> list = KnownHostEntry.readKnownHostEntries(reader, true);
            return list;
        }
    }

    public static List<KnownHostEntry> readKnownHostEntries(Reader rdr, boolean okToClose) throws IOException {
        try (BufferedReader buf = new BufferedReader(NoCloseReader.resolveReader(rdr, okToClose));){
            List<KnownHostEntry> list = KnownHostEntry.readKnownHostEntries(buf);
            return list;
        }
    }

    public static List<KnownHostEntry> readKnownHostEntries(BufferedReader rdr) throws IOException {
        ArrayList<KnownHostEntry> entries = null;
        int lineNumber = 1;
        String line = rdr.readLine();
        while (line != null) {
            int pos;
            if (!GenericUtils.isEmpty(line = GenericUtils.trimToEmpty(line)) && (pos = line.indexOf(35)) != 0) {
                if (pos > 0) {
                    line = line.substring(0, pos);
                    line = line.trim();
                }
                try {
                    KnownHostEntry entry = KnownHostEntry.parseKnownHostEntry(line);
                    if (entry != null) {
                        if (entries == null) {
                            entries = new ArrayList<KnownHostEntry>();
                        }
                        entries.add(entry);
                    }
                }
                catch (Error | RuntimeException e) {
                    throw new StreamCorruptedException("Failed (" + e.getClass().getSimpleName() + ") to parse line #" + lineNumber + " '" + line + "': " + e.getMessage());
                }
            }
            line = rdr.readLine();
            ++lineNumber;
        }
        if (entries == null) {
            return Collections.emptyList();
        }
        return entries;
    }

    public static KnownHostEntry parseKnownHostEntry(String line) {
        return KnownHostEntry.parseKnownHostEntry(GenericUtils.isEmpty(line) ? null : new KnownHostEntry(), line);
    }

    public static <E extends KnownHostEntry> E parseKnownHostEntry(E entry, String data) {
        int pos;
        String line = GenericUtils.replaceWhitespaceAndTrim(data);
        if (GenericUtils.isEmpty(line) || line.charAt(0) == '#') {
            return entry;
        }
        entry.setConfigLine(line);
        if (line.charAt(0) == '@') {
            pos = line.indexOf(32);
            ValidateUtils.checkTrue(pos > 0, "Missing marker name end delimiter in line=%s", (Object)data);
            ValidateUtils.checkTrue(pos > 1, "No marker name after indicator in line=%s", (Object)data);
            entry.setMarker(line.substring(1, pos));
            line = line.substring(pos + 1).trim();
        } else {
            entry.setMarker(null);
        }
        pos = line.indexOf(32);
        ValidateUtils.checkTrue(pos > 0, "Missing host patterns end delimiter in line=%s", (Object)data);
        String hostPattern = line.substring(0, pos);
        line = line.substring(pos + 1).trim();
        if (hostPattern.charAt(0) == '|') {
            KnownHostHashValue hash = ValidateUtils.checkNotNull(KnownHostHashValue.parse(hostPattern), "Failed to extract host hash value from line=%s", (Object)data);
            entry.setHashedEntry(hash);
            entry.setPatterns(null);
        } else {
            entry.setHashedEntry(null);
            entry.setPatterns(KnownHostEntry.parsePatterns(GenericUtils.split(hostPattern, ',')));
        }
        AuthorizedKeyEntry key = ValidateUtils.checkNotNull(AuthorizedKeyEntry.parseAuthorizedKeyEntry(line), "No valid key entry recovered from line=%s", (Object)data);
        entry.setKeyEntry(key);
        return entry;
    }

    private static final class LazyDefaultConfigFileHolder {
        private static final Path HOSTS_FILE = PublicKeyEntry.getDefaultKeysFolderPath().resolve("known_hosts");

        private LazyDefaultConfigFileHolder() {
            throw new UnsupportedOperationException("No instance allowed");
        }
    }
}

