/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.kex;

import io.jenkins.cli.shaded.org.apache.sshd.common.NamedResource;
import io.jenkins.cli.shaded.org.apache.sshd.common.SshConstants;
import io.jenkins.cli.shaded.org.apache.sshd.common.digest.Digest;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.Session;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.SessionHolder;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.Buffer;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.logging.LoggingUtils;
import java.math.BigInteger;
import java.util.Collections;
import java.util.NavigableMap;

public interface KeyExchange
extends NamedResource,
SessionHolder<Session> {
    public static final NavigableMap<Integer, String> GROUP_KEX_OPCODES_MAP = Collections.unmodifiableNavigableMap(LoggingUtils.generateMnemonicMap(SshConstants.class, "SSH_MSG_KEX_DH_GEX_"));
    public static final NavigableMap<Integer, String> SIMPLE_KEX_OPCODES_MAP = Collections.unmodifiableNavigableMap(LoggingUtils.generateMnemonicMap(SshConstants.class, "SSH_MSG_KEXDH_"));

    public void init(byte[] var1, byte[] var2, byte[] var3, byte[] var4) throws Exception;

    public boolean next(int var1, Buffer var2) throws Exception;

    public Digest getHash();

    public byte[] getH();

    public byte[] getK();

    public static String getGroupKexOpcodeName(int cmd) {
        String name = (String)GROUP_KEX_OPCODES_MAP.get(cmd);
        if (GenericUtils.isEmpty(name)) {
            return SshConstants.getCommandMessageName(cmd);
        }
        return name;
    }

    public static String getSimpleKexOpcodeName(int cmd) {
        String name = (String)SIMPLE_KEX_OPCODES_MAP.get(cmd);
        if (GenericUtils.isEmpty(name)) {
            return SshConstants.getCommandMessageName(cmd);
        }
        return name;
    }

    public static boolean isValidDHValue(BigInteger value, BigInteger p) {
        if (value == null || p == null) {
            return false;
        }
        if (value.compareTo(BigInteger.ONE) <= 0) {
            return false;
        }
        return value.compareTo(p.subtract(BigInteger.ONE)) < 0;
    }
}

