/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.impl;

import io.jenkins.cli.shaded.org.apache.sshd.common.PropertyResolverUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.PublicKeyEntryDecoder;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.impl.AbstractKeyEntryResolver;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.MapEntryUtils;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Map;

public abstract class AbstractPublicKeyEntryDecoder<PUB extends PublicKey, PRV extends PrivateKey>
extends AbstractKeyEntryResolver<PUB, PRV>
implements PublicKeyEntryDecoder<PUB, PRV> {
    protected AbstractPublicKeyEntryDecoder(Class<PUB> pubType, Class<PRV> prvType, Collection<String> names) {
        super(pubType, prvType, names);
    }

    protected final boolean parseBooleanHeader(Map<String, String> headers, String propertyKey, boolean defaultVal) {
        Boolean boolVal;
        if (MapEntryUtils.isEmpty(headers) || !headers.containsKey(propertyKey)) {
            return defaultVal;
        }
        String stringVal = headers.get(propertyKey);
        try {
            boolVal = PropertyResolverUtils.parseBoolean(stringVal);
        }
        catch (IllegalArgumentException e) {
            this.log.warn("Ignoring non-boolean property value for \"{}\": {}", (Object)propertyKey, (Object)stringVal);
            boolVal = null;
        }
        if (boolVal == null) {
            return defaultVal;
        }
        return boolVal;
    }
}

