/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.signature;

import io.jenkins.cli.shaded.org.apache.sshd.common.session.SessionContext;
import io.jenkins.cli.shaded.org.apache.sshd.common.signature.Signature;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.NumberUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.BufferUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.security.SecurityUtils;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public abstract class AbstractSignature
implements Signature {
    private java.security.Signature signatureInstance;
    private final String algorithm;

    protected AbstractSignature(String algorithm) {
        this.algorithm = ValidateUtils.checkNotNullAndNotEmpty(algorithm, "No signature algorithm specified");
    }

    @Override
    public final String getAlgorithm() {
        return this.algorithm;
    }

    protected java.security.Signature doInitSignature(SessionContext session, String algo, Key key, boolean forSigning) throws GeneralSecurityException {
        return SecurityUtils.getSignature(algo);
    }

    protected java.security.Signature getSignature() {
        return this.signatureInstance;
    }

    @Override
    public byte[] sign(SessionContext session) throws Exception {
        java.security.Signature signature = Objects.requireNonNull(this.getSignature(), "Signature not initialized");
        return signature.sign();
    }

    @Override
    public void initVerifier(SessionContext session, PublicKey key) throws Exception {
        String algo = this.getAlgorithm();
        this.signatureInstance = Objects.requireNonNull(this.doInitSignature(session, algo, key, false), "No signature instance create");
        this.signatureInstance.initVerify(Objects.requireNonNull(key, "No public key provided"));
    }

    @Override
    public void initSigner(SessionContext session, PrivateKey key) throws Exception {
        String algo = this.getAlgorithm();
        this.signatureInstance = Objects.requireNonNull(this.doInitSignature(session, algo, key, true), "No signature instance create");
        this.signatureInstance.initSign(Objects.requireNonNull(key, "No private key provided"));
    }

    @Override
    public void update(SessionContext session, byte[] hash, int off, int len) throws Exception {
        java.security.Signature signature = Objects.requireNonNull(this.getSignature(), "Signature not initialized");
        signature.update(hash, off, len);
    }

    protected Map.Entry<String, byte[]> extractEncodedSignature(byte[] sig, Collection<String> expectedTypes) {
        return GenericUtils.isEmpty(expectedTypes) ? null : this.extractEncodedSignature(sig, expectedTypes::contains);
    }

    protected Map.Entry<String, byte[]> extractEncodedSignature(byte[] sig, Predicate<? super String> typeSelector) {
        int dataLen = NumberUtils.length(sig);
        if (dataLen < 8) {
            return null;
        }
        long keyTypeLen = BufferUtils.getUInt(sig, 0, dataLen);
        if (keyTypeLen >= (long)(dataLen - 4)) {
            return null;
        }
        int keyTypeStartPos = 4;
        int keyTypeEndPos = keyTypeStartPos + (int)keyTypeLen;
        int remainLen = dataLen - keyTypeEndPos;
        if (remainLen < 4) {
            return null;
        }
        long dataBytesLen = BufferUtils.getUInt(sig, keyTypeEndPos, remainLen);
        if (dataBytesLen > (long)(remainLen - 4)) {
            return null;
        }
        String keyType = new String(sig, keyTypeStartPos, (int)keyTypeLen, StandardCharsets.UTF_8);
        if (!typeSelector.test(keyType)) {
            return null;
        }
        byte[] data = new byte[(int)dataBytesLen];
        System.arraycopy(sig, keyTypeEndPos + 4, data, 0, (int)dataBytesLen);
        return new AbstractMap.SimpleImmutableEntry<String, byte[]>(keyType, data);
    }

    protected boolean doVerify(byte[] data) throws SignatureException {
        java.security.Signature signature = Objects.requireNonNull(this.getSignature(), "Signature not initialized");
        return signature.verify(data);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getAlgorithm() + "]";
    }
}

