/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.forward;

import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.net.SshdSocketAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Objects;

public class LocalForwardingEntry {
    private final SshdSocketAddress local;
    private final SshdSocketAddress bound;
    private final SshdSocketAddress combined;

    public LocalForwardingEntry(SshdSocketAddress local, InetSocketAddress bound) {
        this(local, new SshdSocketAddress(bound));
    }

    public LocalForwardingEntry(SshdSocketAddress local, SshdSocketAddress bound) {
        this.local = Objects.requireNonNull(local, "No local address provided");
        this.bound = Objects.requireNonNull(bound, "No bound address provided");
        this.combined = LocalForwardingEntry.resolveCombinedBoundAddress(local, bound);
    }

    public SshdSocketAddress getLocalAddress() {
        return this.local;
    }

    public SshdSocketAddress getBoundAddress() {
        return this.bound;
    }

    public SshdSocketAddress getCombinedBoundAddress() {
        return this.combined;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        LocalForwardingEntry other = (LocalForwardingEntry)o;
        return Objects.equals(this.getCombinedBoundAddress(), other.getCombinedBoundAddress());
    }

    public int hashCode() {
        return Objects.hashCode(this.getCombinedBoundAddress());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[local=" + this.getLocalAddress() + ", bound=" + this.getBoundAddress() + ", combined=" + this.getCombinedBoundAddress() + "]";
    }

    public static SshdSocketAddress resolveCombinedBoundAddress(SshdSocketAddress local, SshdSocketAddress bound) {
        int localPort = local.getPort();
        int boundPort = bound.getPort();
        if (localPort > 0 && localPort != boundPort) {
            throw new IllegalArgumentException("Mismatched ports for local (" + local + ") vs. bound (" + bound + ") entry");
        }
        if (Objects.equals(local, bound)) {
            return local;
        }
        String localName = local.getHostName();
        boolean wildcardLocal = SshdSocketAddress.isWildcardAddress(localName);
        if (wildcardLocal) {
            return bound;
        }
        if (localPort > 0) {
            return local;
        }
        return new SshdSocketAddress(localName, boundPort);
    }

    public static LocalForwardingEntry findMatchingEntry(String host, int port, Collection<? extends LocalForwardingEntry> entries) {
        return LocalForwardingEntry.findMatchingEntry(host, SshdSocketAddress.isWildcardAddress(host), port, entries);
    }

    public static LocalForwardingEntry findMatchingEntry(String host, boolean anyLocalAddress, int port, Collection<? extends LocalForwardingEntry> entries) {
        if (port <= 0 || GenericUtils.isEmpty(entries)) {
            return null;
        }
        if (GenericUtils.isEmpty(host) && !anyLocalAddress) {
            return null;
        }
        LocalForwardingEntry candidate = null;
        for (LocalForwardingEntry localForwardingEntry : entries) {
            SshdSocketAddress bound = localForwardingEntry.getBoundAddress();
            if (port != bound.getPort()) continue;
            String boundName = bound.getHostName();
            if (SshdSocketAddress.isEquivalentHostName(host, boundName, false)) {
                return localForwardingEntry;
            }
            SshdSocketAddress local = localForwardingEntry.getLocalAddress();
            String localName = local.getHostName();
            if (SshdSocketAddress.isEquivalentHostName(host, localName, false)) {
                return localForwardingEntry;
            }
            if (SshdSocketAddress.isLoopbackAlias(host, boundName) || SshdSocketAddress.isLoopbackAlias(host, localName)) {
                return localForwardingEntry;
            }
            if (!anyLocalAddress) continue;
            if (candidate != null) {
                throw new IllegalStateException("Multiple candidate matches for " + host + "@" + port + ": " + candidate + ", " + localForwardingEntry);
            }
            candidate = localForwardingEntry;
        }
        if (anyLocalAddress) {
            return candidate;
        }
        return null;
    }
}

