/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.glassfish.tyrus.core;

import io.jenkins.cli.shaded.jakarta.websocket.Extension;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.HandshakeException;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.RequestContext;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.SecKey;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.TyrusEndpointWrapper;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.TyrusExtension;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.Utils;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.extension.ExtendedExtension;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.l10n.LocalizationMessages;
import io.jenkins.cli.shaded.org.glassfish.tyrus.spi.UpgradeRequest;
import io.jenkins.cli.shaded.org.glassfish.tyrus.spi.UpgradeResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class Handshake {
    private static final int RESPONSE_CODE_VALUE = 101;
    private static final String VERSION = "13";
    private List<String> subProtocols = new ArrayList<String>();
    private List<Extension> extensions = new ArrayList<Extension>();
    private RequestContext request;
    private UpgradeRequest incomingRequest;
    private ExtendedExtension.ExtensionContext extensionContext;
    private SecKey secKey;

    private Handshake() {
    }

    public static Handshake createClientHandshake(RequestContext webSocketRequest) {
        Handshake handshake = new Handshake();
        handshake.request = webSocketRequest;
        handshake.secKey = new SecKey();
        return handshake;
    }

    public RequestContext getRequest() {
        return this.request;
    }

    public void setSubProtocols(List<String> subProtocols) {
        this.subProtocols = subProtocols;
    }

    public void setExtensions(List<Extension> extensions) {
        this.extensions = extensions;
    }

    public UpgradeRequest prepareRequest() {
        Map<String, List<String>> requestHeaders = this.request.getHeaders();
        Handshake.updateHostAndOrigin(this.request);
        requestHeaders.put("Connection", Collections.singletonList("Upgrade"));
        requestHeaders.put("Upgrade", Collections.singletonList("websocket"));
        requestHeaders.put("Sec-WebSocket-Key", Collections.singletonList(this.secKey.toString()));
        requestHeaders.put("Sec-WebSocket-Version", Collections.singletonList(VERSION));
        if (!this.subProtocols.isEmpty()) {
            requestHeaders.put("Sec-WebSocket-Protocol", Collections.singletonList(Utils.getHeaderFromList(this.subProtocols, null)));
        }
        if (!this.extensions.isEmpty()) {
            requestHeaders.put("Sec-WebSocket-Extensions", Collections.singletonList(Utils.getHeaderFromList(this.extensions, new Utils.Stringifier<Extension>(){

                @Override
                String toString(Extension extension) {
                    return TyrusExtension.toString(extension);
                }
            })));
        }
        return this.request;
    }

    public void validateServerResponse(UpgradeResponse response) throws HandshakeException {
        if (101 != response.getStatus()) {
            throw new HandshakeException(response.getStatus(), LocalizationMessages.INVALID_RESPONSE_CODE(101, response.getStatus()));
        }
        Handshake.checkForHeader(response.getFirstHeaderValue("Upgrade"), "Upgrade", "websocket");
        Handshake.checkForHeader(response.getFirstHeaderValue("Connection"), "Connection", "Upgrade");
        this.secKey.validateServerKey(response.getFirstHeaderValue("Sec-WebSocket-Accept"));
    }

    public static void updateHostAndOrigin(UpgradeRequest upgradeRequest) {
        URI requestUri = upgradeRequest.getRequestURI();
        String host = requestUri.getHost();
        int port = requestUri.getPort();
        if (upgradeRequest.isSecure()) {
            if (port != 443 && port != -1) {
                host = host + ":" + port;
            }
        } else if (port != 80 && port != -1) {
            host = host + ":" + port;
        }
        Map<String, List<String>> requestHeaders = upgradeRequest.getHeaders();
        requestHeaders.put("Host", Collections.singletonList(host));
        requestHeaders.put("Origin", Collections.singletonList("http://" + host));
    }

    static Handshake createServerHandshake(UpgradeRequest request, ExtendedExtension.ExtensionContext extensionContext) throws HandshakeException {
        Handshake handshake = new Handshake();
        handshake.incomingRequest = request;
        handshake.extensionContext = extensionContext;
        Handshake.checkForHeader(request.getHeader("Upgrade"), "Upgrade", "WebSocket");
        Handshake.checkForHeader(request.getHeader("Connection"), "Connection", "Upgrade");
        String protocolHeader = request.getHeader("Sec-WebSocket-Protocol");
        List<Object> list = handshake.subProtocols = protocolHeader == null ? Collections.emptyList() : Arrays.asList(protocolHeader.split(","));
        if (request.getHeader("Host") == null) {
            throw new HandshakeException(LocalizationMessages.HEADERS_MISSING());
        }
        List<String> value = request.getHeaders().get("Sec-WebSocket-Extensions");
        if (value != null) {
            handshake.extensions = TyrusExtension.fromHeaders(value);
        }
        handshake.secKey = SecKey.generateServerKey(new SecKey(request.getHeader("Sec-WebSocket-Key")));
        return handshake;
    }

    private static void checkForHeader(String currentValue, String header, String validValue) throws HandshakeException {
        Handshake.validate(header, validValue, currentValue);
    }

    private static void validate(String header, String validValue, String value) throws HandshakeException {
        if (header.equalsIgnoreCase("Connection") ? value == null || !value.toLowerCase().contains(validValue.toLowerCase()) : !validValue.equalsIgnoreCase(value)) {
            throw new HandshakeException(LocalizationMessages.INVALID_HEADER(header, value));
        }
    }

    List<Extension> respond(UpgradeRequest request, UpgradeResponse response, TyrusEndpointWrapper endpointWrapper) {
        List<Extension> negotiatedExtensions;
        String protocol;
        response.setStatus(101);
        response.getHeaders().put("Upgrade", Arrays.asList("websocket"));
        response.getHeaders().put("Connection", Arrays.asList("Upgrade"));
        response.setReasonPhrase("Switching Protocols");
        response.getHeaders().put("Sec-WebSocket-Accept", Arrays.asList(this.secKey.getSecKey()));
        List<String> protocols = request.getHeaders().get("Sec-WebSocket-Protocol");
        List<Extension> extensions = TyrusExtension.fromString(request.getHeaders().get("Sec-WebSocket-Extensions"));
        if (this.subProtocols != null && !this.subProtocols.isEmpty() && (protocol = endpointWrapper.getNegotiatedProtocol(protocols)) != null && !protocol.isEmpty()) {
            response.getHeaders().put("Sec-WebSocket-Protocol", Arrays.asList(protocol));
        }
        if (!(negotiatedExtensions = endpointWrapper.getNegotiatedExtensions(extensions)).isEmpty()) {
            response.getHeaders().put("Sec-WebSocket-Extensions", Utils.getStringList(negotiatedExtensions, new Utils.Stringifier<Extension>(){

                @Override
                String toString(final Extension extension) {
                    if (extension instanceof ExtendedExtension) {
                        return TyrusExtension.toString(new Extension(){

                            @Override
                            public String getName() {
                                return extension.getName();
                            }

                            @Override
                            public List<Extension.Parameter> getParameters() {
                                return ((ExtendedExtension)extension).onExtensionNegotiation(Handshake.this.extensionContext, null);
                            }
                        });
                    }
                    return TyrusExtension.toString(extension);
                }
            }));
        }
        endpointWrapper.onHandShakeResponse(this.incomingRequest, response);
        return negotiatedExtensions;
    }
}

