/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.session;

import io.jenkins.cli.shaded.org.apache.sshd.common.CommonModuleProperties;
import io.jenkins.cli.shaded.org.apache.sshd.common.PropertyResolver;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import java.time.Duration;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public interface SessionHeartbeatController
extends PropertyResolver {
    default public HeartbeatType getSessionHeartbeatType() {
        return CommonModuleProperties.SESSION_HEARTBEAT_TYPE.getRequired(this);
    }

    default public Duration getSessionHeartbeatInterval() {
        return CommonModuleProperties.SESSION_HEARTBEAT_INTERVAL.getRequired(this);
    }

    default public void disableSessionHeartbeat() {
        this.setSessionHeartbeat(HeartbeatType.NONE, Duration.ZERO);
    }

    default public void setSessionHeartbeat(HeartbeatType type, TimeUnit unit, long count) {
        Objects.requireNonNull(unit, "No heartbeat time unit provided");
        this.setSessionHeartbeat(type, Duration.ofMillis(TimeUnit.MILLISECONDS.convert(count, unit)));
    }

    default public void setSessionHeartbeat(HeartbeatType type, Duration interval) {
        Objects.requireNonNull(type, "No heartbeat type specified");
        Objects.requireNonNull(interval, "No heartbeat time interval provided");
        CommonModuleProperties.SESSION_HEARTBEAT_TYPE.set(this, type);
        CommonModuleProperties.SESSION_HEARTBEAT_INTERVAL.set(this, interval);
    }

    public static enum HeartbeatType {
        NONE,
        IGNORE,
        RESERVED;

        public static final Set<HeartbeatType> VALUES;

        public static HeartbeatType fromName(String name) {
            return GenericUtils.isEmpty(name) ? null : (HeartbeatType)VALUES.stream().filter(v -> name.equalsIgnoreCase(v.name())).findAny().orElse(null);
        }

        static {
            VALUES = EnumSet.allOf(HeartbeatType.class);
        }
    }
}

