/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.random;

import io.jenkins.cli.shaded.org.apache.sshd.common.NamedFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.OptionalFeature;
import io.jenkins.cli.shaded.org.apache.sshd.common.random.AbstractRandom;
import io.jenkins.cli.shaded.org.apache.sshd.common.random.Random;
import io.jenkins.cli.shaded.org.apache.sshd.common.random.RandomFactory;
import java.util.Objects;

public class SingletonRandomFactory
extends AbstractRandom
implements RandomFactory {
    private final NamedFactory<Random> factory;
    private final Random random;

    public SingletonRandomFactory(NamedFactory<Random> factory) {
        this.factory = Objects.requireNonNull(factory, "No factory");
        this.random = (Random)Objects.requireNonNull(factory.create(), "No random instance created");
    }

    @Override
    public boolean isSupported() {
        if (this.factory instanceof OptionalFeature) {
            return ((OptionalFeature)((Object)this.factory)).isSupported();
        }
        return true;
    }

    @Override
    public void fill(byte[] bytes, int start, int len) {
        this.random.fill(bytes, start, len);
    }

    @Override
    public int random(int max) {
        return this.random.random(max);
    }

    @Override
    public String getName() {
        return this.factory.getName();
    }

    @Override
    public Random create() {
        return this;
    }
}

