/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.glassfish.tyrus.core;

import io.jenkins.cli.shaded.jakarta.websocket.MessageHandler;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.BufferedInputStream;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.MessageTooBigException;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.l10n.LocalizationMessages;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

class InputStreamBuffer {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final List<ByteBuffer> bufferedFragments = new ArrayList<ByteBuffer>();
    private final ExecutorService executorService;
    private static final Logger LOGGER = Logger.getLogger(InputStreamBuffer.class.getName());
    private volatile boolean receivedLast = false;
    private volatile BufferedInputStream inputStream = null;
    private volatile MessageHandler.Whole<InputStream> messageHandler;
    private volatile int bufferSize;
    private volatile int currentlyBuffered;
    private volatile boolean sessionClosed = false;

    public InputStreamBuffer(ExecutorService executorService) {
        this.executorService = executorService;
        this.currentlyBuffered = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextByte() throws IOException {
        this.lock.lock();
        try {
            int interrupted;
            if (this.bufferedFragments.isEmpty()) {
                if (this.receivedLast) {
                    this.inputStream = null;
                    this.currentlyBuffered = 0;
                    int n = -1;
                    return n;
                }
                this.checkClosedSession();
                do {
                    interrupted = 0;
                    try {
                        this.condition.await();
                        this.checkClosedSession();
                    }
                    catch (InterruptedException e) {
                        interrupted = 1;
                    }
                } while (interrupted != 0);
            }
            if (this.bufferedFragments.size() == 1 && !this.bufferedFragments.get(0).hasRemaining() && this.receivedLast) {
                this.inputStream = null;
                this.currentlyBuffered = 0;
                interrupted = -1;
                return interrupted;
            }
            ByteBuffer firstBuffer = this.bufferedFragments.get(0);
            byte result = firstBuffer.get();
            if (!firstBuffer.hasRemaining()) {
                this.bufferedFragments.remove(0);
            }
            int n = result & 0xFF;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void finishReading() {
        this.bufferedFragments.clear();
        this.inputStream = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendMessagePart(ByteBuffer message, boolean last) {
        this.lock.lock();
        try {
            this.currentlyBuffered += message.remaining();
            if (this.currentlyBuffered > this.bufferSize) {
                MessageTooBigException messageTooBigException = new MessageTooBigException(LocalizationMessages.PARTIAL_MESSAGE_BUFFER_OVERFLOW());
                LOGGER.log(Level.FINE, LocalizationMessages.PARTIAL_MESSAGE_BUFFER_OVERFLOW(), messageTooBigException);
                this.receivedLast = true;
                throw messageTooBigException;
            }
            this.bufferedFragments.add(message);
            this.receivedLast = last;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        if (this.inputStream == null) {
            this.inputStream = new BufferedInputStream(this);
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    InputStreamBuffer.this.messageHandler.onMessage(InputStreamBuffer.this.inputStream);
                }
            });
        }
    }

    public void setMessageHandler(MessageHandler.Whole<InputStream> messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void resetBuffer(int bufferSize) {
        this.bufferSize = bufferSize;
        this.currentlyBuffered = 0;
        this.bufferedFragments.clear();
    }

    void onSessionClosed() {
        this.sessionClosed = true;
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void checkClosedSession() throws IOException {
        if (this.sessionClosed) {
            throw new IOException("Websocket session has been closed.");
        }
    }
}

