/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.server.forward;

import io.jenkins.cli.shaded.org.apache.sshd.common.session.Session;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.logging.AbstractLoggingBean;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.net.SshdSocketAddress;
import io.jenkins.cli.shaded.org.apache.sshd.server.forward.ForwardingFilter;
import io.jenkins.cli.shaded.org.apache.sshd.server.forward.TcpForwardingFilter;

public class StaticDecisionForwardingFilter
extends AbstractLoggingBean
implements ForwardingFilter {
    private final boolean acceptance;

    public StaticDecisionForwardingFilter(boolean acceptance) {
        this.acceptance = acceptance;
    }

    public final boolean isAccepted() {
        return this.acceptance;
    }

    @Override
    public boolean canForwardAgent(Session session, String requestType) {
        return this.checkAcceptance(requestType, session, SshdSocketAddress.LOCALHOST_ADDRESS);
    }

    @Override
    public boolean canForwardX11(Session session, String requestType) {
        return this.checkAcceptance(requestType, session, SshdSocketAddress.LOCALHOST_ADDRESS);
    }

    @Override
    public boolean canListen(SshdSocketAddress address, Session session) {
        return this.checkAcceptance("tcpip-forward", session, address);
    }

    @Override
    public boolean canConnect(TcpForwardingFilter.Type type, SshdSocketAddress address, Session session) {
        return this.checkAcceptance(type.getName(), session, address);
    }

    protected boolean checkAcceptance(String request, Session session, SshdSocketAddress target) {
        boolean accepted = this.isAccepted();
        if (this.log.isDebugEnabled()) {
            this.log.debug("checkAcceptance(" + request + ")[" + session + "] acceptance for target=" + target + " is " + accepted);
        }
        return accepted;
    }
}

