/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.loader.openssh;

import io.jenkins.cli.shaded.org.apache.sshd.common.NamedResource;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.loader.openssh.OpenSSHKdfOptions;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.loader.openssh.OpenSSHKeyDecryptor;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.SessionContext;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.security.GeneralSecurityException;
import java.util.function.Predicate;

public class OpenSSHParserContext
implements OpenSSHKeyDecryptor {
    public static final String NONE_CIPHER = "none";
    public static final Predicate<String> IS_NONE_CIPHER = c -> GenericUtils.isEmpty(c) || NONE_CIPHER.equalsIgnoreCase((String)c);
    private String cipherName;
    private OpenSSHKdfOptions kdfOptions;

    public OpenSSHParserContext() {
    }

    public OpenSSHParserContext(String cipherName, OpenSSHKdfOptions kdfOptions) {
        this.setCipherName(cipherName);
        this.setKdfOptions(kdfOptions);
    }

    @Override
    public boolean isEncrypted() {
        if (!IS_NONE_CIPHER.test(this.getCipherName())) {
            return true;
        }
        OpenSSHKdfOptions options = this.getKdfOptions();
        return options != null && options.isEncrypted();
    }

    public String getCipherName() {
        return this.cipherName;
    }

    public void setCipherName(String cipherName) {
        this.cipherName = cipherName;
    }

    public OpenSSHKdfOptions getKdfOptions() {
        return this.kdfOptions;
    }

    public void setKdfOptions(OpenSSHKdfOptions kdfOptions) {
        this.kdfOptions = kdfOptions;
    }

    @Override
    public byte[] decodePrivateKeyBytes(SessionContext session, NamedResource resourceKey, String cipherName, byte[] privateDataBytes, String password) throws IOException, GeneralSecurityException {
        OpenSSHKdfOptions options = this.getKdfOptions();
        if (options == null) {
            throw new StreamCorruptedException("No KDF options available for decrypting " + resourceKey);
        }
        return options.decodePrivateKeyBytes(session, resourceKey, cipherName, privateDataBytes, password);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[cipher=" + this.getCipherName() + ", kdfOptions=" + this.getKdfOptions() + "]";
    }
}

