/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.keys;

import io.jenkins.cli.shaded.net.i2p.crypto.eddsa.EdDSAPublicKey;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.u2f.SkED25519PublicKey;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.Buffer;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.keys.AbstractBufferPublicKeyParser;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.keys.ED25519BufferPublicKeyParser;
import java.security.GeneralSecurityException;
import java.security.PublicKey;

public class SkED25519BufferPublicKeyParser
extends AbstractBufferPublicKeyParser<SkED25519PublicKey> {
    public static final SkED25519BufferPublicKeyParser INSTANCE = new SkED25519BufferPublicKeyParser();

    public SkED25519BufferPublicKeyParser() {
        super(SkED25519PublicKey.class, "sk-ssh-ed25519@openssh.com");
    }

    @Override
    public SkED25519PublicKey getRawPublicKey(String keyType, Buffer buffer) throws GeneralSecurityException {
        PublicKey publicKey = ED25519BufferPublicKeyParser.INSTANCE.getRawPublicKey("ssh-ed25519", buffer);
        String appName = buffer.getString();
        return new SkED25519PublicKey(appName, false, (EdDSAPublicKey)publicKey);
    }
}

