/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.cli.FlightRecorderInputStream;
import io.jenkins.cli.shaded.org.apache.commons.io.IOUtils;
import io.jenkins.cli.shaded.org.apache.commons.io.input.BoundedInputStream;
import io.jenkins.cli.shaded.org.apache.commons.io.input.CountingInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadPendingException;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

class PlainCLIProtocol {
    static final Logger LOGGER = Logger.getLogger(PlainCLIProtocol.class.getName());

    private PlainCLIProtocol() {
    }

    static abstract class ClientSide
    extends EitherSide {
        ClientSide(Output out) {
            super(out);
        }

        @Override
        protected boolean handle(Op op, DataInputStream dis) throws IOException {
            assert (!op.clientSide);
            switch (op) {
                case EXIT: {
                    this.onExit(dis.readInt());
                    return true;
                }
                case STDOUT: {
                    this.onStdout(IOUtils.toByteArray(dis));
                    return true;
                }
                case STDERR: {
                    this.onStderr(IOUtils.toByteArray(dis));
                    return true;
                }
            }
            return false;
        }

        protected abstract void onExit(int var1);

        protected abstract void onStdout(byte[] var1) throws IOException;

        protected abstract void onStderr(byte[] var1) throws IOException;

        public final void sendArg(String text) throws IOException {
            this.send(Op.ARG, text);
        }

        public final void sendLocale(String text) throws IOException {
            this.send(Op.LOCALE, text);
        }

        public final void sendEncoding(String text) throws IOException {
            this.send(Op.ENCODING, text);
        }

        public final void sendStart() throws IOException {
            this.send(Op.START);
        }

        public final OutputStream streamStdin() {
            return this.stream(Op.STDIN);
        }

        public final void sendEndStdin() throws IOException {
            this.send(Op.END_STDIN);
        }
    }

    static abstract class ServerSide
    extends EitherSide {
        ServerSide(Output out) {
            super(out);
        }

        @Override
        protected final boolean handle(Op op, DataInputStream dis) throws IOException {
            assert (op.clientSide);
            switch (op) {
                case ARG: {
                    this.onArg(dis.readUTF());
                    return true;
                }
                case LOCALE: {
                    this.onLocale(dis.readUTF());
                    return true;
                }
                case ENCODING: {
                    this.onEncoding(dis.readUTF());
                    return true;
                }
                case START: {
                    this.onStart();
                    return true;
                }
                case STDIN: {
                    this.onStdin(IOUtils.toByteArray(dis));
                    return true;
                }
                case END_STDIN: {
                    this.onEndStdin();
                    return true;
                }
            }
            return false;
        }

        protected abstract void onArg(String var1);

        protected abstract void onLocale(String var1);

        protected abstract void onEncoding(String var1);

        protected abstract void onStart();

        protected abstract void onStdin(byte[] var1) throws IOException;

        protected abstract void onEndStdin() throws IOException;

        public final void sendExit(int code) throws IOException {
            this.send(Op.EXIT, code);
        }

        public final OutputStream streamStdout() {
            return this.stream(Op.STDOUT);
        }

        public final OutputStream streamStderr() {
            return this.stream(Op.STDERR);
        }
    }

    static abstract class EitherSide
    implements Closeable {
        private final Output out;

        protected EitherSide(Output out) {
            this.out = out;
        }

        protected abstract void handleClose();

        final void handle(DataInputStream dis) throws IOException {
            byte b = dis.readByte();
            if (b < 0) {
                throw new IOException("corrupt stream: negative operation code");
            }
            if (b >= Op.values().length) {
                throw new ProtocolException("unknown operation #" + b);
            }
            Op op = Op.values()[b];
            LOGGER.finest(() -> "handling frame with " + (Object)((Object)op));
            if (!this.handle(op, dis)) {
                throw new ProtocolException("unhandled: " + (Object)((Object)op));
            }
        }

        protected abstract boolean handle(Op var1, DataInputStream var2) throws IOException;

        protected final synchronized void send(Op op) throws IOException {
            this.send(op, new byte[0], 0, 0);
        }

        protected final synchronized void send(Op op, int v) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
            new DataOutputStream(baos).writeInt(v);
            this.send(op, baos.toByteArray());
        }

        protected final synchronized void send(Op op, byte[] chunk, int off, int len) throws IOException {
            byte[] data = new byte[len + 1];
            data[0] = (byte)op.ordinal();
            System.arraycopy(chunk, off, data, 1, len);
            this.out.send(data);
        }

        protected final void send(Op op, byte[] chunk) throws IOException {
            this.send(op, chunk, 0, chunk.length);
        }

        protected final void send(Op op, String text) throws IOException {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            new DataOutputStream(buf).writeUTF(text);
            this.send(op, buf.toByteArray());
        }

        protected final OutputStream stream(final Op op) {
            return new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    this.send(op, new byte[]{(byte)b});
                }

                @Override
                public void write(@NonNull byte[] b, int off, int len) throws IOException {
                    this.send(op, b, off, len);
                }

                @Override
                public void write(@NonNull byte[] b) throws IOException {
                    this.send(op, b);
                }
            };
        }

        @Override
        public synchronized void close() throws IOException {
            this.out.close();
        }
    }

    private static final class ProtocolException
    extends IOException {
        ProtocolException(String message) {
            super(message);
        }
    }

    static final class FramedReader
    extends Thread {
        private final EitherSide side;
        private final CountingInputStream cis;
        private final FlightRecorderInputStream flightRecorder;
        private final DataInputStream dis;

        FramedReader(EitherSide side, InputStream is) {
            super("PlainCLIProtocol");
            this.side = side;
            this.cis = new CountingInputStream(is);
            this.flightRecorder = new FlightRecorderInputStream(this.cis);
            this.dis = new DataInputStream(this.flightRecorder);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block14: {
                try {
                    while (true) lbl-1000:
                    // 4 sources

                    {
                        PlainCLIProtocol.LOGGER.finest("reading frame");
                        try {
                            framelen = this.dis.readInt();
                        }
                        catch (EOFException x) {
                            this.side.handleClose();
                            break block14;
                        }
                        if (framelen < 0) {
                            throw new IOException("corrupt stream: negative frame length");
                        }
                        PlainCLIProtocol.LOGGER.finest("read frame length " + framelen);
                        start = this.cis.getByteCount();
                        try {
                            this.side.handle(new DataInputStream(new BoundedInputStream(this.dis, framelen + 1)));
                        }
                        catch (ProtocolException x) {
                            PlainCLIProtocol.LOGGER.log(Level.WARNING, null, x);
                        }
                        finally {
                            actuallyRead = this.cis.getByteCount() - start;
                            unread = (long)(framelen + 1) - actuallyRead;
                            if (unread <= 0L) continue;
                            PlainCLIProtocol.LOGGER.warning((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$run$0(long ), ()Ljava/lang/String;)((long)unread));
                            IOUtils.skipFully(this.dis, unread);
                            continue;
                        }
                        break;
                    }
                }
                catch (ClosedChannelException x) {
                    PlainCLIProtocol.LOGGER.log(Level.FINE, null, x);
                    this.side.handleClose();
                }
                catch (IOException x) {
                    PlainCLIProtocol.LOGGER.log(Level.WARNING, null, this.flightRecorder.analyzeCrash(x, "broken stream"));
                }
                catch (ReadPendingException x) {
                    PlainCLIProtocol.LOGGER.log(Level.FINE, null, x);
                    this.side.handleClose();
                }
                catch (RuntimeException x) {
                    PlainCLIProtocol.LOGGER.log(Level.WARNING, null, x);
                    this.side.handleClose();
                }
                ** GOTO lbl-1000
            }
        }

        private static /* synthetic */ String lambda$run$0(long unread) {
            return "Did not read " + unread + " bytes";
        }
    }

    static final class FramedOutput
    implements Output {
        private final DataOutputStream dos;

        FramedOutput(OutputStream os) {
            this.dos = new DataOutputStream(os);
        }

        @Override
        public void send(byte[] data) throws IOException {
            this.dos.writeInt(data.length - 1);
            this.dos.write(data);
            this.dos.flush();
        }

        @Override
        public void close() throws IOException {
            this.dos.close();
        }
    }

    static interface Output
    extends Closeable {
        public void send(byte[] var1) throws IOException;
    }

    private static enum Op {
        ARG(true),
        LOCALE(true),
        ENCODING(true),
        START(true),
        EXIT(false),
        STDIN(true),
        END_STDIN(true),
        STDOUT(false),
        STDERR(false);

        final boolean clientSide;

        private Op(boolean clientSide) {
            this.clientSide = clientSide;
        }
    }
}

