/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.server;

import io.jenkins.cli.shaded.org.apache.sshd.common.BaseBuilder;
import io.jenkins.cli.shaded.org.apache.sshd.common.NamedFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.ChannelFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.RequestHandler;
import io.jenkins.cli.shaded.org.apache.sshd.common.compression.BuiltinCompressions;
import io.jenkins.cli.shaded.org.apache.sshd.common.compression.Compression;
import io.jenkins.cli.shaded.org.apache.sshd.common.compression.CompressionFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.kex.DHFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.kex.KeyExchangeFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.ConnectionService;
import io.jenkins.cli.shaded.org.apache.sshd.common.signature.BuiltinSignatures;
import io.jenkins.cli.shaded.org.apache.sshd.common.signature.Signature;
import io.jenkins.cli.shaded.org.apache.sshd.server.SshServer;
import io.jenkins.cli.shaded.org.apache.sshd.server.auth.keyboard.DefaultKeyboardInteractiveAuthenticator;
import io.jenkins.cli.shaded.org.apache.sshd.server.auth.keyboard.KeyboardInteractiveAuthenticator;
import io.jenkins.cli.shaded.org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import io.jenkins.cli.shaded.org.apache.sshd.server.channel.ChannelSessionFactory;
import io.jenkins.cli.shaded.org.apache.sshd.server.config.keys.DefaultAuthorizedKeysAuthenticator;
import io.jenkins.cli.shaded.org.apache.sshd.server.forward.DirectTcpipFactory;
import io.jenkins.cli.shaded.org.apache.sshd.server.global.CancelTcpipForwardHandler;
import io.jenkins.cli.shaded.org.apache.sshd.server.global.KeepAliveHandler;
import io.jenkins.cli.shaded.org.apache.sshd.server.global.NoMoreSessionsHandler;
import io.jenkins.cli.shaded.org.apache.sshd.server.global.OpenSshHostKeysHandler;
import io.jenkins.cli.shaded.org.apache.sshd.server.global.TcpipForwardHandler;
import io.jenkins.cli.shaded.org.apache.sshd.server.kex.DHGEXServer;
import io.jenkins.cli.shaded.org.apache.sshd.server.kex.DHGServer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class ServerBuilder
extends BaseBuilder<SshServer, ServerBuilder> {
    public static final Function<DHFactory, KeyExchangeFactory> DH2KEX = factory -> factory == null ? null : (factory.isGroupExchange() ? DHGEXServer.newFactory(factory) : DHGServer.newFactory(factory));
    public static final List<ChannelFactory> DEFAULT_CHANNEL_FACTORIES = Collections.unmodifiableList(Arrays.asList(ChannelSessionFactory.INSTANCE, DirectTcpipFactory.INSTANCE));
    public static final List<RequestHandler<ConnectionService>> DEFAULT_GLOBAL_REQUEST_HANDLERS = Collections.unmodifiableList(Arrays.asList(KeepAliveHandler.INSTANCE, NoMoreSessionsHandler.INSTANCE, TcpipForwardHandler.INSTANCE, CancelTcpipForwardHandler.INSTANCE, OpenSshHostKeysHandler.INSTANCE));
    public static final PublickeyAuthenticator DEFAULT_PUBLIC_KEY_AUTHENTICATOR = DefaultAuthorizedKeysAuthenticator.INSTANCE;
    public static final KeyboardInteractiveAuthenticator DEFAULT_INTERACTIVE_AUTHENTICATOR = DefaultKeyboardInteractiveAuthenticator.INSTANCE;
    public static final List<CompressionFactory> DEFAULT_COMPRESSION_FACTORIES = Collections.unmodifiableList(Arrays.asList(BuiltinCompressions.none, BuiltinCompressions.zlib, BuiltinCompressions.delayedZlib));
    public static final List<BuiltinSignatures> DEFAULT_SIGNATURE_PREFERENCE = Collections.unmodifiableList(Arrays.asList(BuiltinSignatures.nistp256_cert, BuiltinSignatures.nistp384_cert, BuiltinSignatures.nistp521_cert, BuiltinSignatures.ed25519_cert, BuiltinSignatures.rsaSHA512_cert, BuiltinSignatures.rsaSHA256_cert, BuiltinSignatures.rsa_cert, BuiltinSignatures.dsa_cert, BuiltinSignatures.nistp256, BuiltinSignatures.nistp384, BuiltinSignatures.nistp521, BuiltinSignatures.sk_ecdsa_sha2_nistp256, BuiltinSignatures.ed25519, BuiltinSignatures.sk_ssh_ed25519, BuiltinSignatures.rsaSHA512, BuiltinSignatures.rsaSHA256, BuiltinSignatures.rsa, BuiltinSignatures.dsa));
    protected PublickeyAuthenticator pubkeyAuthenticator;
    protected KeyboardInteractiveAuthenticator interactiveAuthenticator;

    public ServerBuilder interactiveAuthenticator(KeyboardInteractiveAuthenticator auth) {
        this.interactiveAuthenticator = auth;
        return this;
    }

    public ServerBuilder publickeyAuthenticator(PublickeyAuthenticator auth) {
        this.pubkeyAuthenticator = auth;
        return this;
    }

    @Override
    protected ServerBuilder fillWithDefaultValues() {
        super.fillWithDefaultValues();
        if (this.compressionFactories == null) {
            this.compressionFactories = ServerBuilder.setUpDefaultCompressionFactories(false);
        }
        if (this.signatureFactories == null) {
            this.signatureFactories = ServerBuilder.setUpDefaultSignatureFactories(false);
        }
        if (this.keyExchangeFactories == null) {
            this.keyExchangeFactories = ServerBuilder.setUpDefaultKeyExchanges(false);
        }
        if (this.channelFactories == null) {
            this.channelFactories = DEFAULT_CHANNEL_FACTORIES;
        }
        if (this.globalRequestHandlers == null) {
            this.globalRequestHandlers = DEFAULT_GLOBAL_REQUEST_HANDLERS;
        }
        if (this.pubkeyAuthenticator == null) {
            this.pubkeyAuthenticator = DEFAULT_PUBLIC_KEY_AUTHENTICATOR;
        }
        if (this.interactiveAuthenticator == null) {
            this.interactiveAuthenticator = DEFAULT_INTERACTIVE_AUTHENTICATOR;
        }
        if (this.factory == null) {
            this.factory = SshServer.DEFAULT_SSH_SERVER_FACTORY;
        }
        return (ServerBuilder)this.me();
    }

    @Override
    public SshServer build(boolean isFillWithDefaultValues) {
        SshServer server = (SshServer)super.build(isFillWithDefaultValues);
        server.setPublickeyAuthenticator(this.pubkeyAuthenticator);
        server.setKeyboardInteractiveAuthenticator(this.interactiveAuthenticator);
        return server;
    }

    public static List<NamedFactory<Signature>> setUpDefaultSignatureFactories(boolean ignoreUnsupported) {
        return NamedFactory.setUpBuiltinFactories(ignoreUnsupported, DEFAULT_SIGNATURE_PREFERENCE);
    }

    public static List<NamedFactory<Compression>> setUpDefaultCompressionFactories(boolean ignoreUnsupported) {
        return NamedFactory.setUpBuiltinFactories(ignoreUnsupported, DEFAULT_COMPRESSION_FACTORIES);
    }

    public static List<KeyExchangeFactory> setUpDefaultKeyExchanges(boolean ignoreUnsupported) {
        return NamedFactory.setUpTransformedFactories(ignoreUnsupported, DEFAULT_KEX_PREFERENCE, DH2KEX);
    }

    public static ServerBuilder builder() {
        return new ServerBuilder();
    }
}

