/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common;

import io.jenkins.cli.shaded.org.apache.sshd.common.PropertyResolver;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class PropertyResolverUtils {
    public static final String NONE_VALUE = "none";
    public static final NavigableSet<String> TRUE_VALUES = Collections.unmodifiableNavigableSet(GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, new String[]{"true", "t", "yes", "y", "on"}));
    public static final NavigableSet<String> FALSE_VALUES = Collections.unmodifiableNavigableSet(GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, new String[]{"false", "f", "no", "n", "off"}));

    private PropertyResolverUtils() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static boolean isNoneValue(String v) {
        return NONE_VALUE.equalsIgnoreCase(v);
    }

    public static long getLongProperty(PropertyResolver resolver, String name, long defaultValue) {
        return PropertyResolverUtils.toLong(PropertyResolverUtils.resolvePropertyValue(resolver, name), defaultValue);
    }

    public static long getLongProperty(Map<String, ?> props, String name, long defaultValue) {
        return PropertyResolverUtils.toLong(PropertyResolverUtils.resolvePropertyValue(props, name), defaultValue);
    }

    public static long toLong(Object value, long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return Long.parseLong(value.toString());
    }

    public static Long getLong(PropertyResolver resolver, String name) {
        return PropertyResolverUtils.toLong(PropertyResolverUtils.resolvePropertyValue(resolver, name));
    }

    public static Long getLong(Map<String, ?> props, String name) {
        return PropertyResolverUtils.toLong(PropertyResolverUtils.resolvePropertyValue(props, name));
    }

    public static Long toLong(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return Long.valueOf(value.toString());
    }

    public static <E extends Enum<E>> E toEnum(Class<E> enumType, Object value, boolean failIfNoMatch, Collection<E> available) {
        if (value == null) {
            return null;
        }
        if (enumType.isInstance(value)) {
            return (E)((Enum)enumType.cast(value));
        }
        if (value instanceof CharSequence) {
            String name = value.toString();
            if (GenericUtils.size(available) > 0) {
                for (Enum v : available) {
                    if (!name.equalsIgnoreCase(v.name())) continue;
                    return (E)v;
                }
            }
            if (failIfNoMatch) {
                throw new NoSuchElementException("No match found for " + enumType.getSimpleName() + "[" + name + "]");
            }
            return null;
        }
        throw new IllegalArgumentException("Bad value type for enum conversion: " + value.getClass().getSimpleName());
    }

    public static Object updateProperty(PropertyResolver resolver, String name, long value) {
        return PropertyResolverUtils.updateProperty(resolver.getProperties(), name, value);
    }

    public static Object updateProperty(Map<String, Object> props, String name, long value) {
        return PropertyResolverUtils.updateProperty(props, name, (Object)value);
    }

    public static int getIntProperty(PropertyResolver resolver, String name, int defaultValue) {
        return PropertyResolverUtils.toInteger(PropertyResolverUtils.resolvePropertyValue(resolver, name), defaultValue);
    }

    public static int getIntProperty(Map<String, ?> props, String name, int defaultValue) {
        return PropertyResolverUtils.toInteger(PropertyResolverUtils.resolvePropertyValue(props, name), defaultValue);
    }

    public static int toInteger(Object value, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.parseInt(value.toString());
    }

    public static Integer getInteger(PropertyResolver resolver, String name) {
        return PropertyResolverUtils.toInteger(PropertyResolverUtils.resolvePropertyValue(resolver, name));
    }

    public static Integer getInteger(Map<String, ?> props, String name) {
        return PropertyResolverUtils.toInteger(PropertyResolverUtils.resolvePropertyValue(props, name));
    }

    public static Integer toInteger(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.valueOf(value.toString());
    }

    public static Object updateProperty(PropertyResolver resolver, String name, int value) {
        return PropertyResolverUtils.updateProperty(resolver.getProperties(), name, value);
    }

    public static Object updateProperty(Map<String, Object> props, String name, int value) {
        return PropertyResolverUtils.updateProperty(props, name, (Object)value);
    }

    public static boolean getBooleanProperty(PropertyResolver resolver, String name, boolean defaultValue) {
        return PropertyResolverUtils.toBoolean(PropertyResolverUtils.getObject(resolver, name), defaultValue);
    }

    public static boolean getBooleanProperty(Map<String, ?> props, String name, boolean defaultValue) {
        return PropertyResolverUtils.toBoolean(PropertyResolverUtils.getObject(props, name), defaultValue);
    }

    public static boolean toBoolean(Object value, boolean defaultValue) {
        Boolean bool = PropertyResolverUtils.toBoolean(value);
        if (bool == null) {
            return defaultValue;
        }
        return bool;
    }

    public static Boolean getBoolean(PropertyResolver resolver, String name) {
        Object propValue = PropertyResolverUtils.resolvePropertyValue(resolver, name);
        return PropertyResolverUtils.toBoolean(propValue);
    }

    public static Boolean getBoolean(Map<String, ?> props, String name) {
        Object propValue = PropertyResolverUtils.resolvePropertyValue(props, name);
        return PropertyResolverUtils.toBoolean(propValue);
    }

    public static Boolean toBoolean(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof CharSequence) {
            return PropertyResolverUtils.parseBoolean(value.toString());
        }
        throw new UnsupportedOperationException("Cannot convert " + value.getClass().getSimpleName() + "[" + value + "] to boolean");
    }

    public static Boolean parseBoolean(String value) {
        if (GenericUtils.isEmpty(value)) {
            return null;
        }
        if (TRUE_VALUES.contains(value)) {
            return Boolean.TRUE;
        }
        if (FALSE_VALUES.contains(value)) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Unknown boolean value: '" + value + "'");
    }

    public static Object updateProperty(PropertyResolver resolver, String name, boolean value) {
        return PropertyResolverUtils.updateProperty(resolver.getProperties(), name, value);
    }

    public static Object updateProperty(Map<String, Object> props, String name, boolean value) {
        return PropertyResolverUtils.updateProperty(props, name, (Object)value);
    }

    public static String getStringProperty(PropertyResolver resolver, String name, String defaultValue) {
        String value = PropertyResolverUtils.getString(resolver, name);
        if (GenericUtils.isEmpty(value)) {
            return defaultValue;
        }
        return value;
    }

    public static String getStringProperty(Map<String, ?> props, String name, String defaultValue) {
        Object value = PropertyResolverUtils.resolvePropertyValue(props, name);
        if (value == null) {
            return defaultValue;
        }
        return Objects.toString(value);
    }

    public static Charset getCharset(PropertyResolver resolver, String name, Charset defaultValue) {
        Object value = PropertyResolverUtils.getObject(resolver, name);
        return value == null ? defaultValue : PropertyResolverUtils.toCharset(value);
    }

    public static Charset getCharset(Map<String, ?> props, String name, Charset defaultValue) {
        Object value = PropertyResolverUtils.getObject(props, name);
        return value == null ? defaultValue : PropertyResolverUtils.toCharset(value);
    }

    public static Charset toCharset(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Charset) {
            return (Charset)value;
        }
        if (value instanceof CharSequence) {
            return Charset.forName(value.toString());
        }
        throw new IllegalArgumentException("Invalid charset conversion value: " + value);
    }

    public static String getString(PropertyResolver resolver, String name) {
        Object value = PropertyResolverUtils.getObject(resolver, name);
        return Objects.toString(value, null);
    }

    public static String getString(Map<String, ?> props, String name) {
        Object value = PropertyResolverUtils.getObject(props, name);
        return Objects.toString(value, null);
    }

    public static Object getObject(PropertyResolver resolver, String name) {
        return PropertyResolverUtils.resolvePropertyValue(resolver, name);
    }

    public static Object getObject(PropertyResolver resolver, String name, Object defaultValue) {
        Object value = PropertyResolverUtils.resolvePropertyValue(resolver, name);
        return value != null ? value : defaultValue;
    }

    public static Object getObject(Map<String, ?> props, String name) {
        return PropertyResolverUtils.resolvePropertyValue(props, name);
    }

    public static Object resolvePropertyValue(Map<String, ?> props, String name) {
        String key = ValidateUtils.checkNotNullAndNotEmpty(name, "No property name");
        return props != null ? props.get(key) : null;
    }

    public static Object updateProperty(PropertyResolver resolver, String name, Object value) {
        return PropertyResolverUtils.updateProperty(resolver.getProperties(), name, value);
    }

    public static Object updateProperty(Map<String, Object> props, String name, Object value) {
        String key = ValidateUtils.checkNotNullAndNotEmpty(name, "No property name");
        if (value == null || value instanceof CharSequence && GenericUtils.isEmpty((CharSequence)value)) {
            return props.remove(key);
        }
        return props.put(key, value);
    }

    public static Object resolvePropertyValue(PropertyResolver resolver, String name) {
        String key = ValidateUtils.checkNotNullAndNotEmpty(name, "No property name");
        for (PropertyResolver r = resolver; r != null; r = r.getParentPropertyResolver()) {
            Map<String, Object> props = r.getProperties();
            Object value = PropertyResolverUtils.getObject(props, key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static Map<String, Object> resolvePropertiesSource(PropertyResolver resolver, String name) {
        String key = ValidateUtils.checkNotNullAndNotEmpty(name, "No property name");
        for (PropertyResolver r = resolver; r != null; r = r.getParentPropertyResolver()) {
            Map<String, Object> props = r.getProperties();
            Object value = PropertyResolverUtils.getObject(props, key);
            if (value == null) continue;
            return props;
        }
        return null;
    }

    public static PropertyResolver toPropertyResolver(Properties props) {
        if (GenericUtils.isEmpty(props)) {
            return PropertyResolver.EMPTY;
        }
        Set<String> names = props.stringPropertyNames();
        ConcurrentHashMap<String, String> propsMap = new ConcurrentHashMap<String, String>(GenericUtils.size(names));
        for (String key : names) {
            String value = props.getProperty(key);
            if (value == null) continue;
            propsMap.put(key, value);
        }
        return PropertyResolverUtils.toPropertyResolver(propsMap);
    }

    public static PropertyResolver toPropertyResolver(Map<String, ?> props) {
        return PropertyResolverUtils.toPropertyResolver(props, null);
    }

    public static PropertyResolver toPropertyResolver(final Map<String, ?> props, final PropertyResolver parent) {
        return new PropertyResolver(){

            @Override
            public PropertyResolver getParentPropertyResolver() {
                return parent;
            }

            @Override
            public Map<String, Object> getProperties() {
                return props;
            }

            public String toString() {
                return Objects.toString(props);
            }
        };
    }
}

