/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.config.hosts;

import io.jenkins.cli.shaded.org.apache.sshd.client.config.hosts.HostConfigEntryResolver;
import io.jenkins.cli.shaded.org.apache.sshd.client.config.hosts.HostPatternsHolder;
import io.jenkins.cli.shaded.org.apache.sshd.common.auth.MutableUserHolder;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.ConfigFileReaderSupport;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.IdentityUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.PublicKeyEntry;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.MapEntryUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.OsUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.IoUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.NoCloseInputStream;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.NoCloseOutputStream;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.NoCloseReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StreamCorruptedException;
import java.net.InetAddress;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.TreeMap;

public class HostConfigEntry
extends HostPatternsHolder
implements MutableUserHolder {
    public static final String STD_CONFIG_FILENAME = "config";
    public static final String HOST_CONFIG_PROP = "Host";
    public static final String HOST_NAME_CONFIG_PROP = "HostName";
    public static final String PORT_CONFIG_PROP = "Port";
    public static final String USER_CONFIG_PROP = "User";
    public static final String IDENTITY_FILE_CONFIG_PROP = "IdentityFile";
    public static final String EXCLUSIVE_IDENTITIES_CONFIG_PROP = "IdentitiesOnly";
    public static final boolean DEFAULT_EXCLUSIVE_IDENTITIES = false;
    public static final NavigableSet<String> EXPLICIT_PROPERTIES = Collections.unmodifiableNavigableSet(GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, new String[]{"Host", "HostName", "Port", "User", "IdentityFile", "IdentitiesOnly"}));
    public static final String MULTI_VALUE_SEPARATORS = " ,";
    public static final char HOME_TILDE_CHAR = '~';
    public static final char PATH_MACRO_CHAR = '%';
    public static final char LOCAL_HOME_MACRO = 'd';
    public static final char LOCAL_USER_MACRO = 'u';
    public static final char LOCAL_HOST_MACRO = 'l';
    public static final char REMOTE_HOST_MACRO = 'h';
    public static final char REMOTE_USER_MACRO = 'r';
    public static final char REMOTE_PORT_MACRO = 'p';
    private String host;
    private String hostName;
    private int port;
    private String username;
    private Boolean exclusiveIdentites;
    private Collection<String> identities = Collections.emptyList();
    private Map<String, String> properties = Collections.emptyMap();

    public HostConfigEntry() {
    }

    public HostConfigEntry(String pattern, String host, int port, String username) {
        this.setHost(pattern);
        this.setHostName(host);
        this.setPort(port);
        this.setUsername(username);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
        this.setPatterns(HostConfigEntry.parsePatterns(HostConfigEntry.parseConfigValue(host)));
    }

    public void setHost(Collection<String> patterns) {
        this.host = GenericUtils.join(ValidateUtils.checkNotNullAndNotEmpty(patterns, "No patterns", new Object[0]), ',');
        this.setPatterns(HostConfigEntry.parsePatterns(patterns));
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String resolveHostName(String originalHost) {
        return HostConfigEntry.resolveHostName(originalHost, this.getHostName());
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int resolvePort(int originalPort) {
        return HostConfigEntry.resolvePort(originalPort, this.getPort());
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    public String resolveUsername(String originalUser) {
        return HostConfigEntry.resolveUsername(originalUser, this.getUsername());
    }

    public Collection<String> getIdentities() {
        return this.identities;
    }

    public void addIdentity(Path path) {
        this.addIdentity(Objects.requireNonNull(path, "No path").toAbsolutePath().normalize().toString());
    }

    public void addIdentity(String id) {
        String path = ValidateUtils.checkNotNullAndNotEmpty(id, "No identity provided");
        if (GenericUtils.isEmpty(this.identities)) {
            this.identities = new LinkedList<String>();
        }
        this.identities.add(path);
    }

    public void setIdentities(Collection<String> identities) {
        this.identities = identities == null ? Collections.emptyList() : identities;
    }

    public boolean isIdentitiesOnly() {
        return this.exclusiveIdentites == null ? false : this.exclusiveIdentites;
    }

    public void setIdentitiesOnly(boolean identitiesOnly) {
        this.exclusiveIdentites = identitiesOnly;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getProperty(String name) {
        return this.getProperty(name, null);
    }

    public String getProperty(String name, String defaultValue) {
        String key = ValidateUtils.checkNotNullAndNotEmpty(name, "No property name");
        Map<String, String> props = this.getProperties();
        if (GenericUtils.isEmpty(props)) {
            return defaultValue;
        }
        String value = props.get(key);
        if (GenericUtils.isEmpty(value)) {
            return defaultValue;
        }
        return value;
    }

    public boolean processGlobalValues(HostConfigEntry globalEntry) {
        if (globalEntry == null || this == globalEntry) {
            return false;
        }
        boolean modified = false;
        modified = this.updateGlobalPort(globalEntry.getPort()) || modified;
        modified = this.updateGlobalHostName(globalEntry.getHostName()) || modified;
        modified = this.updateGlobalUserName(globalEntry.getUsername()) || modified;
        modified = this.updateGlobalIdentities(globalEntry.getIdentities()) || modified;
        modified = this.updateGlobalIdentityOnly(globalEntry.isIdentitiesOnly()) || modified;
        Map<String, String> updated = this.updateGlobalProperties(globalEntry.getProperties());
        modified = GenericUtils.size(updated) > 0 || modified;
        return modified;
    }

    public Map<String, String> updateGlobalProperties(Map<String, String> props) {
        if (GenericUtils.isEmpty(props)) {
            return Collections.emptyMap();
        }
        TreeMap<String, String> updated = null;
        for (Map.Entry<String, String> pe : props.entrySet()) {
            String key = pe.getKey();
            String curValue = this.getProperty(key);
            if (GenericUtils.length(curValue) > 0) continue;
            String newValue = pe.getValue();
            this.setProperty(key, newValue);
            if (updated == null) {
                updated = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            }
            updated.put(key, newValue);
        }
        if (updated == null) {
            return Collections.emptyMap();
        }
        return updated;
    }

    public boolean updateGlobalIdentities(Collection<String> ids) {
        if (GenericUtils.isEmpty(ids) || GenericUtils.size(this.getIdentities()) > 0) {
            return false;
        }
        for (String id : ids) {
            this.addIdentity(id);
        }
        return true;
    }

    public boolean updateGlobalUserName(String user) {
        if (GenericUtils.isEmpty(user) || GenericUtils.length(this.getUsername()) > 0) {
            return false;
        }
        this.setUsername(user);
        return true;
    }

    public boolean updateGlobalHostName(String name) {
        if (GenericUtils.isEmpty(name) || GenericUtils.length(this.getHostName()) > 0) {
            return false;
        }
        this.setHostName(name);
        return true;
    }

    public boolean updateGlobalPort(int portValue) {
        if (portValue <= 0 || this.getPort() > 0) {
            return false;
        }
        this.setPort(portValue);
        return true;
    }

    public boolean updateGlobalIdentityOnly(boolean identitiesOnly) {
        if (this.exclusiveIdentites != null) {
            return false;
        }
        this.setIdentitiesOnly(identitiesOnly);
        return true;
    }

    public void processProperty(String name, Collection<String> valsList, boolean ignoreAlreadyInitialized) {
        String key = ValidateUtils.checkNotNullAndNotEmpty(name, "No property name");
        String joinedValue = GenericUtils.join(valsList, ',');
        this.appendPropertyValue(key, joinedValue);
        if (HOST_NAME_CONFIG_PROP.equalsIgnoreCase(key)) {
            ValidateUtils.checkTrue(GenericUtils.size(valsList) == 1, "Multiple target hosts N/A: %s", (Object)joinedValue);
            String curValue = this.getHostName();
            ValidateUtils.checkTrue(GenericUtils.isEmpty(curValue) || ignoreAlreadyInitialized, "Already initialized %s: %s", key, curValue);
            this.setHostName(joinedValue);
        } else if (PORT_CONFIG_PROP.equalsIgnoreCase(key)) {
            ValidateUtils.checkTrue(GenericUtils.size(valsList) == 1, "Multiple target ports N/A: %s", (Object)joinedValue);
            int curValue = this.getPort();
            ValidateUtils.checkTrue(curValue <= 0 || ignoreAlreadyInitialized, "Already initialized %s: %d", key, curValue);
            int newValue = Integer.parseInt(joinedValue);
            ValidateUtils.checkTrue(newValue > 0, "Bad new port value: %d", newValue);
            this.setPort(newValue);
        } else if (USER_CONFIG_PROP.equalsIgnoreCase(key)) {
            ValidateUtils.checkTrue(GenericUtils.size(valsList) == 1, "Multiple target users N/A: %s", (Object)joinedValue);
            String curValue = this.getUsername();
            ValidateUtils.checkTrue(GenericUtils.isEmpty(curValue) || ignoreAlreadyInitialized, "Already initialized %s: %s", key, curValue);
            this.setUsername(joinedValue);
        } else if (IDENTITY_FILE_CONFIG_PROP.equalsIgnoreCase(key)) {
            ValidateUtils.checkTrue(GenericUtils.size(valsList) > 0, "No identity files specified");
            for (String id : valsList) {
                this.addIdentity(id);
            }
        } else if (EXCLUSIVE_IDENTITIES_CONFIG_PROP.equalsIgnoreCase(key)) {
            this.setIdentitiesOnly(ConfigFileReaderSupport.parseBooleanValue(ValidateUtils.checkNotNullAndNotEmpty(joinedValue, "No identities option value")));
        }
    }

    public String appendPropertyValue(String name, String value) {
        String key = ValidateUtils.checkNotNullAndNotEmpty(name, "No property name");
        String curVal = this.getProperty(key);
        if (GenericUtils.isEmpty(value)) {
            return curVal;
        }
        if (GenericUtils.isEmpty(curVal)) {
            return this.setProperty(key, value);
        }
        return this.setProperty(key, curVal + ',' + value);
    }

    public String setProperty(String name, String value) {
        if (GenericUtils.isEmpty(value)) {
            return this.removeProperty(name);
        }
        String key = ValidateUtils.checkNotNullAndNotEmpty(name, "No property name");
        if (GenericUtils.isEmpty(this.properties)) {
            this.properties = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        }
        return this.properties.put(key, value);
    }

    public String removeProperty(String name) {
        String key = ValidateUtils.checkNotNullAndNotEmpty(name, "No property name");
        Map<String, String> props = this.getProperties();
        if (GenericUtils.isEmpty(props)) {
            return null;
        }
        return props.remove(key);
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties == null ? Collections.emptyMap() : properties;
    }

    public <A extends Appendable> A append(A sb) throws IOException {
        sb.append(HOST_CONFIG_PROP).append(' ').append(ValidateUtils.checkNotNullAndNotEmpty(this.getHost(), "No host pattern")).append(IoUtils.EOL);
        HostConfigEntry.appendNonEmptyProperty(sb, HOST_NAME_CONFIG_PROP, this.getHostName());
        HostConfigEntry.appendNonEmptyPort(sb, PORT_CONFIG_PROP, this.getPort());
        HostConfigEntry.appendNonEmptyProperty(sb, USER_CONFIG_PROP, this.getUsername());
        HostConfigEntry.appendNonEmptyValues(sb, IDENTITY_FILE_CONFIG_PROP, this.getIdentities());
        if (this.exclusiveIdentites != null) {
            HostConfigEntry.appendNonEmptyProperty(sb, EXCLUSIVE_IDENTITIES_CONFIG_PROP, ConfigFileReaderSupport.yesNoValueOf(this.exclusiveIdentites));
        }
        HostConfigEntry.appendNonEmptyProperties(sb, this.getProperties());
        return sb;
    }

    public String toString() {
        return this.getHost() + ": " + this.getUsername() + "@" + this.getHostName() + ":" + this.getPort();
    }

    public static <A extends Appendable> A appendNonEmptyPort(A sb, String name, int port) throws IOException {
        return HostConfigEntry.appendNonEmptyProperty(sb, name, port > 0 ? Integer.toString(port) : null);
    }

    public static <A extends Appendable> A appendNonEmptyProperties(A sb, Map<String, ?> props) throws IOException {
        if (GenericUtils.isEmpty(props)) {
            return sb;
        }
        for (Map.Entry<String, ?> pe : props.entrySet()) {
            String name = pe.getKey();
            if (EXPLICIT_PROPERTIES.contains(name)) continue;
            HostConfigEntry.appendNonEmptyProperty(sb, name, pe.getValue());
        }
        return sb;
    }

    public static <A extends Appendable> A appendNonEmptyProperty(A sb, String name, Object value) throws IOException {
        String s = Objects.toString(value, null);
        String[] vals = GenericUtils.split(s, ',');
        return HostConfigEntry.appendNonEmptyValues(sb, name, vals);
    }

    public static <A extends Appendable> A appendNonEmptyValues(A sb, String name, Object ... values) throws IOException {
        return HostConfigEntry.appendNonEmptyValues(sb, name, GenericUtils.isEmpty(values) ? Collections.emptyList() : Arrays.asList(values));
    }

    public static <A extends Appendable> A appendNonEmptyValues(A sb, String name, Collection<?> values) throws IOException {
        String k = ValidateUtils.checkNotNullAndNotEmpty(name, "No property name");
        if (GenericUtils.isEmpty(values)) {
            return sb;
        }
        for (Object v : values) {
            sb.append("    ").append(k).append(' ').append(Objects.toString(v)).append(IoUtils.EOL);
        }
        return sb;
    }

    public static HostConfigEntryResolver toHostConfigEntryResolver(Collection<? extends HostConfigEntry> entries) {
        if (GenericUtils.isEmpty(entries)) {
            return HostConfigEntryResolver.EMPTY;
        }
        return (host1, port1, lclAddress, username1, ctx) -> {
            HostConfigEntry match;
            List<HostConfigEntry> matches = HostConfigEntry.findMatchingEntries(host1, entries);
            int numMatches = GenericUtils.size(matches);
            if (numMatches <= 0) {
                return null;
            }
            HostConfigEntry hostConfigEntry = match = numMatches == 1 ? matches.get(0) : HostConfigEntry.findBestMatch(matches);
            if (match == null) {
                ValidateUtils.throwIllegalArgumentException("No best match found for %s@%s:%d out of %d matches", username1, host1, port1, numMatches);
            }
            return HostConfigEntry.normalizeEntry(match, host1, port1, username1);
        };
    }

    public static HostConfigEntry normalizeEntry(HostConfigEntry entry, String host, int port, String username) throws IOException {
        Collection<String> ids;
        if (entry == null) {
            return null;
        }
        HostConfigEntry normal = new HostConfigEntry();
        normal.setHost(host);
        normal.setHostName(entry.resolveHostName(host));
        normal.setPort(entry.resolvePort(port));
        normal.setUsername(entry.resolveUsername(username));
        Map<String, String> props = entry.getProperties();
        if (GenericUtils.size(props) > 0) {
            normal.setProperties(((MapEntryUtils.NavigableMapBuilder)MapEntryUtils.NavigableMapBuilder.builder(String.CASE_INSENSITIVE_ORDER).putAll(props)).build());
        }
        if (GenericUtils.isEmpty(ids = entry.getIdentities())) {
            return normal;
        }
        normal.setIdentities(Collections.emptyList());
        for (String id : ids) {
            String path = HostConfigEntry.resolveIdentityFilePath(id, host, port, username);
            normal.addIdentity(path);
        }
        return normal;
    }

    public static String resolveHostName(String originalName, String entryName) {
        if (GenericUtils.isEmpty(entryName)) {
            return originalName;
        }
        return entryName;
    }

    public static String resolveUsername(String originalUser, String entryUser) {
        if (GenericUtils.isEmpty(entryUser)) {
            return originalUser;
        }
        return entryUser;
    }

    public static int resolvePort(int originalPort, int entryPort) {
        if (entryPort <= 0) {
            return originalPort;
        }
        return entryPort;
    }

    public static List<HostConfigEntry> readHostConfigEntries(Path path, OpenOption ... options) throws IOException {
        try (InputStream input = Files.newInputStream(path, options);){
            List<HostConfigEntry> list = HostConfigEntry.readHostConfigEntries(input, true);
            return list;
        }
    }

    public static List<HostConfigEntry> readHostConfigEntries(URL url) throws IOException {
        try (InputStream input = url.openStream();){
            List<HostConfigEntry> list = HostConfigEntry.readHostConfigEntries(input, true);
            return list;
        }
    }

    public static List<HostConfigEntry> readHostConfigEntries(InputStream inStream, boolean okToClose) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(NoCloseInputStream.resolveInputStream(inStream, okToClose), StandardCharsets.UTF_8);){
            List<HostConfigEntry> list = HostConfigEntry.readHostConfigEntries(reader, true);
            return list;
        }
    }

    public static List<HostConfigEntry> readHostConfigEntries(Reader rdr, boolean okToClose) throws IOException {
        try (BufferedReader buf = new BufferedReader(NoCloseReader.resolveReader(rdr, okToClose));){
            List<HostConfigEntry> list = HostConfigEntry.readHostConfigEntries(buf);
            return list;
        }
    }

    public static List<HostConfigEntry> readHostConfigEntries(BufferedReader rdr) throws IOException {
        HostConfigEntry curEntry = null;
        HostConfigEntry globalEntry = null;
        List<HostConfigEntry> entries = null;
        int lineNumber = 1;
        String line = rdr.readLine();
        while (line != null) {
            int pos;
            if (!GenericUtils.isEmpty(line = GenericUtils.replaceWhitespaceAndTrim(line)) && (pos = line.indexOf(35)) != 0) {
                if (pos > 0) {
                    line = line.substring(0, pos);
                    line = line.trim();
                }
                if ((pos = line.indexOf(32)) < 0) {
                    pos = line.indexOf(61);
                }
                if (pos < 0) {
                    throw new StreamCorruptedException("No configuration value delimiter at line " + lineNumber + ": " + line);
                }
                String key = line.substring(0, pos);
                String value = line.substring(pos + 1);
                List<String> valsList = HostConfigEntry.parseConfigValue(value);
                if (HOST_CONFIG_PROP.equalsIgnoreCase(key)) {
                    if (GenericUtils.isEmpty(valsList)) {
                        throw new StreamCorruptedException("Missing host pattern(s) at line " + lineNumber + ": " + line);
                    }
                    for (String name : valsList) {
                        if (!ALL_HOSTS_PATTERN.equalsIgnoreCase(name) || globalEntry == null) continue;
                        throw new StreamCorruptedException("Overriding the global section with a specific one at line " + lineNumber + ": " + line);
                    }
                    if (curEntry != null) {
                        curEntry.processGlobalValues(globalEntry);
                    }
                    entries = HostConfigEntry.updateEntriesList(entries, curEntry);
                    curEntry = new HostConfigEntry();
                    curEntry.setHost(valsList);
                } else if (curEntry == null) {
                    curEntry = new HostConfigEntry();
                    curEntry.setHost(Collections.singletonList(ALL_HOSTS_PATTERN));
                    globalEntry = curEntry;
                }
                try {
                    curEntry.processProperty(key, valsList, false);
                }
                catch (RuntimeException e) {
                    throw new StreamCorruptedException("Failed (" + e.getClass().getSimpleName() + ") to process line #" + lineNumber + " (" + line + "): " + e.getMessage());
                }
            }
            line = rdr.readLine();
            ++lineNumber;
        }
        if (curEntry != null) {
            curEntry.processGlobalValues(globalEntry);
        }
        if ((entries = HostConfigEntry.updateEntriesList(entries, curEntry)) == null) {
            return Collections.emptyList();
        }
        return entries;
    }

    public static HostConfigEntry findBestMatch(Collection<? extends HostConfigEntry> matches) {
        if (GenericUtils.isEmpty(matches)) {
            return null;
        }
        return HostConfigEntry.findBestMatch(matches.iterator());
    }

    public static HostConfigEntry findBestMatch(Iterable<? extends HostConfigEntry> matches) {
        if (matches == null) {
            return null;
        }
        return HostConfigEntry.findBestMatch(matches.iterator());
    }

    public static HostConfigEntry findBestMatch(Iterator<? extends HostConfigEntry> matches) {
        if (matches == null || !matches.hasNext()) {
            return null;
        }
        HostConfigEntry candidate = matches.next();
        int wildcardMatches = 0;
        while (matches.hasNext()) {
            HostConfigEntry entry = matches.next();
            String entryPattern = entry.getHost();
            String candidatePattern = candidate.getHost();
            if (ALL_HOSTS_PATTERN.equalsIgnoreCase(candidatePattern)) {
                if (ALL_HOSTS_PATTERN.equalsIgnoreCase(entryPattern)) {
                    ++wildcardMatches;
                    continue;
                }
                candidate = entry;
                wildcardMatches = 0;
                continue;
            }
            if (HostConfigEntry.isSpecificHostPattern(entryPattern)) {
                if (HostConfigEntry.isSpecificHostPattern(candidatePattern)) {
                    return null;
                }
                candidate = entry;
                wildcardMatches = 0;
                continue;
            }
            ++wildcardMatches;
        }
        String candidatePattern = candidate.getHost();
        if (wildcardMatches <= 0 || HostConfigEntry.isSpecificHostPattern(candidatePattern)) {
            return candidate;
        }
        return null;
    }

    public static List<HostConfigEntry> updateEntriesList(List<HostConfigEntry> entries, HostConfigEntry curEntry) {
        if (curEntry == null) {
            return entries;
        }
        if (entries == null) {
            entries = new ArrayList<HostConfigEntry>();
        }
        entries.add(curEntry);
        return entries;
    }

    public static void writeHostConfigEntries(Path path, Collection<? extends HostConfigEntry> entries, OpenOption ... options) throws IOException {
        try (OutputStream outputStream = Files.newOutputStream(path, options);){
            HostConfigEntry.writeHostConfigEntries(outputStream, true, entries);
        }
    }

    public static void writeHostConfigEntries(OutputStream outputStream, boolean okToClose, Collection<? extends HostConfigEntry> entries) throws IOException {
        if (GenericUtils.isEmpty(entries)) {
            return;
        }
        try (OutputStreamWriter w = new OutputStreamWriter(NoCloseOutputStream.resolveOutputStream(outputStream, okToClose), StandardCharsets.UTF_8);){
            HostConfigEntry.appendHostConfigEntries(w, entries);
        }
    }

    public static <A extends Appendable> A appendHostConfigEntries(A sb, Collection<? extends HostConfigEntry> entries) throws IOException {
        if (GenericUtils.isEmpty(entries)) {
            return sb;
        }
        for (HostConfigEntry hostConfigEntry : entries) {
            hostConfigEntry.append(sb);
        }
        return sb;
    }

    public static List<String> parseConfigValue(String value) {
        String s = GenericUtils.replaceWhitespaceAndTrim(value);
        if (GenericUtils.isEmpty(s)) {
            return Collections.emptyList();
        }
        for (int index = 0; index < MULTI_VALUE_SEPARATORS.length(); ++index) {
            char sep = MULTI_VALUE_SEPARATORS.charAt(index);
            int pos = s.indexOf(sep);
            if (pos < 0) continue;
            String[] vals = GenericUtils.split(s, sep);
            if (GenericUtils.isEmpty(vals)) {
                return Collections.emptyList();
            }
            return Arrays.asList(vals);
        }
        return Collections.singletonList(s);
    }

    public static String resolveIdentityFilePath(String id, String host, int port, String username) throws IOException {
        if (GenericUtils.isEmpty(id)) {
            return id;
        }
        String path = id.replace('/', File.separatorChar);
        String[] elements = GenericUtils.split(path, File.separatorChar);
        StringBuilder sb = new StringBuilder(path.length() + 64);
        for (int index = 0; index < elements.length; ++index) {
            String elem = elements[index];
            if (index > 0) {
                sb.append(File.separatorChar);
            }
            for (int curPos = 0; curPos < elem.length(); ++curPos) {
                char ch = elem.charAt(curPos);
                if (ch == '~') {
                    ValidateUtils.checkTrue(curPos == 0 && index == 0, "Home tilde must be first: %s", (Object)id);
                    HostConfigEntry.appendUserHome(sb);
                    continue;
                }
                if (ch == '%') {
                    ValidateUtils.checkTrue(++curPos < elem.length(), "Missing macro modifier in %s", (Object)id);
                    ch = elem.charAt(curPos);
                    switch (ch) {
                        case '%': {
                            sb.append(ch);
                            break;
                        }
                        case 'd': {
                            ValidateUtils.checkTrue(curPos == 1 && index == 0, "Home macro must be first: %s", (Object)id);
                            HostConfigEntry.appendUserHome(sb);
                            break;
                        }
                        case 'u': {
                            sb.append(ValidateUtils.checkNotNullAndNotEmpty(OsUtils.getCurrentUser(), "No local user name value"));
                            break;
                        }
                        case 'l': {
                            InetAddress address = Objects.requireNonNull(InetAddress.getLocalHost(), "No local address");
                            sb.append(ValidateUtils.checkNotNullAndNotEmpty(address.getHostName(), "No local name"));
                            break;
                        }
                        case 'h': {
                            sb.append(ValidateUtils.checkNotNullAndNotEmpty(host, "No remote host provided"));
                            break;
                        }
                        case 'r': {
                            sb.append(ValidateUtils.checkNotNullAndNotEmpty(username, "No remote user provided"));
                            break;
                        }
                        case 'p': {
                            ValidateUtils.checkTrue(port > 0, "Bad remote port value: %d", port);
                            sb.append(port);
                            break;
                        }
                        default: {
                            ValidateUtils.throwIllegalArgumentException("Bad modifier '%s' in %s", String.valueOf(ch), id);
                            break;
                        }
                    }
                    continue;
                }
                sb.append(ch);
            }
        }
        return sb.toString();
    }

    public static StringBuilder appendUserHome(StringBuilder sb) {
        return HostConfigEntry.appendUserHome(sb, IdentityUtils.getUserHomeFolder());
    }

    public static StringBuilder appendUserHome(StringBuilder sb, Path userHome) {
        return HostConfigEntry.appendUserHome(sb, Objects.requireNonNull(userHome, "No user home folder").toString());
    }

    public static StringBuilder appendUserHome(StringBuilder sb, String userHome) {
        if (GenericUtils.isEmpty(userHome)) {
            return sb;
        }
        sb.append(userHome);
        int len = sb.length();
        if (sb.charAt(len - 1) == File.separatorChar) {
            sb.setLength(len - 1);
        }
        return sb;
    }

    public static Path getDefaultHostConfigFile() {
        return LazyDefaultConfigFileHolder.CONFIG_FILE;
    }

    private static final class LazyDefaultConfigFileHolder {
        private static final Path CONFIG_FILE = PublicKeyEntry.getDefaultKeysFolderPath().resolve("config");

        private LazyDefaultConfigFileHolder() {
            throw new UnsupportedOperationException("No instance allowed");
        }
    }
}

