/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.auth.password;

import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;

@FunctionalInterface
public interface PasswordIdentityProvider {
    public static final PasswordIdentityProvider EMPTY_PASSWORDS_PROVIDER = new PasswordIdentityProvider(){

        @Override
        public Iterable<String> loadPasswords() {
            return Collections.emptyList();
        }

        public String toString() {
            return "EMPTY";
        }
    };
    public static final Function<PasswordIdentityProvider, Iterable<String>> LOADER = p -> p == null ? Collections.emptyList() : p.loadPasswords();

    public Iterable<String> loadPasswords();

    public static Iterator<String> iteratorOf(PasswordIdentityProvider identities, PasswordIdentityProvider passwords) {
        return PasswordIdentityProvider.iteratorOf(PasswordIdentityProvider.resolvePasswordIdentityProvider(identities, passwords));
    }

    public static Iterator<String> iteratorOf(PasswordIdentityProvider provider) {
        return GenericUtils.iteratorOf(provider == null ? null : provider.loadPasswords());
    }

    public static PasswordIdentityProvider resolvePasswordIdentityProvider(PasswordIdentityProvider identities, PasswordIdentityProvider passwords) {
        if (passwords == null || identities == passwords) {
            return identities;
        }
        if (identities == null) {
            return passwords;
        }
        return PasswordIdentityProvider.multiProvider(identities, passwords);
    }

    public static PasswordIdentityProvider multiProvider(PasswordIdentityProvider ... providers) {
        return PasswordIdentityProvider.multiProvider(GenericUtils.asList(providers));
    }

    public static PasswordIdentityProvider multiProvider(Collection<? extends PasswordIdentityProvider> providers) {
        return GenericUtils.isEmpty(providers) ? EMPTY_PASSWORDS_PROVIDER : PasswordIdentityProvider.wrapPasswords(PasswordIdentityProvider.iterableOf(providers));
    }

    public static Iterable<String> iterableOf(Collection<? extends PasswordIdentityProvider> providers) {
        Iterable<Supplier> passwordSuppliers = GenericUtils.wrapIterable(providers, p -> p::loadPasswords);
        return GenericUtils.multiIterableSuppliers(passwordSuppliers);
    }

    public static PasswordIdentityProvider wrapPasswords(String ... passwords) {
        return PasswordIdentityProvider.wrapPasswords(GenericUtils.asList(passwords));
    }

    public static PasswordIdentityProvider wrapPasswords(Iterable<String> passwords) {
        return passwords == null ? EMPTY_PASSWORDS_PROVIDER : () -> passwords;
    }
}

