/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.session.helpers;

import io.jenkins.cli.shaded.org.apache.sshd.common.session.Session;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.SessionListener;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.helpers.SessionHelper;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.logging.AbstractLoggingBean;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class SessionTimeoutListener
extends AbstractLoggingBean
implements SessionListener,
Runnable {
    protected final Set<SessionHelper> sessions = new CopyOnWriteArraySet<SessionHelper>();

    @Override
    public void sessionCreated(Session session) {
        if (session instanceof SessionHelper && (session.getAuthTimeout() > 0L || session.getIdleTimeout() > 0L)) {
            this.sessions.add((SessionHelper)session);
            if (this.log.isDebugEnabled()) {
                this.log.debug("sessionCreated({}) tracking", (Object)session);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("sessionCreated({}) not tracked", (Object)session);
        }
    }

    @Override
    public void sessionException(Session session, Throwable t) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("sessionException({}) {}: {}", session, t.getClass().getSimpleName(), t.getMessage());
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("sessionException(" + session + ") details", t);
        }
        this.sessionClosed(session);
    }

    @Override
    public void sessionClosed(Session s) {
        if (this.sessions.remove(s)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sessionClosed({}) un-tracked", (Object)s);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("sessionClosed({}) not tracked", (Object)s);
        }
    }

    @Override
    public void run() {
        boolean debugEnabled = this.log.isDebugEnabled();
        for (SessionHelper session : this.sessions) {
            try {
                session.checkForTimeouts();
            }
            catch (Exception e) {
                this.log.warn(e.getClass().getSimpleName() + " while checking session=" + session + " timeouts: " + e.getMessage(), e);
                if (!debugEnabled) continue;
                this.log.warn("Session " + session + " timeouts check exception details", e);
            }
        }
    }
}

