/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.config.hosts;

import io.jenkins.cli.shaded.org.apache.sshd.client.config.hosts.ConfigFileHostEntryResolver;
import io.jenkins.cli.shaded.org.apache.sshd.client.config.hosts.HostConfigEntry;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;

public class DefaultConfigFileHostEntryResolver
extends ConfigFileHostEntryResolver {
    public static final DefaultConfigFileHostEntryResolver INSTANCE = new DefaultConfigFileHostEntryResolver(true);
    private final boolean strict;

    public DefaultConfigFileHostEntryResolver(boolean strict) {
        this(HostConfigEntry.getDefaultHostConfigFile(), strict, new LinkOption[0]);
    }

    public DefaultConfigFileHostEntryResolver(Path path, boolean strict, LinkOption ... options) {
        super(path, options);
        this.strict = strict;
    }

    public final boolean isStrict() {
        return this.strict;
    }

    @Override
    protected List<HostConfigEntry> reloadHostConfigEntries(Path path, String host, int port, String username) throws IOException {
        if (this.isStrict()) {
            AbstractMap.SimpleImmutableEntry<String, Object> violation;
            if (this.log.isDebugEnabled()) {
                this.log.debug("reloadHostConfigEntries({}@{}:{}) check permissions of {}", username, host, port, path);
            }
            if ((violation = DefaultConfigFileHostEntryResolver.validateStrictConfigFilePermissions(path, new LinkOption[0])) != null) {
                this.log.warn("reloadHostConfigEntries({}@{}:{}) invalid file={} permissions: {}", username, host, port, path, violation.getKey());
                this.updateReloadAttributes();
                return Collections.emptyList();
            }
        }
        return super.reloadHostConfigEntries(path, host, port, username);
    }
}

