/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.channel;

import io.jenkins.cli.shaded.org.apache.sshd.common.SshConstants;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.Channel;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.ChannelHolder;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.IoWriteFutureImpl;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.Window;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.throttle.ChannelStreamWriter;
import io.jenkins.cli.shaded.org.apache.sshd.common.future.CloseFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.future.SshFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoOutputStream;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoWriteFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.WritePendingException;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.Buffer;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.closeable.AbstractCloseable;
import java.io.EOFException;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public class ChannelAsyncOutputStream
extends AbstractCloseable
implements IoOutputStream,
ChannelHolder {
    private final Channel channelInstance;
    private final ChannelStreamWriter packetWriter;
    private final byte cmd;
    private final AtomicReference<IoWriteFutureImpl> pendingWrite = new AtomicReference();
    private final Object packetWriteId;

    public ChannelAsyncOutputStream(Channel channel, byte cmd) {
        this.channelInstance = Objects.requireNonNull(channel, "No channel");
        this.packetWriter = this.channelInstance.resolveChannelStreamWriter(channel, cmd);
        this.cmd = cmd;
        this.packetWriteId = channel.toString() + "[" + SshConstants.getCommandMessageName(cmd) + "]";
    }

    @Override
    public Channel getChannel() {
        return this.channelInstance;
    }

    public void onWindowExpanded() throws IOException {
        this.doWriteIfPossible(true);
    }

    @Override
    public synchronized IoWriteFuture writeBuffer(Buffer buffer) throws IOException {
        if (this.isClosing()) {
            throw new EOFException("Closing: " + this.state);
        }
        IoWriteFutureImpl future = new IoWriteFutureImpl(this.packetWriteId, buffer);
        if (!this.pendingWrite.compareAndSet(null, future)) {
            throw new WritePendingException("A write operation is already pending");
        }
        this.doWriteIfPossible(false);
        return future;
    }

    @Override
    protected void preClose() {
        if (!(this.packetWriter instanceof Channel)) {
            try {
                this.packetWriter.close();
            }
            catch (IOException e) {
                this.error("preClose({}) Failed ({}) to pre-close packet writer: {}", this, e.getClass().getSimpleName(), e.getMessage(), e);
            }
        }
        super.preClose();
    }

    @Override
    protected CloseFuture doCloseGracefully() {
        return this.builder().when((SshFuture)this.pendingWrite.get()).build().close(false);
    }

    protected synchronized void doWriteIfPossible(boolean resume) {
        IoWriteFutureImpl future = this.pendingWrite.get();
        if (future == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("doWriteIfPossible({})[resume={}] no pending write future", (Object)this, (Object)resume);
            }
            return;
        }
        Buffer buffer = future.getBuffer();
        int total = buffer.available();
        if (total > 0) {
            long length;
            Channel channel = this.getChannel();
            Window remoteWindow = channel.getRemoteWindow();
            long remoteWindowSize = remoteWindow.getSize();
            long packetSize = remoteWindow.getPacketSize();
            if ((long)total > remoteWindowSize) {
                if (remoteWindowSize >= packetSize) {
                    length = packetSize;
                } else {
                    length = 0L;
                    IoWriteFutureImpl f2 = new IoWriteFutureImpl(future.getId(), new ByteArrayBuffer(buffer.getCompactData()));
                    f2.addListener(w -> future.setValue(w.getException() != null ? w.getException() : Boolean.valueOf(w.isWritten())));
                    this.pendingWrite.set(f2);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("doWriteIfPossible({})[resume={}] waiting for window space {}", this, resume, remoteWindowSize);
                    }
                }
            } else if ((long)total > packetSize) {
                if (buffer.rpos() > 0) {
                    IoWriteFutureImpl f3 = new IoWriteFutureImpl(future.getId(), new ByteArrayBuffer(buffer.getCompactData()));
                    f3.addListener(w -> future.setValue(w.getException() != null ? w.getException() : Boolean.valueOf(w.isWritten())));
                    this.pendingWrite.set(f3);
                    long length2 = packetSize;
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("doWriteIfPossible({})[resume={}] attempting to write {} out of {}", this, resume, length2, total);
                    }
                    this.doWriteIfPossible(resume);
                    return;
                }
                length = packetSize;
            } else {
                length = total;
                if (this.log.isTraceEnabled()) {
                    this.log.trace("doWriteIfPossible({})[resume={}] attempting to write {} bytes", this, resume, length);
                }
            }
            if (length > 0L) {
                if (resume && this.log.isDebugEnabled()) {
                    this.log.debug("Resuming {} write due to more space ({}) available in the remote window", (Object)this, (Object)length);
                }
                if (length >= 0x7FFFFFF3L) {
                    throw new IllegalArgumentException("Command " + SshConstants.getCommandMessageName(this.cmd) + " length (" + length + ") exceeds int boundaries");
                }
                Buffer buf = this.createSendBuffer(buffer, channel, length);
                remoteWindow.consume(length);
                try {
                    IoWriteFuture writeFuture = this.packetWriter.writeData(buf);
                    writeFuture.addListener(f -> this.onWritten(future, total, length, (IoWriteFuture)f));
                }
                catch (IOException e) {
                    future.setValue(e);
                }
            } else if (!resume && this.log.isDebugEnabled()) {
                this.log.debug("doWriteIfPossible({}) delaying write until space is available in the remote window", (Object)this);
            }
        } else {
            boolean nullified = this.pendingWrite.compareAndSet(future, null);
            if (this.log.isTraceEnabled()) {
                this.log.trace("doWriteIfPossible({}) current buffer sent - more={}", (Object)this, (Object)(!nullified ? 1 : 0));
            }
            future.setValue(Boolean.TRUE);
        }
    }

    protected void onWritten(IoWriteFutureImpl future, int total, long length, IoWriteFuture f) {
        if (f.isWritten()) {
            if ((long)total > length) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("onWritten({}) completed write of {} out of {}", this, length, total);
                }
                this.doWriteIfPossible(false);
            } else {
                boolean nullified = this.pendingWrite.compareAndSet(future, null);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("onWritten({}) completed write len={}, more={}", this, total, !nullified);
                }
                future.setValue(Boolean.TRUE);
            }
        } else {
            Throwable reason = f.getException();
            this.debug("onWritten({}) failed ({}) to complete write of {} out of {}: {}", this, reason.getClass().getSimpleName(), length, total, reason.getMessage(), reason);
            boolean nullified = this.pendingWrite.compareAndSet(future, null);
            if (this.log.isTraceEnabled()) {
                this.log.trace("onWritten({}) failed write len={}, more={}", this, total, !nullified);
            }
            future.setValue(reason);
        }
    }

    protected Buffer createSendBuffer(Buffer buffer, Channel channel, long length) {
        Object s = channel.getSession();
        Buffer buf = s.createBuffer(this.cmd, (int)length + 12);
        buf.putInt(channel.getRecipient());
        if (this.cmd == 95) {
            buf.putInt(1L);
        }
        buf.putInt(length);
        buf.putRawBytes(buffer.array(), buffer.rpos(), (int)length);
        buffer.rpos(buffer.rpos() + (int)length);
        return buf;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getChannel() + "] cmd=" + SshConstants.getCommandMessageName(this.cmd & 0xFF);
    }
}

