/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.util;

import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import java.util.function.IntUnaryOperator;

public final class Int2IntFunction {
    private Int2IntFunction() {
        throw new UnsupportedOperationException("No instance");
    }

    public static IntUnaryOperator sub(int delta) {
        return Int2IntFunction.add(0 - delta);
    }

    public static IntUnaryOperator add(int delta) {
        if (delta == 0) {
            return IntUnaryOperator.identity();
        }
        return value -> value + delta;
    }

    public static IntUnaryOperator mul(int factor) {
        if (factor == 0) {
            return Int2IntFunction.constant(0);
        }
        if (factor == 1) {
            return IntUnaryOperator.identity();
        }
        return value -> value * factor;
    }

    public static IntUnaryOperator constant(int v) {
        return value -> v;
    }

    public static IntUnaryOperator div(int factor) {
        if (factor == 1) {
            return IntUnaryOperator.identity();
        }
        ValidateUtils.checkTrue(factor != 0, "Zero division factor");
        return value -> value / factor;
    }
}

