/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.config;

import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.threads.ThreadUtils;
import io.jenkins.cli.shaded.org.slf4j.Logger;
import io.jenkins.cli.shaded.org.slf4j.LoggerFactory;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public final class VersionProperties {
    private VersionProperties() {
        throw new UnsupportedOperationException("No instance");
    }

    public static Map<String, String> getVersionProperties() {
        return LazyHolder.PROPERTIES;
    }

    private static class LazyHolder {
        private static final Map<String, String> PROPERTIES = Collections.unmodifiableMap(LazyHolder.loadVersionProperties(LazyHolder.class));

        private LazyHolder() {
        }

        private static Map<String, String> loadVersionProperties(Class<?> anchor) {
            return LazyHolder.loadVersionProperties(anchor, ThreadUtils.resolveDefaultClassLoader(anchor));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Map<String, String> loadVersionProperties(Class<?> anchor, ClassLoader loader) {
            TreeMap<String, String> result = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            try {
                InputStream input = loader.getResourceAsStream("io/jenkins/cli/shaded/org/apache/sshd/sshd-version.properties");
                if (input == null) {
                    throw new FileNotFoundException("Resource does not exists");
                }
                Properties props = new Properties();
                try {
                    props.load(input);
                }
                finally {
                    input.close();
                }
                for (String key : props.stringPropertyNames()) {
                    String prev;
                    String value = GenericUtils.trimToEmpty(props.getProperty(key));
                    if (GenericUtils.isEmpty(value) || (prev = result.put(key, value)) == null) continue;
                    Logger log = LoggerFactory.getLogger(anchor);
                    log.warn("Multiple values for key=" + key + ": current=" + value + ", previous=" + prev);
                }
            }
            catch (Exception e) {
                Logger log = LoggerFactory.getLogger(anchor);
                log.warn("Failed (" + e.getClass().getSimpleName() + ") to load version properties: " + e.getMessage());
            }
            return result;
        }
    }
}

