/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.server;

import io.jenkins.cli.shaded.org.apache.sshd.common.NamedFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.NamedResource;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.server.auth.BuiltinUserAuthFactories;
import io.jenkins.cli.shaded.org.apache.sshd.server.auth.UserAuth;
import io.jenkins.cli.shaded.org.apache.sshd.server.auth.WelcomeBannerPhase;
import io.jenkins.cli.shaded.org.apache.sshd.server.auth.gss.GSSAuthenticator;
import io.jenkins.cli.shaded.org.apache.sshd.server.auth.gss.UserAuthGSSFactory;
import io.jenkins.cli.shaded.org.apache.sshd.server.auth.hostbased.HostBasedAuthenticator;
import io.jenkins.cli.shaded.org.apache.sshd.server.auth.keyboard.KeyboardInteractiveAuthenticator;
import io.jenkins.cli.shaded.org.apache.sshd.server.auth.keyboard.UserAuthKeyboardInteractiveFactory;
import io.jenkins.cli.shaded.org.apache.sshd.server.auth.password.PasswordAuthenticator;
import io.jenkins.cli.shaded.org.apache.sshd.server.auth.password.UserAuthPasswordFactory;
import io.jenkins.cli.shaded.org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import io.jenkins.cli.shaded.org.apache.sshd.server.auth.pubkey.UserAuthPublicKeyFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public interface ServerAuthenticationManager {
    public static final String MAX_AUTH_REQUESTS = "max-auth-requests";
    public static final int DEFAULT_MAX_AUTH_REQUESTS = 20;
    public static final String WELCOME_BANNER = "welcome-banner";
    public static final String AUTO_WELCOME_BANNER_VALUE = "#auto-welcome-banner";
    public static final String WELCOME_BANNER_LANGUAGE = "welcome-banner-language";
    public static final String DEFAULT_WELCOME_BANNER_LANGUAGE = "en";
    public static final String WELCOME_BANNER_PHASE = "welcome-banner-phase";
    public static final WelcomeBannerPhase DEFAULT_BANNER_PHASE = WelcomeBannerPhase.IMMEDIATE;
    public static final String WELCOME_BANNER_CHARSET = "welcome-banner-charset";
    public static final String AUTH_METHODS = "auth-methods";
    public static final UserAuthPublicKeyFactory DEFAULT_USER_AUTH_PUBLIC_KEY_FACTORY = UserAuthPublicKeyFactory.INSTANCE;
    public static final UserAuthGSSFactory DEFAULT_USER_AUTH_GSS_FACTORY = UserAuthGSSFactory.INSTANCE;
    public static final UserAuthPasswordFactory DEFAULT_USER_AUTH_PASSWORD_FACTORY = UserAuthPasswordFactory.INSTANCE;
    public static final UserAuthKeyboardInteractiveFactory DEFAULT_USER_AUTH_KB_INTERACTIVE_FACTORY = UserAuthKeyboardInteractiveFactory.INSTANCE;

    public List<NamedFactory<UserAuth>> getUserAuthFactories();

    default public String getUserAuthFactoriesNameList() {
        return NamedResource.getNames(this.getUserAuthFactories());
    }

    default public List<String> getUserAuthFactoriesNames() {
        return NamedResource.getNameList(this.getUserAuthFactories());
    }

    public void setUserAuthFactories(List<NamedFactory<UserAuth>> var1);

    default public void setUserAuthFactoriesNameList(String names) {
        this.setUserAuthFactoriesNames(GenericUtils.split(names, ','));
    }

    default public void setUserAuthFactoriesNames(String ... names) {
        this.setUserAuthFactoriesNames(GenericUtils.isEmpty((Object[])names) ? Collections.emptyList() : Arrays.asList(names));
    }

    default public void setUserAuthFactoriesNames(Collection<String> names) {
        BuiltinUserAuthFactories.ParseResult result = BuiltinUserAuthFactories.parseFactoriesList(names);
        List<NamedFactory<UserAuth>> factories = ValidateUtils.checkNotNullAndNotEmpty(result.getParsedFactories(), "No supported cipher factories: %s", names);
        List<String> unsupported = result.getUnsupportedFactories();
        ValidateUtils.checkTrue(GenericUtils.isEmpty(unsupported), "Unsupported cipher factories found: %s", unsupported);
        this.setUserAuthFactories(factories);
    }

    public PublickeyAuthenticator getPublickeyAuthenticator();

    public void setPasswordAuthenticator(PasswordAuthenticator var1);

    public PasswordAuthenticator getPasswordAuthenticator();

    public void setPublickeyAuthenticator(PublickeyAuthenticator var1);

    public KeyboardInteractiveAuthenticator getKeyboardInteractiveAuthenticator();

    public void setKeyboardInteractiveAuthenticator(KeyboardInteractiveAuthenticator var1);

    public GSSAuthenticator getGSSAuthenticator();

    public void setGSSAuthenticator(GSSAuthenticator var1);

    public HostBasedAuthenticator getHostBasedAuthenticator();

    public void setHostBasedAuthenticator(HostBasedAuthenticator var1);

    public static List<NamedFactory<UserAuth>> resolveUserAuthFactories(ServerAuthenticationManager manager) {
        if (manager == null) {
            return Collections.emptyList();
        }
        return ServerAuthenticationManager.resolveUserAuthFactories(manager, manager.getUserAuthFactories());
    }

    public static List<NamedFactory<UserAuth>> resolveUserAuthFactories(ServerAuthenticationManager manager, List<NamedFactory<UserAuth>> userFactories) {
        if (GenericUtils.size(userFactories) > 0) {
            return userFactories;
        }
        if (manager == null) {
            return Collections.emptyList();
        }
        ArrayList<NamedFactory<UserAuth>> factories = new ArrayList<NamedFactory<UserAuth>>();
        if (manager.getPasswordAuthenticator() != null) {
            factories.add(DEFAULT_USER_AUTH_PASSWORD_FACTORY);
            factories.add(DEFAULT_USER_AUTH_KB_INTERACTIVE_FACTORY);
        } else if (manager.getKeyboardInteractiveAuthenticator() != null) {
            factories.add(DEFAULT_USER_AUTH_KB_INTERACTIVE_FACTORY);
        }
        if (manager.getPublickeyAuthenticator() != null) {
            factories.add(DEFAULT_USER_AUTH_PUBLIC_KEY_FACTORY);
        }
        if (manager.getGSSAuthenticator() != null) {
            factories.add(DEFAULT_USER_AUTH_GSS_FACTORY);
        }
        return factories;
    }
}

