/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.server.forward;

import io.jenkins.cli.shaded.org.apache.sshd.client.future.DefaultOpenFuture;
import io.jenkins.cli.shaded.org.apache.sshd.client.future.OpenFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.FactoryManager;
import io.jenkins.cli.shaded.org.apache.sshd.common.RuntimeSshException;
import io.jenkins.cli.shaded.org.apache.sshd.common.SshConstants;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.Channel;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.ChannelFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.ChannelOutputStream;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.Window;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.exception.SshChannelOpenException;
import io.jenkins.cli.shaded.org.apache.sshd.common.future.CloseFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoConnectFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoConnector;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoHandler;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoSession;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.Session;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.Readable;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.Buffer;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.net.SshdSocketAddress;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.threads.ExecutorServiceCarrier;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.threads.ThreadUtils;
import io.jenkins.cli.shaded.org.apache.sshd.server.channel.AbstractServerChannel;
import io.jenkins.cli.shaded.org.apache.sshd.server.forward.TcpForwardingFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;

public class TcpipServerChannel
extends AbstractServerChannel {
    private final TcpForwardingFilter.Type type;
    private IoConnector connector;
    private IoSession ioSession;
    private OutputStream out;

    public TcpipServerChannel(TcpForwardingFilter.Type type) {
        this.type = type;
    }

    public final TcpForwardingFilter.Type getChannelType() {
        return this.type;
    }

    @Override
    protected OpenFuture doInit(Buffer buffer) {
        SshdSocketAddress address;
        String hostToConnect = buffer.getString();
        int portToConnect = buffer.getInt();
        String originatorIpAddress = buffer.getString();
        int originatorPort = buffer.getInt();
        if (this.log.isDebugEnabled()) {
            this.log.debug("doInit({}) Receiving request for direct tcpip: hostToConnect={}, portToConnect={}, originatorIpAddress={}, originatorPort={}", this, hostToConnect, portToConnect, originatorIpAddress, originatorPort);
        }
        switch (this.type) {
            case Direct: {
                address = new SshdSocketAddress(hostToConnect, portToConnect);
                break;
            }
            case Forwarded: {
                address = this.service.getForwardingFilter().getForwardedPort(portToConnect);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown server channel type: " + this.type);
            }
        }
        Session session = this.getSession();
        FactoryManager manager = Objects.requireNonNull(session.getFactoryManager(), "No factory manager");
        TcpForwardingFilter filter = manager.getTcpForwardingFilter();
        DefaultOpenFuture f = new DefaultOpenFuture(this, this);
        try {
            if (address == null || filter == null || !filter.canConnect(this.type, address, session)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("doInit(" + this + ")[" + this.type + "][haveFilter=" + (filter != null) + "] filtered out " + address);
                }
                super.close(true);
                f.setException(new SshChannelOpenException(this.getId(), 1, "Connection denied"));
                return f;
            }
        }
        catch (Error e) {
            this.log.warn("doInit({})[{}] failed ({}) to consult forwarding filter: {}", session, this.type, e.getClass().getSimpleName(), e.getMessage());
            if (this.log.isDebugEnabled()) {
                this.log.debug("doInit(" + this + ")[" + this.type + "] filter consultation failure details", e);
            }
            throw new RuntimeSshException(e);
        }
        this.out = new ChannelOutputStream(this, this.getRemoteWindow(), this.log, 94, true);
        IoHandler handler = new IoHandler(){

            @Override
            public void messageReceived(IoSession session, Readable message) throws Exception {
                if (TcpipServerChannel.this.isClosing()) {
                    if (TcpipServerChannel.this.log.isDebugEnabled()) {
                        TcpipServerChannel.this.log.debug("doInit({}) Ignoring write to channel in CLOSING state", (Object)TcpipServerChannel.this);
                    }
                } else {
                    ByteArrayBuffer buffer = new ByteArrayBuffer(message.available() + 64, false);
                    buffer.putBuffer(message);
                    TcpipServerChannel.this.out.write(((Buffer)buffer).array(), ((Buffer)buffer).rpos(), buffer.available());
                    TcpipServerChannel.this.out.flush();
                }
            }

            @Override
            public void sessionCreated(IoSession session) throws Exception {
            }

            @Override
            public void sessionClosed(IoSession session) throws Exception {
                TcpipServerChannel.this.close(false);
            }

            @Override
            public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
                TcpipServerChannel.this.close(true);
            }
        };
        this.connector = manager.getIoServiceFactory().createConnector(handler);
        IoConnectFuture future = this.connector.connect(address.toInetSocketAddress());
        future.addListener(future1 -> this.handleChannelConnectResult(f, (IoConnectFuture)future1));
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleChannelConnectResult(OpenFuture f, IoConnectFuture future) {
        try {
            if (future.isConnected()) {
                this.handleChannelOpenSuccess(f, future.getSession());
                return;
            }
            Throwable problem = GenericUtils.peelException(future.getException());
            if (problem != null) {
                this.handleChannelOpenFailure(f, problem);
            }
        }
        catch (RuntimeException t) {
            Throwable e = GenericUtils.peelException(t);
            this.signalChannelOpenFailure(e);
            try {
                f.setException(e);
            }
            finally {
                this.notifyStateChanged(e.getClass().getSimpleName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleChannelOpenSuccess(OpenFuture f, IoSession session) {
        this.ioSession = session;
        String changeEvent = session.toString();
        try {
            this.signalChannelOpenSuccess();
            f.setOpened();
        }
        catch (Throwable t) {
            Throwable e = GenericUtils.peelException(t);
            changeEvent = e.getClass().getSimpleName();
            this.signalChannelOpenFailure(e);
            f.setException(e);
        }
        finally {
            this.notifyStateChanged(changeEvent);
        }
    }

    protected void handleChannelOpenFailure(OpenFuture f, Throwable problem) {
        this.signalChannelOpenFailure(problem);
        this.notifyStateChanged(problem.getClass().getSimpleName());
        this.close(true);
        if (problem instanceof ConnectException) {
            f.setException(new SshChannelOpenException(this.getId(), 2, problem.getMessage(), problem));
        } else {
            f.setException(problem);
        }
    }

    @Override
    public CloseFuture close(boolean immediately) {
        CloseFuture closingFeature = super.close(immediately);
        ExecutorService service = this.getExecutorService();
        ExecutorService executors = service == null ? ThreadUtils.newSingleThreadExecutor("TcpIpServerChannel-ConnectorCleanup[" + this.getSession() + "]") : service;
        boolean shutdown = executors != service || this.isShutdownOnExit();
        return this.builder().when(closingFeature).run(this.toString(), () -> executors.submit(() -> {
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("disposing connector: {} for: {}", (Object)this.connector, (Object)this);
                }
                this.connector.close(immediately);
            }
            finally {
                if (shutdown && !executors.isShutdown()) {
                    List<Runnable> runners = executors.shutdownNow();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("destroy({}) - shutdown executor service - runners count={}", (Object)this, (Object)runners.size());
                    }
                }
            }
        })).build().close(false);
    }

    @Override
    protected void doWriteData(byte[] data, int off, long len) throws IOException {
        ValidateUtils.checkTrue(len <= Integer.MAX_VALUE, "Data length exceeds int boundaries: %d", len);
        ByteArrayBuffer buf = ByteArrayBuffer.getCompactClone(data, off, (int)len);
        this.ioSession.writePacket(buf).addListener(future -> {
            if (future.isWritten()) {
                this.handleWriteDataSuccess((byte)94, buf.array(), 0, (int)len);
            } else {
                this.handleWriteDataFailure((byte)94, buf.array(), 0, (int)len, future.getException());
            }
        });
    }

    @Override
    protected void doWriteExtendedData(byte[] data, int off, long len) throws IOException {
        throw new UnsupportedOperationException(this.type + "Tcpip channel does not support extended data");
    }

    protected void handleWriteDataSuccess(byte cmd, byte[] data, int off, int len) {
        Session session = this.getSession();
        try {
            Window wLocal = this.getLocalWindow();
            wLocal.consumeAndCheck(len);
        }
        catch (Throwable e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleWriteDataSuccess({})[{}] failed ({}) to consume len={}: {}", this, SshConstants.getCommandMessageName(cmd & 0xFF), e.getClass().getSimpleName(), len, e.getMessage());
            }
            session.exceptionCaught(e);
        }
    }

    protected void handleWriteDataFailure(byte cmd, byte[] data, int off, int len, Throwable t) {
        Session session = this.getSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleWriteDataFailure({})[{}] failed ({}) to write len={}: {}", this, SshConstants.getCommandMessageName(cmd & 0xFF), t.getClass().getSimpleName(), len, t.getMessage());
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("doWriteData(" + this + ")[" + SshConstants.getCommandMessageName(cmd & 0xFF) + "] len=" + len + " write failure details", t);
        }
        if (this.ioSession.isOpen()) {
            session.exceptionCaught(t);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Ignoring writeDataFailure {} because ioSession {} is already closing ", (Object)t, (Object)this.ioSession);
        }
    }

    public static abstract class TcpipFactory
    implements ChannelFactory,
    ExecutorServiceCarrier {
        private final TcpForwardingFilter.Type type;

        protected TcpipFactory(TcpForwardingFilter.Type type) {
            this.type = type;
        }

        public final TcpForwardingFilter.Type getType() {
            return this.type;
        }

        @Override
        public final String getName() {
            return this.type.getName();
        }

        @Override
        public ExecutorService getExecutorService() {
            return null;
        }

        @Override
        public boolean isShutdownOnExit() {
            return false;
        }

        @Override
        public Channel create() {
            TcpipServerChannel channel = new TcpipServerChannel(this.getType());
            channel.setExecutorService(this.getExecutorService());
            channel.setShutdownOnExit(this.isShutdownOnExit());
            return channel;
        }
    }
}

