/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.channel;

import io.jenkins.cli.shaded.org.apache.sshd.client.channel.ClientChannel;
import io.jenkins.cli.shaded.org.apache.sshd.client.channel.ClientChannelEvent;
import io.jenkins.cli.shaded.org.apache.sshd.client.channel.exit.ExitSignalChannelRequestHandler;
import io.jenkins.cli.shaded.org.apache.sshd.client.channel.exit.ExitStatusChannelRequestHandler;
import io.jenkins.cli.shaded.org.apache.sshd.client.future.DefaultOpenFuture;
import io.jenkins.cli.shaded.org.apache.sshd.client.future.OpenFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.Closeable;
import io.jenkins.cli.shaded.org.apache.sshd.common.FactoryManager;
import io.jenkins.cli.shaded.org.apache.sshd.common.SshConstants;
import io.jenkins.cli.shaded.org.apache.sshd.common.SshException;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.AbstractChannel;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.Channel;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.ChannelAsyncInputStream;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.ChannelAsyncOutputStream;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.RequestHandler;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.Window;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.exception.SshChannelOpenException;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoInputStream;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoOutputStream;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.Session;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.EventNotifier;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.Buffer;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.IoUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractClientChannel
extends AbstractChannel
implements ClientChannel {
    protected final AtomicBoolean opened = new AtomicBoolean();
    protected final String type;
    protected ClientChannel.Streaming streaming;
    protected ChannelAsyncOutputStream asyncIn;
    protected ChannelAsyncInputStream asyncOut;
    protected ChannelAsyncInputStream asyncErr;
    protected InputStream in;
    protected OutputStream invertedIn;
    protected OutputStream out;
    protected InputStream invertedOut;
    protected OutputStream err;
    protected InputStream invertedErr;
    protected final AtomicReference<Integer> exitStatusHolder = new AtomicReference<Object>(null);
    protected final AtomicReference<String> exitSignalHolder = new AtomicReference<Object>(null);
    protected int openFailureReason;
    protected String openFailureMsg;
    protected String openFailureLang;
    protected OpenFuture openFuture;

    protected AbstractClientChannel(String type) {
        this(type, Collections.emptyList());
    }

    protected AbstractClientChannel(String type, Collection<? extends RequestHandler<Channel>> handlers) {
        super(true, handlers);
        this.type = ValidateUtils.checkNotNullAndNotEmpty(type, "No channel type specified");
        this.streaming = ClientChannel.Streaming.Sync;
        this.addChannelSignalRequestHandlers(event -> {
            if (this.log.isDebugEnabled()) {
                this.log.debug("notifyEvent({}): {}", (Object)this, event);
            }
            this.notifyStateChanged((String)event);
        });
    }

    protected void addChannelSignalRequestHandlers(EventNotifier<String> notifier) {
        this.addRequestHandler(new ExitStatusChannelRequestHandler(this.exitStatusHolder, (EventNotifier<? super String>)notifier));
        this.addRequestHandler(new ExitSignalChannelRequestHandler(this.exitSignalHolder, (EventNotifier<? super String>)notifier));
    }

    @Override
    public ClientChannel.Streaming getStreaming() {
        return this.streaming;
    }

    @Override
    public void setStreaming(ClientChannel.Streaming streaming) {
        this.streaming = streaming;
    }

    @Override
    public IoOutputStream getAsyncIn() {
        return this.asyncIn;
    }

    @Override
    public IoInputStream getAsyncOut() {
        return this.asyncOut;
    }

    @Override
    public IoInputStream getAsyncErr() {
        return this.asyncErr;
    }

    @Override
    public OutputStream getInvertedIn() {
        return this.invertedIn;
    }

    public InputStream getIn() {
        return this.in;
    }

    @Override
    public void setIn(InputStream in) {
        this.in = in;
    }

    @Override
    public InputStream getInvertedOut() {
        return this.invertedOut;
    }

    public OutputStream getOut() {
        return this.out;
    }

    @Override
    public void setOut(OutputStream out) {
        this.out = out;
    }

    @Override
    public InputStream getInvertedErr() {
        return this.invertedErr;
    }

    public OutputStream getErr() {
        return this.err;
    }

    @Override
    public void setErr(OutputStream err) {
        this.err = err;
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().when(this.openFuture).run(this.toString(), () -> {
            if (this.openFuture == null) {
                this.gracefulFuture.setClosed();
            }
            IoUtils.closeQuietly(this.in, this.out, this.err);
            IoUtils.closeQuietly(this.invertedIn, this.invertedOut, this.invertedErr);
        }).parallel(this.asyncIn, this.asyncOut, this.asyncErr).close(new AbstractChannel.GracefulChannelCloseable()).build();
    }

    @Override
    public Set<ClientChannelEvent> waitFor(Collection<ClientChannelEvent> mask, long timeout) {
        Objects.requireNonNull(mask, "No mask specified");
        long t = 0L;
        Object object = this.lock;
        synchronized (object) {
            EnumSet<ClientChannelEvent> cond = EnumSet.noneOf(ClientChannelEvent.class);
            while (true) {
                block20: {
                    boolean nothingInCommon;
                    this.updateCurrentChannelState(cond);
                    if (this.log.isDebugEnabled()) {
                        if (cond.contains((Object)ClientChannelEvent.EXIT_STATUS)) {
                            this.log.debug("waitFor({}) mask={} - exit status={}", this, mask, this.exitStatusHolder);
                        }
                        if (cond.contains((Object)ClientChannelEvent.EXIT_SIGNAL)) {
                            this.log.debug("waitFor({}) mask={} - exit signal={}", this, mask, this.exitSignalHolder);
                        }
                    }
                    if (!(nothingInCommon = Collections.disjoint(mask, cond))) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("WaitFor call returning on channel {}, mask={}, cond={}", this, mask, cond);
                        }
                        return cond;
                    }
                    if (timeout > 0L) {
                        if (t == 0L) {
                            t = System.currentTimeMillis() + timeout;
                        } else {
                            timeout = t - System.currentTimeMillis();
                            if (timeout <= 0L) {
                                if (this.log.isTraceEnabled()) {
                                    this.log.trace("WaitFor call timeout on channel {}, mask={}", (Object)this, (Object)mask);
                                }
                                cond.add(ClientChannelEvent.TIMEOUT);
                                return cond;
                            }
                        }
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("Waiting {} millis for lock on channel {}, mask={}, cond={}", timeout, this, mask, cond);
                    }
                    long nanoStart = System.nanoTime();
                    try {
                        if (timeout > 0L) {
                            this.lock.wait(timeout);
                        } else {
                            this.lock.wait();
                        }
                        long nanoEnd = System.nanoTime();
                        long nanoDuration = nanoEnd - nanoStart;
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("Lock notified on channel {} after {} nanos", (Object)this, (Object)nanoDuration);
                        }
                    }
                    catch (InterruptedException e) {
                        long nanoEnd = System.nanoTime();
                        long nanoDuration = nanoEnd - nanoStart;
                        if (!this.log.isTraceEnabled()) break block20;
                        this.log.trace("waitFor({}) mask={} - ignoring interrupted exception after {} nanos", this, mask, nanoDuration);
                    }
                }
                cond.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ClientChannelEvent> getChannelState() {
        EnumSet<ClientChannelEvent> cond = EnumSet.noneOf(ClientChannelEvent.class);
        Object object = this.lock;
        synchronized (object) {
            return this.updateCurrentChannelState(cond);
        }
    }

    protected <C extends Collection<ClientChannelEvent>> C updateCurrentChannelState(C state) {
        if (this.openFuture != null && this.openFuture.isOpened()) {
            state.add((ClientChannelEvent)ClientChannelEvent.OPENED);
        }
        if (this.closeFuture.isClosed()) {
            state.add((ClientChannelEvent)ClientChannelEvent.CLOSED);
        }
        if (this.isEofSignalled()) {
            state.add((ClientChannelEvent)ClientChannelEvent.EOF);
        }
        if (this.exitStatusHolder.get() != null) {
            state.add((ClientChannelEvent)ClientChannelEvent.EXIT_STATUS);
        }
        if (this.exitSignalHolder.get() != null) {
            state.add((ClientChannelEvent)ClientChannelEvent.EXIT_SIGNAL);
        }
        return state;
    }

    @Override
    public synchronized OpenFuture open() throws IOException {
        if (this.isClosing()) {
            throw new SshException("Session has been closed");
        }
        this.openFuture = new DefaultOpenFuture(this.toString(), this.lock);
        if (this.log.isDebugEnabled()) {
            this.log.debug("open({}) Send SSH_MSG_CHANNEL_OPEN - type={}", (Object)this, (Object)this.type);
        }
        Session session = this.getSession();
        Window wLocal = this.getLocalWindow();
        Buffer buffer = session.createBuffer((byte)90, this.type.length() + 32);
        buffer.putString(this.type);
        buffer.putInt(this.getId());
        buffer.putInt(wLocal.getSize());
        buffer.putInt(wLocal.getPacketSize());
        this.writePacket(buffer);
        return this.openFuture;
    }

    @Override
    public OpenFuture open(int recipient, long rwSize, long packetSize, Buffer buffer) {
        throw new UnsupportedOperationException("open(" + recipient + "," + rwSize + "," + packetSize + ") N/A");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleOpenSuccess(int recipient, long rwSize, long packetSize, Buffer buffer) {
        this.setRecipient(recipient);
        Session session = this.getSession();
        FactoryManager manager = Objects.requireNonNull(session.getFactoryManager(), "No factory manager");
        Window wRemote = this.getRemoteWindow();
        wRemote.init(rwSize, packetSize, manager);
        String changeEvent = "SSH_MSG_CHANNEL_OPEN_CONFIRMATION";
        try {
            this.doOpen();
            this.signalChannelOpenSuccess();
            this.opened.set(true);
            this.openFuture.setOpened();
        }
        catch (Throwable t) {
            Throwable e = GenericUtils.peelException(t);
            changeEvent = e.getClass().getName();
            this.signalChannelOpenFailure(e);
            this.openFuture.setException(e);
            this.closeFuture.setClosed();
            this.doCloseImmediately();
        }
        finally {
            this.notifyStateChanged(changeEvent);
        }
    }

    protected abstract void doOpen() throws IOException;

    @Override
    public void handleOpenFailure(Buffer buffer) {
        int reason = buffer.getInt();
        String msg = buffer.getString();
        String lang = buffer.getString();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleOpenFailure({}) reason={}, lang={}, msg={}", this, SshConstants.getOpenErrorCodeName(reason), lang, msg);
        }
        this.openFailureReason = reason;
        this.openFailureMsg = msg;
        this.openFailureLang = lang;
        this.openFuture.setException(new SshChannelOpenException(this.getId(), reason, msg));
        this.closeFuture.setClosed();
        this.doCloseImmediately();
        this.notifyStateChanged("SSH_MSG_CHANNEL_OPEN_FAILURE");
    }

    @Override
    protected void doWriteData(byte[] data, int off, long len) throws IOException {
        if (this.isClosing()) {
            return;
        }
        ValidateUtils.checkTrue(len <= Integer.MAX_VALUE, "Data length exceeds int boundaries: %d", len);
        if (this.asyncOut != null) {
            this.asyncOut.write(new ByteArrayBuffer(data, off, (int)len));
        } else if (this.out != null) {
            this.out.write(data, off, (int)len);
            this.out.flush();
            if (this.invertedOut == null) {
                Window wLocal = this.getLocalWindow();
                wLocal.consumeAndCheck(len);
            }
        } else {
            throw new IllegalStateException("No output stream for channel");
        }
    }

    @Override
    protected void doWriteExtendedData(byte[] data, int off, long len) throws IOException {
        if (this.isClosing()) {
            return;
        }
        ValidateUtils.checkTrue(len <= Integer.MAX_VALUE, "Extended data length exceeds int boundaries: %d", len);
        if (this.asyncErr != null) {
            this.asyncErr.write(new ByteArrayBuffer(data, off, (int)len));
        } else if (this.err != null) {
            this.err.write(data, off, (int)len);
            this.err.flush();
            if (this.invertedErr == null) {
                Window wLocal = this.getLocalWindow();
                wLocal.consumeAndCheck(len);
            }
        } else {
            throw new IllegalStateException("No error stream for channel");
        }
    }

    @Override
    public void handleWindowAdjust(Buffer buffer) throws IOException {
        super.handleWindowAdjust(buffer);
        if (this.asyncIn != null) {
            this.asyncIn.onWindowExpanded();
        }
    }

    @Override
    public Integer getExitStatus() {
        return this.exitStatusHolder.get();
    }

    @Override
    public String getExitSignal() {
        return this.exitSignalHolder.get();
    }
}

