/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.io.nio2;

import io.jenkins.cli.shaded.org.apache.sshd.common.Closeable;
import io.jenkins.cli.shaded.org.apache.sshd.common.FactoryManager;
import io.jenkins.cli.shaded.org.apache.sshd.common.future.CloseFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoAcceptor;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoHandler;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoSession;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.nio2.Nio2CompletionHandler;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.nio2.Nio2Service;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.nio2.Nio2Session;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.closeable.AbstractCloseable;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Nio2Acceptor
extends Nio2Service
implements IoAcceptor {
    protected final Map<SocketAddress, AsynchronousServerSocketChannel> channels = new ConcurrentHashMap<SocketAddress, AsynchronousServerSocketChannel>();
    private int backlog = 0;

    public Nio2Acceptor(FactoryManager manager, IoHandler handler, AsynchronousChannelGroup group) {
        super(manager, handler, group);
        this.backlog = manager.getIntProperty("socket-backlog", 0);
    }

    @Override
    public void bind(Collection<? extends SocketAddress> addresses) throws IOException {
        AsynchronousChannelGroup group = this.getChannelGroup();
        for (SocketAddress socketAddress : addresses) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Binding Nio2Acceptor to address {}", (Object)socketAddress);
            }
            AsynchronousServerSocketChannel asyncChannel = this.openAsynchronousServerSocketChannel(socketAddress, group);
            AsynchronousServerSocketChannel socket = this.setSocketOptions(asyncChannel);
            socket.bind(socketAddress, this.backlog);
            SocketAddress local = socket.getLocalAddress();
            this.channels.put(local, socket);
            CompletionHandler<AsynchronousSocketChannel, ? super SocketAddress> handler = ValidateUtils.checkNotNull(this.createSocketCompletionHandler(this.channels, socket), "No completion handler created for address=%s", (Object)socketAddress);
            socket.accept(local, handler);
        }
    }

    protected AsynchronousServerSocketChannel openAsynchronousServerSocketChannel(SocketAddress address, AsynchronousChannelGroup group) throws IOException {
        return AsynchronousServerSocketChannel.open(group);
    }

    protected CompletionHandler<AsynchronousSocketChannel, ? super SocketAddress> createSocketCompletionHandler(Map<SocketAddress, AsynchronousServerSocketChannel> channelsMap, AsynchronousServerSocketChannel socket) throws IOException {
        return new AcceptCompletionHandler(socket);
    }

    @Override
    public void bind(SocketAddress address) throws IOException {
        this.bind(Collections.singleton(address));
    }

    @Override
    public void unbind() {
        Set<SocketAddress> addresses = this.getBoundAddresses();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Unbinding {}", (Object)addresses);
        }
        this.unbind(addresses);
    }

    @Override
    public void unbind(Collection<? extends SocketAddress> addresses) {
        for (SocketAddress socketAddress : addresses) {
            AsynchronousServerSocketChannel channel = this.channels.remove(socketAddress);
            if (channel != null) {
                try {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("unbind({})", (Object)socketAddress);
                    }
                    channel.close();
                }
                catch (IOException e) {
                    this.log.warn("unbind({}) {} while unbinding channel: {}", socketAddress, e.getClass().getSimpleName(), e.getMessage());
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("unbind(" + socketAddress + ") failure details", e);
                }
                continue;
            }
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace("No active channel to unbind for {}", (Object)socketAddress);
        }
    }

    @Override
    public void unbind(SocketAddress address) {
        this.unbind(Collections.singleton(address));
    }

    @Override
    public Set<SocketAddress> getBoundAddresses() {
        return new HashSet<SocketAddress>(this.channels.keySet());
    }

    @Override
    public CloseFuture close(boolean immediately) {
        this.unbind();
        return super.close(immediately);
    }

    @Override
    public void doCloseImmediately() {
        Set<SocketAddress> boundAddresses = this.getBoundAddresses();
        for (SocketAddress address : boundAddresses) {
            AsynchronousServerSocketChannel asyncChannel = this.channels.remove(address);
            if (asyncChannel == null) continue;
            try {
                asyncChannel.close();
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("doCloseImmediately({}) closed channel", (Object)address);
            }
            catch (IOException e) {
                this.log.debug("Exception caught while closing channel of " + address, e);
            }
        }
        super.doCloseImmediately();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getBoundAddresses() + "]";
    }

    protected class AcceptCompletionHandler
    extends Nio2CompletionHandler<AsynchronousSocketChannel, SocketAddress> {
        protected final AsynchronousServerSocketChannel socket;

        AcceptCompletionHandler(AsynchronousServerSocketChannel socket) {
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onCompleted(AsynchronousSocketChannel result, SocketAddress address) {
            block13: {
                if (!Nio2Acceptor.this.channels.containsKey(address)) {
                    if (Nio2Acceptor.this.log.isDebugEnabled()) {
                        Nio2Acceptor.this.log.debug("onCompleted({}) unbound address", (Object)address);
                    }
                    return;
                }
                Closeable session = null;
                Long sessionId = null;
                try {
                    IoHandler handler = Nio2Acceptor.this.getIoHandler();
                    Nio2Acceptor.this.setSocketOptions(result);
                    session = Objects.requireNonNull(this.createSession(Nio2Acceptor.this, address, result, handler), "No NIO2 session created");
                    sessionId = ((Nio2Session)session).getId();
                    handler.sessionCreated((IoSession)session);
                    Nio2Acceptor.this.sessions.put(sessionId, session);
                    if (((AbstractCloseable)session).isClosing()) {
                        try {
                            handler.sessionClosed((IoSession)session);
                            break block13;
                        }
                        finally {
                            Nio2Acceptor.this.unmapSession(sessionId);
                        }
                    }
                    ((Nio2Session)session).startReading();
                }
                catch (Throwable exc) {
                    this.failed(exc, address);
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable t) {
                            Nio2Acceptor.this.log.warn("onCompleted(" + address + ") Failed (" + t.getClass().getSimpleName() + ") to close accepted connection from " + address + ": " + t.getMessage(), t);
                        }
                    }
                    Nio2Acceptor.this.unmapSession(sessionId);
                }
            }
            try {
                this.socket.accept(address, this);
            }
            catch (Throwable exc) {
                this.failed(exc, address);
            }
        }

        protected Nio2Session createSession(Nio2Acceptor acceptor, SocketAddress address, AsynchronousSocketChannel channel, IoHandler handler) throws Throwable {
            if (Nio2Acceptor.this.log.isTraceEnabled()) {
                Nio2Acceptor.this.log.trace("createNio2Session({}) address={}", (Object)acceptor, (Object)address);
            }
            return new Nio2Session(acceptor, Nio2Acceptor.this.getFactoryManager(), handler, channel);
        }

        @Override
        protected void onFailed(Throwable exc, SocketAddress address) {
            AsynchronousServerSocketChannel channel = Nio2Acceptor.this.channels.get(address);
            if (channel == null) {
                if (Nio2Acceptor.this.log.isDebugEnabled()) {
                    Nio2Acceptor.this.log.debug("Caught {} for untracked channel of {}: {}", exc.getClass().getSimpleName(), address, exc.getMessage());
                }
                return;
            }
            if (Nio2Acceptor.this.disposing.get()) {
                if (Nio2Acceptor.this.log.isDebugEnabled()) {
                    Nio2Acceptor.this.log.debug("Caught {} for tracked channel of {} while disposing: {}", exc.getClass().getSimpleName(), address, exc.getMessage());
                }
                return;
            }
            Nio2Acceptor.this.log.warn("Caught " + exc.getClass().getSimpleName() + " while accepting incoming connection from " + address + ": " + exc.getMessage(), exc);
            try {
                this.socket.accept(address, this);
            }
            catch (Throwable t) {
                Nio2Acceptor.this.log.error("Failed (" + t.getClass().getSimpleName() + " to re-accept new connections on " + address + ": " + t.getMessage(), t);
            }
        }
    }
}

