/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.signature;

import io.jenkins.cli.shaded.org.apache.sshd.common.NamedFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.NamedResource;
import io.jenkins.cli.shaded.org.apache.sshd.common.signature.BuiltinSignatures;
import io.jenkins.cli.shaded.org.apache.sshd.common.signature.Signature;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public interface SignatureFactoriesManager {
    public List<NamedFactory<Signature>> getSignatureFactories();

    default public String getSignatureFactoriesNameList() {
        return NamedResource.getNames(this.getSignatureFactories());
    }

    default public List<String> getSignatureFactoriesNames() {
        return NamedResource.getNameList(this.getSignatureFactories());
    }

    public void setSignatureFactories(List<NamedFactory<Signature>> var1);

    default public void setSignatureFactoriesNameList(String names) {
        this.setSignatureFactoriesNames(GenericUtils.split(names, ','));
    }

    default public void setSignatureFactoriesNames(String ... names) {
        this.setSignatureFactoriesNames(GenericUtils.isEmpty((Object[])names) ? Collections.emptyList() : Arrays.asList(names));
    }

    default public void setSignatureFactoriesNames(Collection<String> names) {
        BuiltinSignatures.ParseResult result = BuiltinSignatures.parseSignatureList(names);
        List<NamedFactory<Signature>> factories = ValidateUtils.checkNotNullAndNotEmpty(result.getParsedFactories(), "No supported signature factories: %s", names);
        List<String> unsupported = result.getUnsupportedFactories();
        ValidateUtils.checkTrue(GenericUtils.isEmpty(unsupported), "Unsupported signature factories found: %s", unsupported);
        this.setSignatureFactories(factories);
    }

    public static List<NamedFactory<Signature>> resolveSignatureFactories(SignatureFactoriesManager primary, SignatureFactoriesManager secondary) {
        List<NamedFactory<Signature>> factories = SignatureFactoriesManager.getSignatureFactories(primary);
        return GenericUtils.isEmpty(factories) ? SignatureFactoriesManager.getSignatureFactories(secondary) : factories;
    }

    public static List<NamedFactory<Signature>> getSignatureFactories(SignatureFactoriesManager manager) {
        return manager == null ? null : manager.getSignatureFactories();
    }
}

