/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.subsystem.sftp;

import io.jenkins.cli.shaded.org.apache.sshd.client.subsystem.sftp.SftpClient;
import io.jenkins.cli.shaded.org.apache.sshd.client.subsystem.sftp.SftpPath;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SftpPathIterator
implements Iterator<Path> {
    private final SftpPath p;
    private final Iterator<? extends SftpClient.DirEntry> it;
    private boolean dotIgnored;
    private boolean dotdotIgnored;
    private SftpClient.DirEntry curEntry;

    public SftpPathIterator(SftpPath path, Iterable<? extends SftpClient.DirEntry> iter) {
        this(path, iter == null ? null : iter.iterator());
    }

    public SftpPathIterator(SftpPath path, Iterator<? extends SftpClient.DirEntry> iter) {
        this.p = path;
        this.it = iter;
        this.curEntry = this.nextEntry();
    }

    @Override
    public boolean hasNext() {
        return this.curEntry != null;
    }

    @Override
    public Path next() {
        if (this.curEntry == null) {
            throw new NoSuchElementException("No next entry");
        }
        SftpClient.DirEntry entry = this.curEntry;
        this.curEntry = this.nextEntry();
        return this.p.resolve(entry.getFilename());
    }

    private SftpClient.DirEntry nextEntry() {
        while (this.it != null && this.it.hasNext()) {
            SftpClient.DirEntry entry = this.it.next();
            String name = entry.getFilename();
            if (".".equals(name) && !this.dotIgnored) {
                this.dotIgnored = true;
                continue;
            }
            if ("..".equals(name) && !this.dotdotIgnored) {
                this.dotdotIgnored = true;
                continue;
            }
            return entry;
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("newDirectoryStream(" + this.p + ") Iterator#remove() N/A");
    }
}

