/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.keyverifier;

import io.jenkins.cli.shaded.org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import io.jenkins.cli.shaded.org.apache.sshd.client.session.ClientSession;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.BufferUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.logging.AbstractLoggingBean;
import java.net.SocketAddress;
import java.security.PublicKey;

public class RequiredServerKeyVerifier
extends AbstractLoggingBean
implements ServerKeyVerifier {
    private final PublicKey requiredKey;

    public RequiredServerKeyVerifier(PublicKey requiredKey) {
        this.requiredKey = requiredKey;
    }

    public final PublicKey getRequiredKey() {
        return this.requiredKey;
    }

    @Override
    public boolean verifyServerKey(ClientSession sshClientSession, SocketAddress remoteAddress, PublicKey serverKey) {
        if (this.requiredKey.equals(serverKey)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Server at {} presented expected key: {}", (Object)remoteAddress, (Object)BufferUtils.toHex(serverKey.getEncoded()));
            }
            return true;
        }
        this.log.error("Server at {} presented wrong key: {}", (Object)remoteAddress, (Object)BufferUtils.toHex(serverKey.getEncoded()));
        return false;
    }
}

