/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.config.hosts;

import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import java.util.regex.Pattern;

public class HostPatternValue {
    private Pattern pattern;
    private int port;
    private boolean negated;

    public HostPatternValue() {
    }

    public HostPatternValue(Pattern pattern, boolean negated) {
        this(pattern, 0, negated);
    }

    public HostPatternValue(Pattern pattern, int port, boolean negated) {
        this.pattern = pattern;
        this.port = port;
        this.negated = negated;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public void setNegated(boolean negated) {
        this.negated = negated;
    }

    public String toString() {
        int portValue;
        Pattern p = this.getPattern();
        String purePattern = p == null ? null : p.pattern();
        StringBuilder sb = new StringBuilder(GenericUtils.length(purePattern) + 16);
        if (this.isNegated()) {
            sb.append('!');
        }
        if ((portValue = this.getPort()) > 0) {
            sb.append('[');
        }
        sb.append(purePattern);
        if (portValue > 0) {
            sb.append(']');
            sb.append(':');
            sb.append(portValue);
        }
        return sb.toString();
    }
}

