/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.simple;

import io.jenkins.cli.shaded.org.apache.sshd.client.config.hosts.HostConfigEntry;
import io.jenkins.cli.shaded.org.apache.sshd.client.future.AuthFuture;
import io.jenkins.cli.shaded.org.apache.sshd.client.future.ConnectFuture;
import io.jenkins.cli.shaded.org.apache.sshd.client.session.ClientSession;
import io.jenkins.cli.shaded.org.apache.sshd.client.session.ClientSessionCreator;
import io.jenkins.cli.shaded.org.apache.sshd.client.simple.AbstractSimpleClient;
import io.jenkins.cli.shaded.org.apache.sshd.client.simple.SimpleClient;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.Channel;
import java.security.KeyPair;
import java.util.Objects;

public abstract class AbstractSimpleClientSessionCreator
extends AbstractSimpleClient
implements ClientSessionCreator {
    private long connectTimeout;
    private long authenticateTimeout;

    protected AbstractSimpleClientSessionCreator() {
        this(Long.MAX_VALUE, Long.MAX_VALUE);
    }

    protected AbstractSimpleClientSessionCreator(long connTimeout, long authTimeout) {
        this.setConnectTimeout(connTimeout);
        this.setAuthenticationTimeout(authTimeout);
    }

    @Override
    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(long timeout) {
        ValidateUtils.checkTrue(timeout > 0L, "Non-positive connect timeout: %d", timeout);
        this.connectTimeout = timeout;
    }

    @Override
    public long getAuthenticationTimeout() {
        return this.authenticateTimeout;
    }

    @Override
    public void setAuthenticationTimeout(long timeout) {
        ValidateUtils.checkTrue(timeout > 0L, "Non-positive authentication timeout: %d", timeout);
        this.authenticateTimeout = timeout;
    }

    @Override
    public ClientSession sessionLogin(SocketAddress target, String username, String password) throws IOException {
        return this.loginSession(this.connect(username, target), password);
    }

    @Override
    public ClientSession sessionLogin(SocketAddress target, String username, KeyPair identity) throws IOException {
        return this.loginSession(this.connect(username, target), identity);
    }

    protected ClientSession loginSession(ConnectFuture future, String password) throws IOException {
        return this.authSession((ConnectFuture)future.verify(this.getConnectTimeout()), password);
    }

    protected ClientSession loginSession(ConnectFuture future, KeyPair identity) throws IOException {
        return this.authSession((ConnectFuture)future.verify(this.getConnectTimeout()), identity);
    }

    protected ClientSession authSession(ConnectFuture future, String password) throws IOException {
        ClientSession session = future.getSession();
        session.addPasswordIdentity(password);
        return this.authSession(session);
    }

    protected ClientSession authSession(ConnectFuture future, KeyPair identity) throws IOException {
        ClientSession session = future.getSession();
        session.addPublicKeyIdentity(identity);
        return this.authSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClientSession authSession(ClientSession clientSession) throws IOException {
        ClientSession session = clientSession;
        IOException err = null;
        try {
            AuthFuture auth = session.auth();
            auth.verify(this.getAuthenticationTimeout());
            session = null;
        }
        catch (IOException e) {
            err = GenericUtils.accumulateException(err, e);
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (IOException e) {
                    err = GenericUtils.accumulateException(err, e);
                }
            }
        }
        if (err != null) {
            throw err;
        }
        return clientSession;
    }

    public static SimpleClient wrap(final ClientSessionCreator creator, final Channel channel) {
        Objects.requireNonNull(creator, "No sessions creator");
        Objects.requireNonNull(channel, "No channel");
        return new AbstractSimpleClientSessionCreator(){

            @Override
            public ConnectFuture connect(String username, String host, int port) throws IOException {
                return creator.connect(username, host, port);
            }

            @Override
            public ConnectFuture connect(String username, SocketAddress address) throws IOException {
                return creator.connect(username, address);
            }

            @Override
            public ConnectFuture connect(HostConfigEntry hostConfig) throws IOException {
                return creator.connect(hostConfig);
            }

            @Override
            public boolean isOpen() {
                return channel.isOpen();
            }

            @Override
            public void close() throws IOException {
                channel.close();
            }
        };
    }
}

