/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.agent.unix;

import io.jenkins.cli.shaded.org.apache.sshd.agent.SshAgent;
import io.jenkins.cli.shaded.org.apache.sshd.agent.SshAgentFactory;
import io.jenkins.cli.shaded.org.apache.sshd.agent.SshAgentServer;
import io.jenkins.cli.shaded.org.apache.sshd.agent.unix.AgentClient;
import io.jenkins.cli.shaded.org.apache.sshd.agent.unix.AgentServerProxy;
import io.jenkins.cli.shaded.org.apache.sshd.agent.unix.ChannelAgentForwardingFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.FactoryManager;
import io.jenkins.cli.shaded.org.apache.sshd.common.NamedFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.NamedResource;
import io.jenkins.cli.shaded.org.apache.sshd.common.SshException;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.Channel;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.ConnectionService;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.Session;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.threads.ExecutorServiceConfigurer;
import io.jenkins.cli.shaded.org.apache.sshd.server.session.ServerSession;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;

public class UnixAgentFactory
implements SshAgentFactory,
ExecutorServiceConfigurer {
    public static final List<NamedFactory<Channel>> DEFAULT_FORWARDING_CHANNELS = Collections.unmodifiableList(Arrays.asList(ChannelAgentForwardingFactory.OPENSSH, ChannelAgentForwardingFactory.IETF));
    private ExecutorService executor;
    private boolean shutdownExecutor;

    public UnixAgentFactory() {
    }

    public UnixAgentFactory(ExecutorService service, boolean shutdown) {
        this.executor = service;
        this.shutdownExecutor = shutdown;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executor;
    }

    @Override
    public void setExecutorService(ExecutorService service) {
        this.executor = service;
    }

    @Override
    public boolean isShutdownOnExit() {
        return this.shutdownExecutor;
    }

    @Override
    public void setShutdownOnExit(boolean shutdown) {
        this.shutdownExecutor = shutdown;
    }

    @Override
    public List<NamedFactory<Channel>> getChannelForwardingFactories(FactoryManager manager) {
        final UnixAgentFactory configurer = this;
        return Collections.unmodifiableList(new ArrayList<NamedFactory<Channel>>(DEFAULT_FORWARDING_CHANNELS.size()){
            private static final long serialVersionUID = 1L;
            {
                super(x0);
                for (NamedResource namedResource : DEFAULT_FORWARDING_CHANNELS) {
                    String channelType = namedResource.getName();
                    this.add(new ChannelAgentForwardingFactory(channelType){

                        @Override
                        public ExecutorService getExecutorService() {
                            return configurer.getExecutorService();
                        }

                        @Override
                        public boolean isShutdownOnExit() {
                            return configurer.isShutdownOnExit();
                        }
                    });
                }
            }
        });
    }

    @Override
    public SshAgent createClient(FactoryManager manager) throws IOException {
        String authSocket = manager.getString("SSH_AUTH_SOCK");
        if (GenericUtils.isEmpty(authSocket)) {
            throw new SshException("No SSH_AUTH_SOCK value");
        }
        return new AgentClient(authSocket, this.getExecutorService(), this.isShutdownOnExit());
    }

    @Override
    public SshAgentServer createServer(ConnectionService service) throws IOException {
        Session session = Objects.requireNonNull(service.getSession(), "No session");
        ValidateUtils.checkInstanceOf((Object)session, ServerSession.class, "The session used to create an agent server proxy must be a server session: %s", (Object)session);
        return new AgentServerProxy(service, this.getExecutorService(), this.isShutdownOnExit());
    }
}

