/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.config.keys;

import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.FilePasswordProvider;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.KeyEntryResolver;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.PrivateKeyEntryResolver;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.NumberUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Collection;
import java.util.Objects;

public interface PrivateKeyEntryDecoder<PUB extends PublicKey, PRV extends PrivateKey>
extends KeyEntryResolver<PUB, PRV>,
PrivateKeyEntryResolver {
    @Override
    default public PrivateKey resolve(String keyType, byte[] keyData) throws IOException, GeneralSecurityException {
        ValidateUtils.checkNotNullAndNotEmpty(keyType, "No key type provided");
        Collection<String> supported = this.getSupportedTypeNames();
        if (GenericUtils.size(supported) > 0 && supported.contains(keyType)) {
            return this.decodePrivateKey(FilePasswordProvider.EMPTY, keyData);
        }
        throw new InvalidKeySpecException("resolve(" + keyType + ") not in listed supported types: " + supported);
    }

    default public PRV decodePrivateKey(FilePasswordProvider passwordProvider, byte ... keyData) throws IOException, GeneralSecurityException {
        return this.decodePrivateKey(passwordProvider, keyData, 0, NumberUtils.length(keyData));
    }

    default public PRV decodePrivateKey(FilePasswordProvider passwordProvider, byte[] keyData, int offset, int length) throws IOException, GeneralSecurityException {
        if (length <= 0) {
            return null;
        }
        try (ByteArrayInputStream stream = new ByteArrayInputStream(keyData, offset, length);){
            PRV PRV = this.decodePrivateKey(passwordProvider, stream);
            return PRV;
        }
    }

    default public PRV decodePrivateKey(FilePasswordProvider passwordProvider, InputStream keyData) throws IOException, GeneralSecurityException {
        String type = KeyEntryResolver.decodeString(keyData);
        if (GenericUtils.isEmpty(type)) {
            throw new StreamCorruptedException("Missing key type string");
        }
        Collection<String> supported = this.getSupportedTypeNames();
        if (GenericUtils.isEmpty(supported) || !supported.contains(type)) {
            throw new InvalidKeySpecException("Reported key type (" + type + ") not in supported list: " + supported);
        }
        return this.decodePrivateKey(type, passwordProvider, keyData);
    }

    public PRV decodePrivateKey(String var1, FilePasswordProvider var2, InputStream var3) throws IOException, GeneralSecurityException;

    default public String encodePrivateKey(OutputStream s, PRV key) throws IOException {
        Objects.requireNonNull(key, "No private key provided");
        return null;
    }

    default public boolean isPublicKeyRecoverySupported() {
        return false;
    }

    default public PUB recoverPublicKey(PRV prvKey) throws GeneralSecurityException {
        return null;
    }
}

