/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.session.helpers;

import io.jenkins.cli.shaded.org.apache.sshd.common.RuntimeSshException;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoHandler;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoSession;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.helpers.AbstractSession;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.Readable;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.logging.AbstractLoggingBean;

public abstract class AbstractSessionIoHandler
extends AbstractLoggingBean
implements IoHandler {
    protected AbstractSessionIoHandler() {
    }

    @Override
    public void sessionCreated(IoSession ioSession) throws Exception {
        ValidateUtils.checkNotNull(this.createSession(ioSession), "No session created for %s", (Object)ioSession);
    }

    @Override
    public void sessionClosed(IoSession ioSession) throws Exception {
        AbstractSession session = ValidateUtils.checkNotNull(AbstractSession.getSession(ioSession), "No abstract session to handle closure of %s", (Object)ioSession);
        session.close(true);
    }

    @Override
    public void exceptionCaught(IoSession ioSession, Throwable cause) throws Exception {
        AbstractSession session = AbstractSession.getSession(ioSession, true);
        if (session == null) {
            throw new IllegalStateException("No session available", cause);
        }
        session.exceptionCaught(cause);
    }

    @Override
    public void messageReceived(IoSession ioSession, Readable message) throws Exception {
        AbstractSession session = ValidateUtils.checkNotNull(AbstractSession.getSession(ioSession), "No abstract session to handle incoming message for %s", (Object)ioSession);
        try {
            session.messageReceived(message);
        }
        catch (Error e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("messageReceived({}) failed {} to handle message: {}", ioSession, e.getClass().getSimpleName(), e.getMessage());
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("messageReceived(" + ioSession + ") message handling error details", e);
            }
            throw new RuntimeSshException(e);
        }
    }

    protected abstract AbstractSession createSession(IoSession var1) throws Exception;
}

