/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.remoting.SocketInputStream;
import hudson.remoting.SocketOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.AlgorithmParameterGenerator;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connection {
    public final InputStream in;
    public final OutputStream out;
    public final DataInputStream din;
    public final DataOutputStream dout;

    public Connection(Socket socket) throws IOException {
        this((InputStream)new SocketInputStream(socket), (OutputStream)new SocketOutputStream(socket));
    }

    public Connection(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        this.din = new DataInputStream(in);
        this.dout = new DataOutputStream(out);
    }

    public void writeUTF(String msg) throws IOException {
        this.dout.writeUTF(msg);
    }

    public String readUTF() throws IOException {
        return this.din.readUTF();
    }

    public void writeBoolean(boolean b) throws IOException {
        this.dout.writeBoolean(b);
    }

    public boolean readBoolean() throws IOException {
        return this.din.readBoolean();
    }

    public void writeObject(Object o) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(this.out);
        oos.writeObject(o);
    }

    public <T> T readObject() throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(this.in);
        return (T)ois.readObject();
    }

    public void writeKey(Key key) throws IOException {
        this.writeUTF(new String(Base64.encodeBase64((byte[])key.getEncoded())));
    }

    public X509EncodedKeySpec readKey() throws IOException {
        byte[] otherHalf = Base64.decodeBase64((String)this.readUTF());
        return new X509EncodedKeySpec(otherHalf);
    }

    public KeyAgreement diffieHellman(boolean side) throws IOException, GeneralSecurityException {
        PublicKey otherHalf;
        KeyPair keyPair;
        if (side) {
            AlgorithmParameterGenerator paramGen = AlgorithmParameterGenerator.getInstance("DH");
            paramGen.init(512);
            KeyPairGenerator dh = KeyPairGenerator.getInstance("DH");
            dh.initialize(paramGen.generateParameters().getParameterSpec(DHParameterSpec.class));
            keyPair = dh.generateKeyPair();
            this.writeKey(keyPair.getPublic());
            otherHalf = KeyFactory.getInstance("DH").generatePublic(this.readKey());
        } else {
            otherHalf = KeyFactory.getInstance("DH").generatePublic(this.readKey());
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("DH");
            keyPairGen.initialize(((DHPublicKey)otherHalf).getParams());
            keyPair = keyPairGen.generateKeyPair();
            this.writeKey(keyPair.getPublic());
        }
        KeyAgreement ka = KeyAgreement.getInstance("DH");
        ka.init(keyPair.getPrivate());
        ka.doPhase(otherHalf, true);
        return ka;
    }

    private String detectKeyAlgorithm(KeyPair kp) {
        return this.detectKeyAlgorithm(kp.getPublic());
    }

    private String detectKeyAlgorithm(PublicKey kp) {
        if (kp instanceof RSAPublicKey) {
            return "RSA";
        }
        if (kp instanceof DSAPublicKey) {
            return "DSA";
        }
        throw new IllegalArgumentException("Unknown public key type: " + kp);
    }

    public void proveIdentity(byte[] sharedSecret, KeyPair key) throws IOException, GeneralSecurityException {
        String algorithm = this.detectKeyAlgorithm(key);
        this.writeUTF(algorithm);
        this.writeKey(key.getPublic());
        Signature sig = Signature.getInstance("SHA1with" + algorithm);
        sig.initSign(key.getPrivate());
        sig.update(key.getPublic().getEncoded());
        sig.update(sharedSecret);
        this.writeObject(sig.sign());
    }

    public PublicKey verifyIdentity(byte[] sharedSecret) throws IOException, GeneralSecurityException {
        try {
            String serverKeyAlgorithm = this.readUTF();
            PublicKey spk = KeyFactory.getInstance(serverKeyAlgorithm).generatePublic(this.readKey());
            Signature sig = Signature.getInstance("SHA1with" + serverKeyAlgorithm);
            sig.initVerify(spk);
            sig.update(spk.getEncoded());
            sig.update(sharedSecret);
            sig.verify((byte[])this.readObject());
            return spk;
        }
        catch (ClassNotFoundException e) {
            throw new Error(e);
        }
    }

    public void close() throws IOException {
        this.in.close();
        this.out.close();
    }
}

