/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.TextUtil;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.WebResponseImpl;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockWebConnection
implements WebConnection {
    private static final Log LOG = LogFactory.getLog(MockWebConnection.class);
    private final Map<String, WebResponseData> responseMap_ = new HashMap<String, WebResponseData>(10);
    private WebResponseData defaultResponse_;
    private WebRequestSettings lastRequest_;
    private int requestCount_ = 0;

    @Override
    public WebResponse getResponse(WebRequestSettings settings) throws IOException {
        URL url = settings.getUrl();
        LOG.debug((Object)("Getting response for " + url.toExternalForm()));
        this.lastRequest_ = settings;
        ++this.requestCount_;
        WebResponseData response = this.responseMap_.get(url.toExternalForm());
        if (response == null && (response = this.defaultResponse_) == null) {
            throw new IllegalStateException("No response specified that can handle URL [" + url.toExternalForm() + "]");
        }
        return new WebResponseImpl(response, settings, 0L);
    }

    public HttpMethod getLastMethod() {
        return this.lastRequest_.getHttpMethod();
    }

    public List<NameValuePair> getLastParameters() {
        return this.lastRequest_.getRequestParameters();
    }

    public void setResponse(URL url, String content, int statusCode, String statusMessage, String contentType, List<? extends NameValuePair> responseHeaders) {
        this.setResponse(url, TextUtil.stringToByteArray(content), statusCode, statusMessage, contentType, responseHeaders);
    }

    public void setResponse(URL url, String content, int statusCode, String statusMessage, String contentType, String charset, List<? extends NameValuePair> responseHeaders) {
        this.setResponse(url, TextUtil.stringToByteArray(content, charset), statusCode, statusMessage, contentType, responseHeaders);
    }

    public void setResponse(URL url, byte[] content, int statusCode, String statusMessage, String contentType, List<? extends NameValuePair> responseHeaders) {
        ArrayList<NameValuePair> compiledHeaders = new ArrayList<NameValuePair>(responseHeaders);
        compiledHeaders.add((NameValuePair)new NameValuePair("Content-Type", contentType));
        WebResponseData responseEntry = new WebResponseData(content, statusCode, statusMessage, compiledHeaders);
        this.responseMap_.put(url.toExternalForm(), responseEntry);
    }

    public void setResponse(URL url, String content) {
        List emptyList = Collections.emptyList();
        this.setResponse(url, content, 200, "OK", "text/html", emptyList);
    }

    public void setResponse(URL url, String content, String contentType) {
        List emptyList = Collections.emptyList();
        this.setResponse(url, content, 200, "OK", contentType, emptyList);
    }

    public void setResponse(URL url, String content, String contentType, String charset) {
        List emptyList = Collections.emptyList();
        this.setResponse(url, content, 200, "OK", contentType, charset, emptyList);
    }

    public void setResponseAsGenericHtml(URL url, String title) {
        String content = "<html><head><title>" + title + "</title></head><body></body></html>";
        this.setResponse(url, content);
    }

    public void setDefaultResponse(String content, int statusCode, String statusMessage, String contentType) {
        this.setDefaultResponse(TextUtil.stringToByteArray(content), statusCode, statusMessage, contentType);
    }

    public void setDefaultResponse(byte[] content, int statusCode, String statusMessage, String contentType) {
        WebResponseData responseEntry;
        ArrayList<NameValuePair> compiledHeaders = new ArrayList<NameValuePair>();
        compiledHeaders.add(new NameValuePair("Content-Type", contentType));
        this.defaultResponse_ = responseEntry = new WebResponseData(content, statusCode, statusMessage, compiledHeaders);
    }

    public void setDefaultResponse(String content) {
        this.setDefaultResponse(content, 200, "OK", "text/html");
    }

    public void setDefaultResponse(String content, String contentType) {
        List emptyList = Collections.emptyList();
        this.setDefaultResponse(content, 200, "OK", contentType, emptyList);
    }

    public void setDefaultResponse(String content, String contentType, String charset) {
        List emptyList = Collections.emptyList();
        this.setDefaultResponse(content, 200, "OK", contentType, charset, emptyList);
    }

    public void setDefaultResponse(String content, int statusCode, String statusMessage, String contentType, List<? extends NameValuePair> responseHeaders) {
        ArrayList<NameValuePair> compiledHeaders = new ArrayList<NameValuePair>(responseHeaders);
        compiledHeaders.add((NameValuePair)new NameValuePair("Content-Type", contentType));
        this.defaultResponse_ = new WebResponseData(TextUtil.stringToByteArray(content), statusCode, statusMessage, compiledHeaders);
    }

    public void setDefaultResponse(String content, int statusCode, String statusMessage, String contentType, String charset, List<? extends NameValuePair> responseHeaders) {
        ArrayList<NameValuePair> compiledHeaders = new ArrayList<NameValuePair>(responseHeaders);
        compiledHeaders.add((NameValuePair)new NameValuePair("Content-Type", contentType));
        this.defaultResponse_ = new WebResponseData(TextUtil.stringToByteArray(content, charset), statusCode, statusMessage, compiledHeaders);
    }

    public Map<String, String> getLastAdditionalHeaders() {
        return this.lastRequest_.getAdditionalHeaders();
    }

    public WebRequestSettings getLastWebRequestSettings() {
        return this.lastRequest_;
    }

    public int getRequestCount() {
        return this.requestCount_;
    }
}

