/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.crypto;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Signature;
import java.security.SignatureException;
import org.apache.commons.io.output.NullOutputStream;

public class SignatureOutputStream
extends FilterOutputStream {
    private final Signature sig;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Not actionable.")
    public SignatureOutputStream(OutputStream out, Signature sig) {
        super(out);
        this.sig = sig;
    }

    public SignatureOutputStream(Signature sig) {
        this((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM, sig);
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.sig.update((byte)b);
            this.out.write(b);
        }
        catch (SignatureException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(@NonNull byte[] b, int off, int len) throws IOException {
        try {
            this.sig.update(b, off, len);
            this.out.write(b, off, len);
        }
        catch (SignatureException e) {
            throw new IOException(e);
        }
    }
}

