/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.bytecode;

import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.bytecode.AdapterAnnotation;
import org.jenkinsci.bytecode.AdapterAnnotationParser;
import org.jenkinsci.bytecode.Kind;
import org.jenkinsci.bytecode.MemberTransformSpec;
import org.jenkinsci.bytecode.NameAndType;
import org.jenkinsci.constant_pool_scanner.ConstantPool;
import org.jenkinsci.constant_pool_scanner.ConstantPoolScanner;
import org.jenkinsci.constant_pool_scanner.ConstantType;
import org.jenkinsci.constant_pool_scanner.FieldRefConstant;
import org.jenkinsci.constant_pool_scanner.MemberRefConstant;
import org.jenkinsci.constant_pool_scanner.MethodRefConstant;
import org.jvnet.hudson.annotation_indexer.Index;

class TransformationSpec {
    final MemberTransformSpec fields;
    final MemberTransformSpec methods;
    private static final Logger LOGGER = Logger.getLogger(TransformationSpec.class.getName());

    TransformationSpec() {
        this.fields = new MemberTransformSpec(Kind.FIELD);
        this.methods = new MemberTransformSpec(Kind.METHOD);
    }

    TransformationSpec(TransformationSpec that) {
        this.fields = new MemberTransformSpec(that.fields);
        this.methods = new MemberTransformSpec(that.methods);
    }

    void loadRule(ClassLoader cl) throws IOException {
        for (Class annotation : Index.list(AdapterAnnotation.class, (ClassLoader)cl, Class.class)) {
            AdapterAnnotationParser f;
            AdapterAnnotation aa = annotation.getAnnotation(AdapterAnnotation.class);
            try {
                f = aa.value().newInstance();
            }
            catch (InstantiationException e) {
                LOGGER.log(Level.WARNING, "Failed to instantiate " + aa.value(), e);
                continue;
            }
            catch (IllegalAccessException e) {
                LOGGER.log(Level.WARNING, "Failed to instantiate " + aa.value(), e);
                continue;
            }
            for (AnnotatedElement e : Index.list((Class)annotation, (ClassLoader)cl)) {
                f.parse(this, e);
            }
        }
    }

    boolean mayNeedTransformation(byte[] image) {
        try {
            ConstantPool p = ConstantPoolScanner.parse((byte[])image, (ConstantType[])new ConstantType[]{ConstantType.FIELD_REF, ConstantType.METHOD_REF});
            for (FieldRefConstant r : p.list(FieldRefConstant.class)) {
                if (!this.fields.containsKey(new NameAndType((MemberRefConstant)r))) continue;
                LOGGER.log(Level.FINEST, "mayNeedTransformation returning true - fields.containsKey({0}) - {1}", new Object[]{r.getName(), r.getClazz()});
                return true;
            }
            for (FieldRefConstant r : p.list(MethodRefConstant.class)) {
                if (!this.methods.containsKey(new NameAndType((MemberRefConstant)r))) continue;
                LOGGER.log(Level.FINEST, "mayNeedTransformation returning true - methods.containsKey({0}) - {1}", new Object[]{r.getName(), r.getClazz()});
                return true;
            }
            LOGGER.log(Level.FINEST, "mayNeedTransformation returning false");
            return false;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to parse the constant pool", e);
            return false;
        }
    }
}

