/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.bytecode;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ClassWriter
extends org.kohsuke.asm5.ClassWriter {
    private static final Logger LOGGER = Logger.getLogger(ClassWriter.class.getName());
    private final ClassLoader classLoader;

    public ClassWriter(ClassLoader classLoader, int flags) {
        super(flags);
        this.classLoader = classLoader;
    }

    protected String getCommonSuperClass(String type1, String type2) {
        LOGGER.log(Level.FINER, "Searching for common super class of {0} and {1}", new Object[]{type1, type2});
        Class<?> c = ClassWriter.loadClass(type1.replace('/', '.'), this.classLoader);
        Class<?> d = ClassWriter.loadClass(type2.replace('/', '.'), this.classLoader);
        if (c.isAssignableFrom(d)) {
            return type1;
        }
        if (d.isAssignableFrom(c)) {
            return type2;
        }
        if (c.isInterface() || d.isInterface()) {
            return "java/lang/Object";
        }
        while (!(c = c.getSuperclass()).isAssignableFrom(d)) {
        }
        return c.getName().replace('.', '/');
    }

    private static Class<?> loadClass(String className, Collection<? extends ClassLoader> classLoaders) {
        for (ClassLoader classLoader : classLoaders) {
            try {
                return Class.forName(className, false, classLoader);
            }
            catch (ClassNotFoundException e) {
            }
        }
        throw new RuntimeException("java.lang.ClassNotFoundException: " + className);
    }

    private static Class<?> loadClass(String className, ClassLoader classLoader) {
        try {
            return Class.forName(className, false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("java.lang.ClassNotFoundException: " + className);
        }
    }
}

