/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.weibo.util;

import com.alipay.api.internal.util.StringUtils;
import com.jeecg.weibo.dto.WeiboSendDto;
import com.jeecg.weibo.exception.BusinessException;
import java.net.URLEncoder;

public class WeiboSendUtil {
    public static void getSendParmValidate(WeiboSendDto send) {
        if (StringUtils.isEmpty((String)send.getAccess_token())) {
            throw new BusinessException("access_token\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)send.getStatus())) {
            throw new BusinessException("\u53d1\u5e03\u5fae\u535a\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static String getSendUrl(String interUrl, WeiboSendDto send) {
        StringBuilder requestUrl = new StringBuilder();
        requestUrl.append(interUrl);
        if (!StringUtils.isEmpty((String)send.getAccess_token())) {
            requestUrl.append("&access_token=" + send.getAccess_token());
        }
        if (!StringUtils.isEmpty((String)send.getStatus())) {
            requestUrl.append("&status=" + send.getStatus());
        }
        if (!StringUtils.isEmpty((String)send.getUrl())) {
            String url = URLEncoder.encode(send.getUrl());
            requestUrl.append("&url=" + url);
        }
        return requestUrl.toString();
    }

    public static void delParmValidate(WeiboSendDto send) {
        if (StringUtils.isEmpty((String)send.getAccess_token())) {
            throw new BusinessException("access_token\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)send.getId())) {
            throw new BusinessException("\u5fae\u535aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static String getDelUrl(String interUrl, WeiboSendDto send) {
        StringBuilder requestUrl = new StringBuilder();
        requestUrl.append(interUrl);
        if (!StringUtils.isEmpty((String)send.getAccess_token())) {
            requestUrl.append("&access_token=" + send.getAccess_token());
        }
        if (!StringUtils.isEmpty((String)send.getId())) {
            requestUrl.append("&id=" + send.getId());
        }
        return requestUrl.toString();
    }
}

