/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.qywx.api.conversation;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jeecg.qywx.api.conversation.vo.BaseMessage;
import com.jeecg.qywx.api.conversation.vo.Conversation;
import com.jeecg.qywx.api.conversation.vo.Conversation4Update;
import com.jeecg.qywx.api.conversation.vo.Mute;
import com.jeecg.qywx.api.core.common.MsgResponse;
import com.jeecg.qywx.api.core.util.HttpUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversationAPI {
    private static final Logger logger = LoggerFactory.getLogger(ConversationAPI.class);
    private static String conversation_create_url = "https://qyapi.weixin.qq.com/cgi-bin/chat/create?access_token=ACCESS_TOKEN";
    private static String conversation_get_url = "https://qyapi.weixin.qq.com/cgi-bin/chat/get?access_token=ACCESS_TOKEN&chatid=CHATID";
    private static String conversation_update_url = "https://qyapi.weixin.qq.com/cgi-bin/chat/update?access_token=ACCESS_TOKEN";
    private static String conversation_quit_url = "https://qyapi.weixin.qq.com/cgi-bin/chat/quit?access_token=ACCESS_TOKEN";
    private static String conversation_clearnotifay_url = "https://qyapi.weixin.qq.com/cgi-bin/chat/clearnotify?access_token=ACCESS_TOKEN";
    private static String conversation_send_url = "https://qyapi.weixin.qq.com/cgi-bin/chat/send?access_token=ACCESS_TOKEN";
    private static String conversation_setmute_url = "https://qyapi.weixin.qq.com/cgi-bin/chat/setmute?access_token=ACCESS_TOKEN";

    public static MsgResponse createConversation(Conversation conversation, String accessToken) {
        MsgResponse msgResponse = new MsgResponse();
        String errmsg = "ok";
        int result = -1;
        logger.info("[CREATECONVERSATION]", (Object)"createConversation param:conversation:{},accessToken:{}", (Object)new Object[]{conversation, accessToken});
        String url = conversation_create_url.replace("ACCESS_TOKEN", accessToken);
        String jsonContent = JSONObject.toJSONString((Object)conversation);
        logger.info("[CREATECONVERSATION]", (Object)"createConversation param:jsonUser:{}", (Object)new Object[]{jsonContent});
        JSONObject jsonObject = HttpUtil.sendPost(url, jsonContent);
        logger.info("[CREATECONVERSATION]", (Object)"createConversation response:{}", (Object)new Object[]{jsonObject.toJSONString()});
        if (null != jsonObject) {
            int errcode = jsonObject.getIntValue("errcode");
            if (jsonObject.containsKey((Object)"errmsg")) {
                errmsg = jsonObject.getString("errmsg");
            }
            result = errcode;
        }
        msgResponse.setErrcode(result);
        msgResponse.setErrmsg(errmsg);
        return msgResponse;
    }

    public static Conversation getConversation(String chatid, String accessToken) {
        int errcode;
        logger.info("[GETCONVERSATION]", (Object)"getConversation param:chatid:{},accessToken:{}", (Object)new Object[]{chatid, accessToken});
        String url = conversation_get_url.replace("ACCESS_TOKEN", accessToken).replace("CHATID", chatid);
        JSONObject jsonObject = HttpUtil.sendPost(url);
        logger.info("[GETCONVERSATION]", (Object)"getConversation response:{}", (Object)new Object[]{jsonObject.toJSONString()});
        if (null != jsonObject && (errcode = jsonObject.getIntValue("errcode")) == 0) {
            Conversation conversation = (Conversation)JSONObject.toJavaObject((JSON)jsonObject, Conversation.class);
            return conversation;
        }
        return null;
    }

    public static MsgResponse updateConversation(Conversation4Update converstation, String accessToken) {
        MsgResponse msgResponse = new MsgResponse();
        String errmsg = "ok";
        int result = -1;
        String jsonContent = JSONObject.toJSONString((Object)converstation);
        String url = conversation_update_url.replace("ACCESS_TOKEN", accessToken);
        JSONObject jsonObject = HttpUtil.sendPost(url, jsonContent);
        try {
            if (jsonObject != null) {
                int errcode = jsonObject.getIntValue("errcode");
                errmsg = jsonObject.getString("errmsg");
                result = errcode;
            }
            msgResponse.setErrcode(result);
            msgResponse.setErrmsg(errmsg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return msgResponse;
    }

    public static MsgResponse quit(String chatid, String opUser, String accessToken) {
        MsgResponse msgResponse = new MsgResponse();
        String errmsg = "ok";
        int result = -1;
        JSONObject jsonContent = new JSONObject();
        jsonContent.put("chatid", (Object)chatid);
        jsonContent.put("op_user", (Object)opUser);
        String url = conversation_quit_url.replace("ACCESS_TOKEN", accessToken);
        JSONObject jsonObject = HttpUtil.sendPost(url, jsonContent.toJSONString());
        if (null != jsonObject) {
            int errcode = jsonObject.getIntValue("errcode");
            if (jsonObject.containsKey((Object)"errmsg")) {
                errmsg = jsonObject.getString("errmsg");
            }
            result = errcode;
        }
        msgResponse.setErrcode(result);
        msgResponse.setErrmsg(errmsg);
        return msgResponse;
    }

    public static MsgResponse clearnotify(String chatidOrUserid, String type, String opUser, String accessToken) {
        MsgResponse msgResponse = new MsgResponse();
        String errmsg = "ok";
        int result = -1;
        JSONObject jsonContent = new JSONObject();
        JSONObject chat = new JSONObject();
        chat.put("id", (Object)chatidOrUserid);
        chat.put("type", (Object)type);
        jsonContent.put("chat", (Object)chat);
        jsonContent.put("op_user", (Object)opUser);
        String url = conversation_clearnotifay_url.replace("ACCESS_TOKEN", accessToken);
        JSONObject jsonObject = HttpUtil.sendPost(url, jsonContent.toJSONString());
        if (null != jsonObject) {
            int errcode = jsonObject.getIntValue("errcode");
            if (jsonObject.containsKey((Object)"errmsg")) {
                errmsg = jsonObject.getString("errmsg");
            }
            result = errcode;
        }
        msgResponse.setErrcode(result);
        msgResponse.setErrmsg(errmsg);
        return msgResponse;
    }

    public static MsgResponse sendMessage(BaseMessage message, String accessToken) {
        MsgResponse msgResponse = new MsgResponse();
        String errmsg = "ok";
        int result = -1;
        logger.info("[SENDMESSAGE]", (Object)"sendMessage param:conversation:{},accessToken:{}", (Object)new Object[]{message, accessToken});
        String url = conversation_send_url.replace("ACCESS_TOKEN", accessToken);
        String jsonContent = JSONObject.toJSONString((Object)message);
        logger.info("[SENDMESSAGE]", (Object)"sendMessage param:jsonUser:{}", (Object)new Object[]{jsonContent});
        JSONObject jsonObject = HttpUtil.sendPost(url, jsonContent);
        logger.info("[SENDMESSAGE]", (Object)"sendMessage response:{}", (Object)new Object[]{jsonObject.toJSONString()});
        if (null != jsonObject) {
            int errcode = jsonObject.getIntValue("errcode");
            if (jsonObject.containsKey((Object)"errmsg")) {
                errmsg = jsonObject.getString("errmsg");
            }
            result = errcode;
        }
        msgResponse.setErrcode(result);
        msgResponse.setErrmsg(errmsg);
        return msgResponse;
    }

    public static MsgResponse setMute(List<Mute> userlist, String accessToken) {
        MsgResponse msgResponse = new MsgResponse();
        String errmsg = "ok";
        int result = -1;
        JSONObject jsonContent = new JSONObject();
        if (userlist != null) {
            jsonContent.put("user_mute_list", (Object)JSONArray.toJSONString(userlist));
            String url = conversation_setmute_url.replace("ACCESS_TOKEN", accessToken);
            JSONObject jsonObject = HttpUtil.sendPost(url, jsonContent.toJSONString());
            if (null != jsonObject) {
                int errcode = jsonObject.getIntValue("errcode");
                if (jsonObject.containsKey((Object)"errmsg")) {
                    errmsg = jsonObject.getString("errmsg");
                }
                result = errcode;
            }
            msgResponse.setErrcode(result);
            msgResponse.setErrmsg(errmsg);
        }
        return msgResponse;
    }
}

