/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.repository.embedded;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.constant.Constants;
import com.alibaba.nacos.config.server.model.event.ConfigDumpEvent;
import com.alibaba.nacos.config.server.service.dump.DumpConfigHandler;
import com.alibaba.nacos.consistency.entity.WriteRequest;
import com.alibaba.nacos.core.utils.GenericType;
import com.alibaba.nacos.persistence.repository.embedded.hook.EmbeddedApplyHook;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.stereotype.Component;

@Component
public class EmbeddedConfigDumpApplyHook
extends EmbeddedApplyHook {
    public EmbeddedConfigDumpApplyHook() {
        NotifyCenter.registerToPublisher(ConfigDumpEvent.class, (int)NotifyCenter.ringBufferSize);
        NotifyCenter.registerSubscriber((Subscriber)new DumpConfigHandler());
    }

    public void afterApply(WriteRequest log) {
        this.handleExtendInfo(log.getExtendInfoMap());
    }

    private void handleExtendInfo(Map<String, String> extendInfo) {
        String jsonVal;
        if (extendInfo.containsKey(Constants.EXTEND_INFO_CONFIG_DUMP_EVENT)) {
            String jsonVal2 = extendInfo.get(Constants.EXTEND_INFO_CONFIG_DUMP_EVENT);
            if (StringUtils.isNotBlank((String)jsonVal2)) {
                NotifyCenter.publishEvent((Event)((Event)JacksonUtils.toObj((String)jsonVal2, ConfigDumpEvent.class)));
            }
            return;
        }
        if (extendInfo.containsKey(Constants.EXTEND_INFOS_CONFIG_DUMP_EVENT) && StringUtils.isNotBlank((String)(jsonVal = extendInfo.get(Constants.EXTEND_INFO_CONFIG_DUMP_EVENT)))) {
            List list = (List)JacksonUtils.toObj((String)jsonVal, (Type)new GenericType<List<ConfigDumpEvent>>(){}.getType());
            list.stream().filter(Objects::nonNull).forEach(NotifyCenter::publishEvent);
        }
    }
}

