/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.dump.processor;

import com.alibaba.nacos.common.task.NacosTask;
import com.alibaba.nacos.common.task.NacosTaskProcessor;
import com.alibaba.nacos.config.server.model.ConfigInfoBetaWrapper;
import com.alibaba.nacos.config.server.service.ConfigCacheService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoBetaPersistService;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.persistence.model.Page;

public class DumpAllBetaProcessor
implements NacosTaskProcessor {
    static final int PAGE_SIZE = 1000;
    final ConfigInfoBetaPersistService configInfoBetaPersistService;

    public DumpAllBetaProcessor(ConfigInfoBetaPersistService configInfoBetaPersistService) {
        this.configInfoBetaPersistService = configInfoBetaPersistService;
    }

    public boolean process(NacosTask task) {
        int rowCount = this.configInfoBetaPersistService.configInfoBetaCount();
        int pageCount = (int)Math.ceil((double)rowCount * 1.0 / 1000.0);
        int actualRowCount = 0;
        for (int pageNo = 1; pageNo <= pageCount; ++pageNo) {
            Page<ConfigInfoBetaWrapper> page = this.configInfoBetaPersistService.findAllConfigInfoBetaForDumpAll(pageNo, 1000);
            if (page == null) continue;
            for (ConfigInfoBetaWrapper cf : page.getPageItems()) {
                boolean result = ConfigCacheService.dumpBeta(cf.getDataId(), cf.getGroup(), cf.getTenant(), cf.getContent(), cf.getLastModified(), cf.getBetaIps(), cf.getEncryptedDataKey());
                LogUtil.DUMP_LOG.info("[dump-all-beta-ok] result={}, {}, {}, length={}, md5={}", new Object[]{result, GroupKey2.getKey(cf.getDataId(), cf.getGroup()), cf.getLastModified(), cf.getContent().length(), cf.getMd5()});
            }
            LogUtil.DEFAULT_LOG.info("[all-dump-beta] {} / {}", (Object)(actualRowCount += page.getPageItems().size()), (Object)rowCount);
        }
        return true;
    }
}

