/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.InternetAddressUtil;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.constant.Constants;
import com.alibaba.nacos.config.server.model.CacheItem;
import com.alibaba.nacos.config.server.model.ConfigCache;
import com.alibaba.nacos.config.server.model.event.LocalDataChangeEvent;
import com.alibaba.nacos.config.server.service.dump.disk.ConfigDiskServiceFactory;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class ConfigCacheService {
    private static final String NO_SPACE_CN = "\u8bbe\u5907\u4e0a\u6ca1\u6709\u7a7a\u95f4";
    private static final String NO_SPACE_EN = "No space left on device";
    private static final String DISK_QUOTA_CN = "\u8d85\u51fa\u78c1\u76d8\u9650\u989d";
    private static final String DISK_QUOTA_EN = "Disk quota exceeded";
    private static final ConcurrentHashMap<String, CacheItem> CACHE = new ConcurrentHashMap();
    private static final int TRY_GET_LOCK_TIMES = 9;

    public static int groupCount() {
        return CACHE.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean dumpWithMd5(String dataId, String group, String tenant, String content, String md5, long lastModifiedTs, String type, String encryptedDataKey) {
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        CacheItem ci = ConfigCacheService.makeSure(groupKey, encryptedDataKey);
        ci.setType(type);
        int lockResult = ConfigCacheService.tryWriteLock(groupKey);
        if (lockResult < 0) {
            LogUtil.DUMP_LOG.warn("[dump-error] write lock failed. {}", (Object)groupKey);
            return false;
        }
        try {
            String localContentMd5;
            boolean md5Changed;
            boolean newLastModified;
            boolean lastModifiedOutDated;
            boolean bl = lastModifiedOutDated = lastModifiedTs < ConfigCacheService.getLastModifiedTs(groupKey);
            if (lastModifiedOutDated) {
                LogUtil.DUMP_LOG.warn("[dump-ignore] timestamp is outdated,groupKey={}", (Object)groupKey);
                boolean bl2 = true;
                return bl2;
            }
            boolean bl3 = newLastModified = lastModifiedTs > ConfigCacheService.getLastModifiedTs(groupKey);
            if (md5 == null) {
                md5 = MD5Utils.md5Hex((String)content, (String)Constants.PERSIST_ENCODE);
            }
            boolean bl4 = md5Changed = !md5.equals(localContentMd5 = ConfigCacheService.getContentMd5(groupKey));
            if (md5Changed) {
                LogUtil.DUMP_LOG.info("[dump] md5 changed, save to disk cache ,groupKey={}, newMd5={},oldMd5={}", new Object[]{groupKey, md5, localContentMd5});
                ConfigDiskServiceFactory.getInstance().saveToDisk(dataId, group, tenant, content);
            } else {
                LogUtil.DUMP_LOG.warn("[dump-ignore] ignore to save to disk cache. md5 consistent,groupKey={}, md5={}", (Object)groupKey, (Object)md5);
            }
            if (md5Changed) {
                LogUtil.DUMP_LOG.info("[dump] md5 changed, update md5 and timestamp in jvm cache ,groupKey={}, newMd5={},oldMd5={},lastModifiedTs={}", new Object[]{groupKey, md5, localContentMd5, lastModifiedTs});
                ConfigCacheService.updateMd5(groupKey, md5, lastModifiedTs, encryptedDataKey);
            } else if (newLastModified) {
                LogUtil.DUMP_LOG.info("[dump] md5 consistent ,timestamp changed, update timestamp only in jvm cache ,groupKey={},lastModifiedTs={}", (Object)groupKey, (Object)lastModifiedTs);
                ConfigCacheService.updateTimeStamp(groupKey, lastModifiedTs, encryptedDataKey);
            } else {
                LogUtil.DUMP_LOG.warn("[dump-ignore] ignore to save to jvm cache. md5 consistent and no new timestamp changed.groupKey={}", (Object)groupKey);
            }
            boolean bl5 = true;
            return bl5;
        }
        catch (IOException ioe) {
            String errMsg;
            LogUtil.DUMP_LOG.error("[dump-exception] save disk error. " + groupKey + ", " + ioe);
            if (ioe.getMessage() != null && (NO_SPACE_CN.equals(errMsg = ioe.getMessage()) || NO_SPACE_EN.equals(errMsg) || errMsg.contains(DISK_QUOTA_CN) || errMsg.contains(DISK_QUOTA_EN))) {
                LogUtil.FATAL_LOG.error("Local Disk Full,Exit", (Throwable)ioe);
                EnvUtil.systemExit();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            ConfigCacheService.releaseWriteLock(groupKey);
        }
    }

    public static boolean dump(String dataId, String group, String tenant, String content, long lastModifiedTs, String type, String encryptedDataKey) {
        return ConfigCacheService.dumpWithMd5(dataId, group, tenant, content, null, lastModifiedTs, type, encryptedDataKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean dumpBeta(String dataId, String group, String tenant, String content, long lastModifiedTs, String betaIps, String encryptedDataKey) {
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        ConfigCacheService.makeSure(groupKey, null);
        int lockResult = ConfigCacheService.tryWriteLock(groupKey);
        if (lockResult < 0) {
            LogUtil.DUMP_LOG.warn("[dump-beta-error] write lock failed. {}", (Object)groupKey);
            return false;
        }
        try {
            boolean ipListChanged;
            boolean md5Changed;
            boolean timestampOutDated;
            boolean bl = timestampOutDated = lastModifiedTs < ConfigCacheService.getBetaLastModifiedTs(groupKey);
            if (timestampOutDated) {
                LogUtil.DUMP_LOG.warn("[dump-beta-ignore] timestamp is outdated,groupKey={}", (Object)groupKey);
                boolean bl2 = true;
                return bl2;
            }
            boolean timestampUpdated = lastModifiedTs > ConfigCacheService.getBetaLastModifiedTs(groupKey);
            Object[] betaIpsArr = betaIps.split(",");
            ArrayList betaIpList = Lists.newArrayList((Object[])betaIpsArr);
            String md5 = MD5Utils.md5Hex((String)content, (String)"UTF-8");
            String localContentBetaMd5 = ConfigCacheService.getContentBetaMd5(groupKey);
            boolean bl3 = md5Changed = !md5.equals(localContentBetaMd5);
            if (md5Changed) {
                LogUtil.DUMP_LOG.info("[dump-beta] md5 changed, update md5 in local disk cache. groupKey={}, newMd5={}, oldMd5={}", new Object[]{groupKey, md5, localContentBetaMd5});
                ConfigDiskServiceFactory.getInstance().saveBetaToDisk(dataId, group, tenant, content);
            }
            boolean bl4 = ipListChanged = !betaIpList.equals(ConfigCacheService.getBetaIps(groupKey));
            if (md5Changed) {
                LogUtil.DUMP_LOG.info("[dump-beta] md5 changed, update md5 & ip list & timestamp in jvm cache. groupKey={}, newMd5={}, oldMd5={}\uff0clastModifiedTs={}", new Object[]{groupKey, md5, localContentBetaMd5, lastModifiedTs});
                ConfigCacheService.updateBetaMd5(groupKey, md5, betaIpList, lastModifiedTs, encryptedDataKey);
            } else if (ipListChanged) {
                LogUtil.DUMP_LOG.warn("[dump-beta] ip list changed, update ip list & timestamp in jvm cache. groupKey={}, newIpList={}, oldIpList={}\uff0clastModifiedTs={}", new Object[]{groupKey, betaIpList, ConfigCacheService.getBetaIps(groupKey), lastModifiedTs});
                ConfigCacheService.updateBetaIpList(groupKey, betaIpList, lastModifiedTs);
            } else if (timestampUpdated) {
                LogUtil.DUMP_LOG.warn("[dump-beta] timestamp changed, update timestamp in jvm cache. groupKey={}, newLastModifiedTs={}, oldLastModifiedTs={}", new Object[]{groupKey, lastModifiedTs, ConfigCacheService.getBetaLastModifiedTs(groupKey)});
                ConfigCacheService.updateBetaTimeStamp(groupKey, lastModifiedTs);
            } else {
                LogUtil.DUMP_LOG.warn("[dump-beta-ignore] ignore to save jvm cache, md5 & ip list & timestamp no changed. groupKey={}", (Object)groupKey);
            }
            boolean bl5 = true;
            return bl5;
        }
        catch (IOException ioe) {
            LogUtil.DUMP_LOG.error("[dump-beta-exception] save disk error. " + groupKey + ", " + ioe.toString(), (Throwable)ioe);
            boolean bl = false;
            return bl;
        }
        finally {
            ConfigCacheService.releaseWriteLock(groupKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean dumpTag(String dataId, String group, String tenant, String tag, String content, long lastModifiedTs, String encryptedDataKey4Tag) {
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        ConfigCacheService.makeSure(groupKey, null);
        int lockResult = ConfigCacheService.tryWriteLock(groupKey);
        if (lockResult < 0) {
            LogUtil.DUMP_LOG.warn("[dump-tag-error] write lock failed. {}", (Object)groupKey);
            return false;
        }
        try {
            boolean md5Changed;
            boolean timestampOutdated;
            long localTagLastModifiedTs = ConfigCacheService.getTagLastModifiedTs(groupKey, tag);
            boolean bl = timestampOutdated = lastModifiedTs < localTagLastModifiedTs;
            if (timestampOutdated) {
                LogUtil.DUMP_LOG.warn("[dump-tag-ignore] timestamp is outdated,groupKey={}", (Object)groupKey);
                boolean bl2 = true;
                return bl2;
            }
            boolean timestampChanged = lastModifiedTs > localTagLastModifiedTs;
            String md5 = MD5Utils.md5Hex((String)content, (String)"UTF-8");
            String localContentTagMd5 = ConfigCacheService.getContentTagMd5(groupKey, tag);
            boolean bl3 = md5Changed = !md5.equals(localContentTagMd5);
            if (md5Changed) {
                ConfigDiskServiceFactory.getInstance().saveTagToDisk(dataId, group, tenant, tag, content);
            }
            if (md5Changed) {
                LogUtil.DUMP_LOG.warn("[dump-tag] md5 changed, update local jvm cache, groupKey={},tag={}, newMd5={},oldMd5={},lastModifiedTs={}", new Object[]{groupKey, tag, md5, localContentTagMd5, lastModifiedTs});
                ConfigCacheService.updateTagMd5(groupKey, tag, md5, lastModifiedTs, encryptedDataKey4Tag);
            } else if (timestampChanged) {
                LogUtil.DUMP_LOG.warn("[dump-tag] timestamp changed, update last modified in local jvm cache, groupKey={},tag={},tagLastModifiedTs={},oldTagLastModifiedTs={}", new Object[]{groupKey, tag, lastModifiedTs, localTagLastModifiedTs});
                ConfigCacheService.updateTagTimeStamp(groupKey, tag, lastModifiedTs);
            } else {
                LogUtil.DUMP_LOG.warn("[dump-tag-ignore] md5 & timestamp not changed. groupKey={},tag={}", (Object)groupKey, (Object)tag);
            }
            boolean bl4 = true;
            return bl4;
        }
        catch (IOException ioe) {
            LogUtil.DUMP_LOG.error("[dump-tag-exception] save disk error. " + groupKey + ", " + ioe.toString(), (Throwable)ioe);
            boolean bl = false;
            return bl;
        }
        finally {
            ConfigCacheService.releaseWriteLock(groupKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean remove(String dataId, String group, String tenant) {
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        int lockResult = ConfigCacheService.tryWriteLock(groupKey);
        if (0 == lockResult) {
            LogUtil.DUMP_LOG.info("[remove-ok] {} not exist.", (Object)groupKey);
            return true;
        }
        if (lockResult < 0) {
            LogUtil.DUMP_LOG.warn("[remove-error] write lock failed. {}", (Object)groupKey);
            return false;
        }
        try {
            LogUtil.DUMP_LOG.info("[dump] remove  local disk cache,groupKey={} ", (Object)groupKey);
            ConfigDiskServiceFactory.getInstance().removeConfigInfo(dataId, group, tenant);
            CACHE.remove(groupKey);
            LogUtil.DUMP_LOG.info("[dump] remove  local jvm cache,groupKey={} ", (Object)groupKey);
            NotifyCenter.publishEvent((Event)new LocalDataChangeEvent(groupKey));
            boolean bl = true;
            return bl;
        }
        finally {
            ConfigCacheService.releaseWriteLock(groupKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeBeta(String dataId, String group, String tenant) {
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        int lockResult = ConfigCacheService.tryWriteLock(groupKey);
        if (0 == lockResult) {
            LogUtil.DUMP_LOG.info("[remove-ok] {} not exist.", (Object)groupKey);
            return true;
        }
        if (lockResult < 0) {
            LogUtil.DUMP_LOG.warn("[remove-error] write lock failed. {}", (Object)groupKey);
            return false;
        }
        try {
            LogUtil.DUMP_LOG.info("[remove-beta-ok] remove beta in local disk cache,groupKey={} ", (Object)groupKey);
            ConfigDiskServiceFactory.getInstance().removeConfigInfo4Beta(dataId, group, tenant);
            NotifyCenter.publishEvent((Event)new LocalDataChangeEvent(groupKey, true, CACHE.get(groupKey).getIps4Beta()));
            CACHE.get(groupKey).removeBeta();
            LogUtil.DUMP_LOG.info("[remove-beta-ok] remove beta in local jvm cache,groupKey={} ", (Object)groupKey);
            boolean bl = true;
            return bl;
        }
        finally {
            ConfigCacheService.releaseWriteLock(groupKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeTag(String dataId, String group, String tenant, String tag) {
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        int lockResult = ConfigCacheService.tryWriteLock(groupKey);
        if (0 == lockResult) {
            LogUtil.DUMP_LOG.info("[remove-ok] {} not exist.", (Object)groupKey);
            return true;
        }
        if (lockResult < 0) {
            LogUtil.DUMP_LOG.warn("[remove-error] write lock failed. {}", (Object)groupKey);
            return false;
        }
        try {
            LogUtil.DUMP_LOG.info("[remove-tag-ok] remove tag in local disk cache,tag={},groupKey={} ", (Object)tag, (Object)groupKey);
            ConfigDiskServiceFactory.getInstance().removeConfigInfo4Tag(dataId, group, tenant, tag);
            CacheItem ci = CACHE.get(groupKey);
            if (ci.getConfigCacheTags() != null) {
                ci.getConfigCacheTags().remove(tag);
                if (ci.getConfigCacheTags().isEmpty()) {
                    ci.clearConfigTags();
                }
            }
            LogUtil.DUMP_LOG.info("[remove-tag-ok] remove tag in local jvm cache,tag={},groupKey={} ", (Object)tag, (Object)groupKey);
            NotifyCenter.publishEvent((Event)new LocalDataChangeEvent(groupKey, tag));
            boolean bl = true;
            return bl;
        }
        finally {
            ConfigCacheService.releaseWriteLock(groupKey);
        }
    }

    public static void updateMd5(String groupKey, String md5Utf8, long lastModifiedTs, String encryptedDataKey) {
        CacheItem cache = ConfigCacheService.makeSure(groupKey, encryptedDataKey);
        if (cache.getConfigCache().getMd5Utf8() == null || !cache.getConfigCache().getMd5Utf8().equals(md5Utf8)) {
            cache.getConfigCache().setMd5Utf8(md5Utf8);
            cache.getConfigCache().setLastModifiedTs(lastModifiedTs);
            cache.getConfigCache().setEncryptedDataKey(encryptedDataKey);
            NotifyCenter.publishEvent((Event)new LocalDataChangeEvent(groupKey));
        }
    }

    public static void updateBetaMd5(String groupKey, String md5Utf8, List<String> ips4Beta, long lastModifiedTs, String encryptedDataKey4Beta) {
        CacheItem cache = ConfigCacheService.makeSure(groupKey, null);
        cache.initBetaCacheIfEmpty();
        String betaMd5Utf8 = cache.getConfigCacheBeta().getMd5("UTF-8");
        if (betaMd5Utf8 == null || !betaMd5Utf8.equals(md5Utf8) || !CollectionUtils.isListEqual(ips4Beta, cache.ips4Beta)) {
            cache.isBeta = true;
            cache.ips4Beta = ips4Beta;
            cache.getConfigCacheBeta().setMd5Utf8(md5Utf8);
            cache.getConfigCacheBeta().setLastModifiedTs(lastModifiedTs);
            cache.getConfigCacheBeta().setEncryptedDataKey(encryptedDataKey4Beta);
            NotifyCenter.publishEvent((Event)new LocalDataChangeEvent(groupKey, true, ips4Beta));
        }
    }

    public static void updateTagMd5(String groupKey, String tag, String md5Utf8, long lastModifiedTs, String encryptedDataKey4Tag) {
        CacheItem cache = ConfigCacheService.makeSure(groupKey, null);
        cache.initConfigTagsIfEmpty(tag);
        ConfigCache configCache = cache.getConfigCacheTags().get(tag);
        configCache.setMd5Utf8(md5Utf8);
        configCache.setLastModifiedTs(lastModifiedTs);
        configCache.setEncryptedDataKey(encryptedDataKey4Tag);
        NotifyCenter.publishEvent((Event)new LocalDataChangeEvent(groupKey, tag));
    }

    public static String getContentMd5(String groupKey) {
        return ConfigCacheService.getContentMd5(groupKey, "", "");
    }

    public static String getContentMd5(String groupKey, String ip, String tag) {
        CacheItem item = CACHE.get(groupKey);
        if (item != null && item.isBeta && item.ips4Beta != null && item.ips4Beta.contains(ip) && item.getConfigCacheBeta() != null) {
            return item.getConfigCacheBeta().getMd5("UTF-8");
        }
        if (item != null && StringUtils.isNotBlank((String)tag) && item.getConfigCacheTags() != null && item.getConfigCacheTags().containsKey(tag)) {
            return item.getConfigCacheTags().get(tag).getMd5("UTF-8");
        }
        if (item != null && item.isBatch && item.delimiter >= InternetAddressUtil.ipToInt((String)ip) && item.getConfigCacheBatch() != null) {
            return item.getConfigCacheBatch().getMd5("UTF-8");
        }
        return null != item ? item.getConfigCache().getMd5("UTF-8") : "";
    }

    public static String getContentBetaMd5(String groupKey) {
        CacheItem item = CACHE.get(groupKey);
        if (item == null || item.getConfigCacheBeta() == null) {
            return "";
        }
        return item.getConfigCacheBeta().getMd5("UTF-8");
    }

    public static String getContentTagMd5(String groupKey, String tag) {
        CacheItem item = CACHE.get(groupKey);
        if (item == null || item.getConfigCacheTags() == null || !item.getConfigCacheTags().containsKey(tag)) {
            return "";
        }
        return item.getConfigCacheTags().get(tag).getMd5("UTF-8");
    }

    public static List<String> getBetaIps(String groupKey) {
        CacheItem item = CACHE.get(groupKey);
        return null != item ? item.getIps4Beta() : Collections.emptyList();
    }

    public static long getBetaLastModifiedTs(String groupKey) {
        CacheItem item = CACHE.get(groupKey);
        return null != item && item.getConfigCacheBeta() != null ? item.getConfigCacheBeta().getLastModifiedTs() : 0L;
    }

    public static long getTagLastModifiedTs(String groupKey, String tag) {
        CacheItem item = CACHE.get(groupKey);
        if (item.getConfigCacheTags() == null || !item.getConfigCacheTags().containsKey(tag)) {
            return 0L;
        }
        ConfigCache configCacheTag = item.getConfigCacheTags().get(tag);
        return null != configCacheTag ? configCacheTag.getLastModifiedTs() : 0L;
    }

    public static CacheItem getContentCache(String groupKey) {
        return CACHE.get(groupKey);
    }

    public static long getLastModifiedTs(String groupKey) {
        CacheItem item = CACHE.get(groupKey);
        return null != item ? item.getConfigCache().getLastModifiedTs() : 0L;
    }

    public static void updateTagTimeStamp(String groupKey, String tag, long lastModifiedTs) {
        CacheItem cache = ConfigCacheService.makeSure(groupKey, null);
        cache.initConfigTagsIfEmpty(tag);
        cache.getConfigCacheTags().get(tag).setLastModifiedTs(lastModifiedTs);
    }

    public static boolean isUptodate(String groupKey, String md5) {
        String serverMd5 = ConfigCacheService.getContentMd5(groupKey);
        return StringUtils.equals((String)md5, (String)serverMd5);
    }

    public static boolean isUptodate(String groupKey, String md5, String ip, String tag) {
        String serverMd5 = ConfigCacheService.getContentMd5(groupKey, ip, tag);
        return StringUtils.equals((String)md5, (String)serverMd5);
    }

    public static int tryReadLock(String groupKey) {
        int result;
        CacheItem groupItem = CACHE.get(groupKey);
        int n = null == groupItem ? 0 : (result = groupItem.getRwLock().tryReadLock() ? 1 : -1);
        if (result < 0) {
            LogUtil.DEFAULT_LOG.warn("[read-lock] failed, {}, {}", (Object)result, (Object)groupKey);
        }
        return result;
    }

    public static void releaseReadLock(String groupKey) {
        CacheItem item = CACHE.get(groupKey);
        if (null != item) {
            item.getRwLock().releaseReadLock();
        }
    }

    static int tryWriteLock(String groupKey) {
        int result;
        CacheItem groupItem = CACHE.get(groupKey);
        int n = null == groupItem ? 0 : (result = groupItem.getRwLock().tryWriteLock() ? 1 : -1);
        if (result < 0) {
            LogUtil.DEFAULT_LOG.warn("[write-lock] failed, {}, {}", (Object)result, (Object)groupKey);
        }
        return result;
    }

    static void releaseWriteLock(String groupKey) {
        CacheItem groupItem = CACHE.get(groupKey);
        if (null != groupItem) {
            groupItem.getRwLock().releaseWriteLock();
        }
    }

    static CacheItem makeSure(String groupKey, String encryptedDataKey) {
        CacheItem item = CACHE.get(groupKey);
        if (null != item) {
            return item;
        }
        CacheItem tmp = new CacheItem(groupKey, encryptedDataKey);
        item = CACHE.putIfAbsent(groupKey, tmp);
        return null == item ? tmp : item;
    }

    public static void updateTimeStamp(String groupKey, long lastModifiedTs, String encryptedDataKey) {
        CacheItem cache = ConfigCacheService.makeSure(groupKey, encryptedDataKey);
        cache.getConfigCache().setLastModifiedTs(lastModifiedTs);
    }

    private static void updateBetaIpList(String groupKey, List<String> ips4Beta, long lastModifiedTs) {
        CacheItem cache = ConfigCacheService.makeSure(groupKey, null);
        cache.initBetaCacheIfEmpty();
        cache.setBeta(true);
        cache.setIps4Beta(ips4Beta);
        cache.getConfigCacheBeta().setLastModifiedTs(lastModifiedTs);
        NotifyCenter.publishEvent((Event)new LocalDataChangeEvent(groupKey, true, ips4Beta));
    }

    private static void updateBetaTimeStamp(String groupKey, long lastModifiedTs) {
        CacheItem cache = ConfigCacheService.makeSure(groupKey, null);
        cache.initBetaCacheIfEmpty();
        cache.getConfigCacheBeta().setLastModifiedTs(lastModifiedTs);
    }

    public static int tryConfigReadLock(String groupKey) {
        int lockResult = -1;
        for (int i = 9; i >= 0 && 0 != (lockResult = ConfigCacheService.tryReadLock(groupKey)) && lockResult <= 0; --i) {
            if (i <= 0) continue;
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (Exception e) {
                LogUtil.PULL_CHECK_LOG.error("An Exception occurred while thread sleep", (Throwable)e);
            }
        }
        return lockResult;
    }
}

