/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.model;

import com.alibaba.nacos.config.server.model.ConfigCache;
import com.alibaba.nacos.config.server.utils.SimpleReadWriteLock;
import com.alibaba.nacos.core.utils.StringPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CacheItem {
    final String groupKey;
    public String type;
    ConfigCache configCache = new ConfigCache();
    public volatile boolean isBeta = false;
    public volatile List<String> ips4Beta;
    ConfigCache configCacheBeta = null;
    public volatile boolean isBatch = false;
    public volatile int delimiter = 0;
    ConfigCache configCacheBatch = null;
    private volatile Map<String, ConfigCache> configCacheTags = null;
    private final SimpleReadWriteLock rwLock = new SimpleReadWriteLock();

    public CacheItem(String groupKey, String encryptedDataKey) {
        this.groupKey = StringPool.get((String)groupKey);
        this.getConfigCache().setEncryptedDataKey(encryptedDataKey);
    }

    public CacheItem(String groupKey) {
        this.groupKey = StringPool.get((String)groupKey);
    }

    public ConfigCache getConfigCache() {
        return this.configCache;
    }

    public boolean isBeta() {
        return this.isBeta;
    }

    public void setBeta(boolean isBeta) {
        this.isBeta = isBeta;
    }

    public void removeBeta() {
        this.isBeta = false;
        this.ips4Beta = null;
        this.configCacheBeta = null;
    }

    public List<String> getIps4Beta() {
        return this.ips4Beta;
    }

    public void setIps4Beta(List<String> ips4Beta) {
        this.ips4Beta = ips4Beta;
    }

    public SimpleReadWriteLock getRwLock() {
        return this.rwLock;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getGroupKey() {
        return this.groupKey;
    }

    public void initBetaCacheIfEmpty() {
        if (this.configCacheBeta == null) {
            this.configCacheBeta = new ConfigCache();
        }
        if (this.ips4Beta == null) {
            this.ips4Beta = new ArrayList<String>();
        }
    }

    public ConfigCache getConfigCacheBeta() {
        return this.configCacheBeta;
    }

    public void initBatchCacheIfEmpty() {
        if (this.configCacheBatch == null) {
            this.configCacheBatch = new ConfigCache();
        }
    }

    public ConfigCache getConfigCacheBatch() {
        return this.configCacheBatch;
    }

    public void removeBatch() {
        this.configCacheBatch = null;
        this.isBatch = false;
    }

    public void initConfigTagsIfEmpty() {
        if (this.getConfigCacheTags() == null) {
            this.configCacheTags = new HashMap<String, ConfigCache>(16);
        }
    }

    public void initConfigTagsIfEmpty(String tag) {
        this.initConfigTagsIfEmpty();
        if (!this.configCacheTags.containsKey(tag)) {
            this.configCacheTags.put(tag, new ConfigCache());
        }
    }

    public void clearConfigTags() {
        this.configCacheTags = null;
    }

    public Map<String, ConfigCache> getConfigCacheTags() {
        return this.configCacheTags;
    }

    public boolean isBatch() {
        return this.isBatch;
    }

    public void setBatch(boolean batch) {
        this.isBatch = batch;
    }

    public int getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(int delimiter) {
        this.delimiter = delimiter;
    }

    public long getTagLastModified(String tag) {
        if (this.configCacheTags == null || !this.configCacheTags.containsKey(tag)) {
            return -1L;
        }
        return this.configCacheTags.get(tag).getLastModifiedTs();
    }

    public String getTagEncryptedDataKey(String tag) {
        if (this.configCacheTags == null || !this.configCacheTags.containsKey(tag)) {
            return null;
        }
        return this.configCacheTags.get(tag).getEncryptedDataKey();
    }

    public String getTagMd5(String tag, String encode) {
        if (this.configCacheTags == null || !this.configCacheTags.containsKey(tag)) {
            return null;
        }
        return this.configCacheTags.get(tag).getMd5(encode);
    }
}

