/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller;

import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.config.server.model.ConfigHistoryInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoWrapper;
import com.alibaba.nacos.config.server.paramcheck.ConfigDefaultHttpParamExtractor;
import com.alibaba.nacos.config.server.service.HistoryService;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.persistence.model.Page;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.exception.AccessException;
import java.util.List;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/cs/history"})
@ExtractorManager.Extractor(httpExtractor=ConfigDefaultHttpParamExtractor.class)
public class HistoryController {
    private final HistoryService historyService;

    public HistoryController(HistoryService historyService) {
        this.historyService = historyService;
    }

    @GetMapping(params={"search=accurate"})
    @Secured(action=ActionTypes.READ, signType="config")
    public Page<ConfigHistoryInfo> listConfigHistory(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="appName", required=false) String appName, @RequestParam(value="pageNo", required=false) Integer pageNo, @RequestParam(value="pageSize", required=false) Integer pageSize, ModelMap modelMap) {
        pageNo = null == pageNo ? 1 : pageNo;
        pageSize = null == pageSize ? 100 : pageSize;
        pageSize = Math.min(500, pageSize);
        return this.historyService.listConfigHistory(dataId, group, tenant, pageNo, pageSize);
    }

    @GetMapping
    @Secured(action=ActionTypes.READ, signType="config")
    public ConfigHistoryInfo getConfigHistoryInfo(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="nid") Long nid) throws AccessException {
        return this.historyService.getConfigHistoryInfo(dataId, group, tenant, nid);
    }

    @GetMapping(value={"/previous"})
    @Secured(action=ActionTypes.READ, signType="config")
    public ConfigHistoryInfo getPreviousConfigHistoryInfo(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="id") Long id) throws AccessException {
        return this.historyService.getPreviousConfigHistoryInfo(dataId, group, tenant, id);
    }

    @GetMapping(value={"/configs"})
    @Secured(action=ActionTypes.READ, signType="config")
    public List<ConfigInfoWrapper> getDataIds(@RequestParam(value="tenant") String tenant) {
        ParamUtils.checkTenant(tenant);
        tenant = NamespaceUtil.processNamespaceParameter((String)tenant);
        return this.historyService.getConfigListByNamespace(tenant);
    }
}

