/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.config;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.config.constants.ConfigChangePointCutTypes;
import com.alibaba.nacos.plugin.config.spi.ConfigChangePluginService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigChangePluginManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigChangePluginManager.class);
    private static final Integer PLUGIN_SERVICE_COUNT = 4;
    private static final Integer POINT_CUT_TYPE_COUNT = ConfigChangePointCutTypes.values().length;
    private static final Map<String, ConfigChangePluginService> CONFIG_CHANGE_PLUGIN_SERVICE_MAP = new ConcurrentHashMap<String, ConfigChangePluginService>(PLUGIN_SERVICE_COUNT);
    private static final Map<ConfigChangePointCutTypes, List<ConfigChangePluginService>> CONFIG_CHANGE_PLUGIN_SERVICES_MAP = new ConcurrentHashMap<ConfigChangePointCutTypes, List<ConfigChangePluginService>>(POINT_CUT_TYPE_COUNT);
    private static final ConfigChangePluginManager INSTANCE = new ConfigChangePluginManager();

    private ConfigChangePluginManager() {
        ConfigChangePluginManager.loadConfigChangeServices();
    }

    private static void loadConfigChangeServices() {
        Collection configChangePluginServices = NacosServiceLoader.load(ConfigChangePluginService.class);
        for (ConfigChangePluginService each : configChangePluginServices) {
            if (StringUtils.isEmpty((String)each.getServiceType())) {
                LOGGER.warn("[ConfigChangePluginManager] Load {}({}) ConfigChangeServiceName(null/empty) fail. Please Add the Plugin Service ConfigChangeServiceName to resolve.", (Object)each.getClass().getName(), each.getClass());
                continue;
            }
            CONFIG_CHANGE_PLUGIN_SERVICE_MAP.put(each.getServiceType(), each);
            LOGGER.info("[ConfigChangePluginManager] Load {}({}) ConfigChangeServiceName({}) successfully.", new Object[]{each.getClass().getName(), each.getClass(), each.getServiceType()});
            ConfigChangePluginManager.addPluginServiceByPointCut(each);
        }
        ConfigChangePluginManager.sortPluginServiceByPointCut();
    }

    public static ConfigChangePluginManager getInstance() {
        return INSTANCE;
    }

    public Optional<ConfigChangePluginService> findPluginServiceImpl(String serviceType) {
        return Optional.ofNullable(CONFIG_CHANGE_PLUGIN_SERVICE_MAP.get(serviceType));
    }

    public static synchronized boolean join(ConfigChangePluginService configChangePluginService) {
        CONFIG_CHANGE_PLUGIN_SERVICE_MAP.putIfAbsent(configChangePluginService.getServiceType(), configChangePluginService);
        ConfigChangePluginManager.addPluginServiceByPointCut(configChangePluginService);
        return true;
    }

    public static List<ConfigChangePluginService> findPluginServicesByPointcut(ConfigChangePointCutTypes pointcutName) {
        return CONFIG_CHANGE_PLUGIN_SERVICES_MAP.getOrDefault((Object)pointcutName, new ArrayList());
    }

    private static void addPluginServiceByPointCut(ConfigChangePluginService configChangePluginService) {
        ConfigChangePointCutTypes[] pointcutNames;
        for (ConfigChangePointCutTypes name : pointcutNames = configChangePluginService.pointcutMethodNames()) {
            List<ConfigChangePluginService> configChangePluginServiceList = CONFIG_CHANGE_PLUGIN_SERVICES_MAP.get((Object)name);
            if (configChangePluginServiceList == null) {
                configChangePluginServiceList = new ArrayList<ConfigChangePluginService>(PLUGIN_SERVICE_COUNT);
            }
            configChangePluginServiceList.add(configChangePluginService);
            CONFIG_CHANGE_PLUGIN_SERVICES_MAP.put(name, configChangePluginServiceList);
        }
    }

    private static void sortPluginServiceByPointCut() {
        CONFIG_CHANGE_PLUGIN_SERVICES_MAP.forEach((type, pluginServices) -> {
            ArrayList<ConfigChangePluginService> sortedList = new ArrayList<ConfigChangePluginService>((Collection<ConfigChangePluginService>)pluginServices);
            sortedList.sort(Comparator.comparingInt(ConfigChangePluginService::getOrder));
            CONFIG_CHANGE_PLUGIN_SERVICES_MAP.put((ConfigChangePointCutTypes)((Object)type), (List<ConfigChangePluginService>)sortedList);
        });
    }
}

