/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.logging.logback;

import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.spi.RuleStore;
import com.alibaba.nacos.client.logging.logback.NacosClientPropertyAction;
import com.alibaba.nacos.common.log.NacosLogbackConfigurator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;

public class NacosLogbackConfiguratorAdapterV1
extends JoranConfigurator
implements NacosLogbackConfigurator {
    public void registerSafeConfiguration(List<SaxEvent> eventList) {
    }

    public void addInstanceRules(RuleStore rs) {
        super.addInstanceRules(rs);
        rs.addRule(new ElementSelector("configuration/nacosClientProperty"), (Action)new NacosClientPropertyAction());
    }

    public int getVersion() {
        return 1;
    }

    public void setContext(Object loggerContext) {
        super.setContext((Context)loggerContext);
    }

    public void configure(URL url) throws Exception {
        InputStream in = null;
        try {
            URLConnection urlConnection = url.openConnection();
            urlConnection.setUseCaches(false);
            in = urlConnection.getInputStream();
            this.doConfigure(in, url.toExternalForm());
        }
        catch (IOException ioe) {
            String errMsg = "Could not open URL [" + url + "].";
            this.addError(errMsg, ioe);
            throw new JoranException(errMsg, (Throwable)ioe);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    String errMsg = "Could not close input stream";
                    this.addError(errMsg, ioe);
                    throw new JoranException(errMsg, (Throwable)ioe);
                }
            }
        }
    }
}

