/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.drag.service.a;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.jeecg.modules.drag.config.page.DragPage;
import org.jeecg.modules.drag.dao.OnlDragDatasetHeadDao;
import org.jeecg.modules.drag.dao.OnlDragDatasetItemDao;
import org.jeecg.modules.drag.dao.OnlDragDatasetParamDao;
import org.jeecg.modules.drag.dao.OnlDragPageCompDao;
import org.jeecg.modules.drag.dao.OnlDragPageDao;
import org.jeecg.modules.drag.entity.OnlDragDatasetHead;
import org.jeecg.modules.drag.entity.OnlDragDatasetItem;
import org.jeecg.modules.drag.entity.OnlDragDatasetParam;
import org.jeecg.modules.drag.entity.OnlDragPage;
import org.jeecg.modules.drag.entity.OnlDragPageComp;
import org.jeecg.modules.drag.exception.OnlDragException;
import org.jeecg.modules.drag.service.IOnlDragPageService;
import org.jeecg.modules.drag.util.a;
import org.jeecg.modules.drag.util.f;
import org.jeecg.modules.drag.util.h;
import org.jeecg.modules.jmreport.config.client.JmReportTokenClient;
import org.jeecg.modules.jmreport.desreport.entity.JimuReportDict;
import org.jeecg.modules.jmreport.desreport.entity.JimuReportDictItem;
import org.jeecg.modules.jmreport.desreport.service.IJimuReportDictItemService;
import org.jeecg.modules.jmreport.desreport.service.IJimuReportDictService;
import org.jeecgframework.minidao.pojo.MiniDaoPage;
import org.jeecgframework.minidao.util.SnowflakeIdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service(value="onlDragPageServiceImpl")
public class j
implements IOnlDragPageService {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(j.class);
    @Autowired
    private OnlDragPageDao onlDragPageDao;
    @Autowired
    private OnlDragPageCompDao onlDragPageCompDao;
    @Autowired
    private OnlDragDatasetHeadDao onlDragDatasetHeadDao;
    @Autowired
    private OnlDragDatasetItemDao onlDragDatasetItemDao;
    @Autowired
    private OnlDragDatasetParamDao onlDragDatasetParamDao;
    @Autowired
    private f redisUtil;
    @Autowired
    private JmReportTokenClient jimuTokenClient;
    @Autowired
    private IJimuReportDictService dictService;
    @Autowired
    private IJimuReportDictItemService jimuDictItemService;

    @Override
    public OnlDragPage addOnlPage(OnlDragPage onlDragPage) {
        String template = onlDragPage.getTemplate();
        JSONArray array = JSONArray.parseArray((String)template);
        if (array != null) {
            org.jeecg.modules.drag.util.a.a(array, null);
            onlDragPage.setTemplate(array.toJSONString());
        }
        onlDragPage.setIzTemplate("0");
        String type = onlDragPage.getType();
        if (h.c((Object)type)) {
            onlDragPage.setType("0");
        }
        onlDragPage.setVisitsNum(0);
        this.onlDragPageDao.insert(onlDragPage);
        onlDragPage.setPath(String.format("/drag/page/view/%s", onlDragPage.getId()));
        this.onlDragPageDao.update(onlDragPage);
        return onlDragPage;
    }

    @Override
    @Cacheable(value={"drag:cache:page"}, key="#id", condition="#id != null", unless="#result == null")
    public OnlDragPage getOneOnlPage(String id) {
        OnlDragPage onlDragPage = this.getById(id);
        if (onlDragPage == null) {
            return null;
        }
        String template = onlDragPage.getTemplate();
        JSONArray array = JSONArray.parseArray((String)template);
        if (array != null) {
            List<OnlDragPageComp> onlDragPageCompList = this.onlDragPageCompDao.queryByPageId(id);
            Map<String, Object> maps = onlDragPageCompList.stream().collect(Collectors.toMap(OnlDragPageComp::getId, opc -> opc.getConfig() != null ? opc.getConfig() : "{}"));
            org.jeecg.modules.drag.util.a.a(array, maps);
            onlDragPage.setTemplate(array.toJSONString());
        }
        return onlDragPage;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteOne(String id) {
        this.onlDragPageDao.deleteById(id);
        List<OnlDragPageComp> onlDragPageCompList = this.onlDragPageCompDao.queryByPageId(id);
        List ids = onlDragPageCompList.stream().map(OnlDragPageComp::getId).collect(Collectors.toList());
        for (int i2 = 0; i2 < ids.size(); ++i2) {
            this.onlDragPageCompDao.deleteById((String)ids.get(i2));
        }
        String key = String.format("drag:cache:page::%s", id);
        if (this.redisUtil.a(key)) {
            this.redisUtil.a(new String[]{key});
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean editOnlPageById(OnlDragPage onlDragPage) {
        String template = onlDragPage.getTemplate();
        if (StringUtils.isNotBlank((String)template)) {
            List<OnlDragPageComp> onlDragPageCompList = this.onlDragPageCompDao.queryByPageId(onlDragPage.getId());
            List ids = onlDragPageCompList.stream().map(OnlDragPageComp::getId).collect(Collectors.toList());
            for (int i2 = 0; i2 < ids.size(); ++i2) {
                this.onlDragPageCompDao.deleteById((String)ids.get(i2));
            }
            JSONArray array = JSONArray.parseArray((String)template);
            if (array != null) {
                this.a(array, onlDragPage.getId());
                onlDragPage.setTemplate(array.toJSONString());
            }
        }
        onlDragPage.setPath(String.format("/drag/page/view/%s", onlDragPage.getId()));
        int update = this.onlDragPageDao.update(onlDragPage);
        String key = String.format("drag:cache:page::%s", onlDragPage.getId());
        if (this.redisUtil.a(key)) {
            this.redisUtil.a(new String[]{key});
        }
        if (update == 0) {
            throw new OnlDragException("\u4eea\u8868\u76d8\u5185\u5bb9\u4e0d\u662f\u6700\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u64cd\u4f5c~");
        }
        return update == 1;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public OnlDragPage copyPage(OnlDragPage onlDragPage) {
        OnlDragPage targetPage = new OnlDragPage();
        String random = String.format("%04d", new Random().nextInt(9999));
        Object dragName = onlDragPage.getName();
        if (onlDragPage.getName().indexOf("\u526f\u672c") == -1) {
            dragName = (String)dragName + "\u526f\u672c" + random;
        } else {
            int suffix_index = ((String)dragName).length();
            if (((String)dragName).indexOf("\u526f\u672c") > 0) {
                suffix_index = ((String)dragName).indexOf("\u526f\u672c");
            }
            dragName = ((String)dragName).substring(0, suffix_index) + "\u526f\u672c" + random;
        }
        BeanUtils.copyProperties((Object)onlDragPage, (Object)targetPage);
        targetPage.setId(null);
        targetPage.setName((String)dragName);
        targetPage.setProtectionCode(null);
        targetPage.setIzTemplate("0");
        targetPage.setCreateTime(new Date());
        targetPage.setVisitsNum(0);
        this.onlDragPageDao.insert(targetPage);
        this.a(targetPage);
        targetPage.setPath(String.format("/drag/page/view/%s", targetPage.getId()));
        this.onlDragPageDao.update(targetPage);
        return targetPage;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public OnlDragPage backupsPage(String id, String backupKey) {
        OnlDragPage sourcePage = this.onlDragPageDao.get(id);
        if (sourcePage != null) {
            String newId = org.jeecg.modules.drag.util.a.a(id, backupKey);
            String newLowAppId = org.jeecg.modules.drag.util.a.a(sourcePage.getLowAppId(), backupKey);
            OnlDragPage targetPage = new OnlDragPage();
            BeanUtils.copyProperties((Object)sourcePage, (Object)targetPage);
            targetPage.setId(newId);
            targetPage.setLowAppId(newLowAppId);
            this.onlDragPageDao.insert(targetPage);
            this.a(targetPage);
            targetPage.setPath(String.format("/drag/page/view/%s", targetPage.getId()));
            this.onlDragPageDao.update(targetPage);
            return targetPage;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(value={"drag:cache:page"}, allEntries=true)
    public void revertPage(String id, String backupKey) {
        String originId = org.jeecg.modules.drag.util.a.b(id, backupKey);
        this.deleteOne(originId);
        OnlDragPage sourcePage = this.onlDragPageDao.get(id);
        if (sourcePage != null) {
            OnlDragPage targetPage = new OnlDragPage();
            BeanUtils.copyProperties((Object)sourcePage, (Object)targetPage);
            targetPage.setId(originId);
            targetPage.setLowAppId(org.jeecg.modules.drag.util.a.b(sourcePage.getLowAppId(), backupKey));
            this.onlDragPageDao.insert(targetPage);
            this.a(targetPage);
            targetPage.setPath(String.format("/drag/page/view/%s", targetPage.getId()));
            this.onlDragPageDao.update(targetPage);
        }
    }

    @Override
    public void replacePageValue(String id, Map<String, String> formCodeMap, Map<String, String> formIdMap, Map<String, String> dragIdMap, Map<String, String> viewIdMap, Map<String, String> bpmIdMap) {
        OnlDragPage onlDragPage = this.onlDragPageDao.get(id);
        JSONArray tempArr = JSONArray.parseArray((String)onlDragPage.getTemplate());
        if (tempArr != null && tempArr.size() > 0) {
            tempArr.forEach(obj -> {
                OnlDragPageComp onlDragPageComp;
                JSONObject jsonObject = (JSONObject)obj;
                String pageCompId = jsonObject.getString("pageCompId");
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)pageCompId) && (onlDragPageComp = this.onlDragPageCompDao.get(pageCompId)) != null) {
                    String component = onlDragPageComp.getComponent();
                    String config = onlDragPageComp.getConfig();
                    JSONObject compConfigObj = JSONObject.parseObject((String)config);
                    if ("JCustomButton".equals(component)) {
                        JSONArray btnArr = compConfigObj.getJSONArray("chartData");
                        if (btnArr != null && btnArr.size() > 0) {
                            for (int i2 = 0; i2 < btnArr.size(); ++i2) {
                                JSONObject bizFlow;
                                String key;
                                JSONObject worksheet;
                                JSONObject btn = (JSONObject)btnArr.get(i2);
                                String operationType = btn.getString("operationType");
                                if ("1".equals(operationType) || "2".equals(operationType)) {
                                    String view;
                                    worksheet = btn.getJSONObject("worksheet");
                                    if (worksheet == null) continue;
                                    key = worksheet.getString("key");
                                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)key) && formCodeMap.containsKey(key)) {
                                        worksheet.put("key", formCodeMap.get(key));
                                        worksheet.put("value", formCodeMap.get(key));
                                    }
                                    if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(view = btn.getString("view"))) || !viewIdMap.containsKey(view)) continue;
                                    worksheet.put("view", viewIdMap.get(view));
                                    continue;
                                }
                                if ("3".equals(operationType)) {
                                    worksheet = btn.getJSONObject("customPage");
                                    if (worksheet == null || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(key = worksheet.getString("key"))) || !dragIdMap.containsKey(key)) continue;
                                    worksheet.put("key", dragIdMap.get(key));
                                    worksheet.put("value", dragIdMap.get(key));
                                    continue;
                                }
                                if (!"6".equals(operationType) || (bizFlow = btn.getJSONObject("bizFlow")) == null || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(key = bizFlow.getString("key"))) || !bpmIdMap.containsKey(key)) continue;
                                bizFlow.put("key", bpmIdMap.get(key));
                                bizFlow.put("value", bpmIdMap.get(key));
                            }
                        }
                    } else if ("JCarousel".equals(component)) {
                        String key;
                        JSONObject worksheet = compConfigObj.getJSONObject("worksheet");
                        if (worksheet != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(key = worksheet.getString("key"))) && formCodeMap.containsKey(key)) {
                            worksheet.put("key", formCodeMap.get(key));
                            worksheet.put("value", formCodeMap.get(key));
                        }
                    } else {
                        String formId = compConfigObj.getString("formId");
                        String appId = compConfigObj.getString("appId");
                        String appType = compConfigObj.getString("appType");
                        String tableName = compConfigObj.getString("tableName");
                        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)formId) && formCodeMap.containsKey(formId)) {
                            compConfigObj.put("formId", formCodeMap.get(formId));
                            compConfigObj.put("tableName", formCodeMap.get(tableName));
                        }
                        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)appType) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)appId) && appType.equals("current")) {
                            compConfigObj.put("appId", (Object)onlDragPage.getLowAppId());
                        }
                    }
                    onlDragPageComp.setConfig(compConfigObj.toJSONString());
                    this.onlDragPageCompDao.update(onlDragPageComp);
                }
            });
        }
    }

    @Override
    public void updateVisitsNum(String id, Integer increaseCount) {
        OnlDragPage onlDragPageVisitsNum = this.getByIdForVisitsNum(id);
        if (null != onlDragPageVisitsNum) {
            int visits = h.a((Object)onlDragPageVisitsNum.getVisitsNum(), 0);
            int totalValue = increaseCount + visits;
            onlDragPageVisitsNum.setVisitsNum(totalValue);
            this.onlDragPageDao.updateVisitsNum(onlDragPageVisitsNum);
        }
    }

    @Override
    public void removeOne(String id) {
        OnlDragPage onlDragPage = new OnlDragPage();
        onlDragPage.setDelFlag(org.jeecg.modules.drag.a.a.g);
        onlDragPage.setId(id);
        this.onlDragPageDao.update(onlDragPage);
    }

    @Override
    public void recoveryDelete(String id) {
        OnlDragPage onlDragPage = new OnlDragPage();
        onlDragPage.setDelFlag(org.jeecg.modules.drag.a.a.h);
        onlDragPage.setId(id);
        this.onlDragPageDao.update(onlDragPage);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void clearRecovery(OnlDragPage onlDragPage) {
        List<String> ids = this.onlDragPageDao.queryIdList(onlDragPage);
        if (!CollectionUtils.isEmpty(ids)) {
            this.onlDragPageCompDao.deleteByPageIds(ids);
            this.onlDragPageDao.deleteByIds(ids);
        }
    }

    @Override
    public Map<String, Integer> getCount() {
        HashMap<String, Integer> map = new HashMap<String, Integer>(4);
        Integer pageNum = this.onlDragPageDao.countByStyle("default");
        Integer bigScreenNum = this.onlDragPageDao.countByStyle("bigScreen");
        map.put("pageNum", pageNum);
        map.put("bigScreenNum", bigScreenNum);
        return map;
    }

    @Override
    public String getDragConfigJsonString(String id) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(5);
        OnlDragPage onlDragPage = this.onlDragPageDao.get(id);
        String dragStr = h.i(onlDragPage);
        dataMap.put("onl_drag", dragStr);
        List<OnlDragPageComp> dragPageComps = this.onlDragPageCompDao.queryByPageId(id);
        String dragCompsStr = h.i(dragPageComps);
        dataMap.put("onl_drag_comps", dragCompsStr);
        List<String> ids = dragPageComps.stream().map(comp -> {
            try {
                return JSONObject.parseObject((String)comp.getConfig());
            }
            catch (Exception e2) {
                return null;
            }
        }).filter(Objects::nonNull).filter(json -> json.containsKey((Object)"dataSetId")).map(json -> json.getString("dataSetId")).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(ids)) {
            List<OnlDragDatasetHead> headList = this.onlDragDatasetHeadDao.getByIds(ids);
            String dbListEncoded = h.i(headList);
            dataMap.put("onl_drag_db_list", dbListEncoded);
            if (CollectionUtil.isNotEmpty(headList)) {
                for (OnlDragDatasetHead head : headList) {
                    List<OnlDragDatasetParam> dbParamList;
                    List<OnlDragDatasetItem> dbFieldList = this.onlDragDatasetItemDao.selectByMainId(head.getId());
                    if (dbFieldList != null && dbFieldList.size() > 0) {
                        String key = "onl_drag_db_field_list" + head.getId();
                        String dbFieldListEncoded = h.i(dbFieldList);
                        dataMap.put(key, dbFieldListEncoded);
                        for (OnlDragDatasetItem dbField : dbFieldList) {
                            String dictCode = dbField.getDictCode();
                            this.a(dataMap, dictCode);
                        }
                    }
                    if ((dbParamList = this.onlDragDatasetParamDao.selectByMainId(head.getId())) == null || dbParamList.size() <= 0) continue;
                    String key = "onl_drag_db_param" + head.getId();
                    String dbParamListEncoded = h.i(dbParamList);
                    dataMap.put(key, dbParamListEncoded);
                    for (OnlDragDatasetParam dbParam : dbParamList) {
                        String dictCode = dbParam.getDictCode();
                        this.a(dataMap, dictCode);
                    }
                }
            }
        }
        return h.b(dataMap);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importDragJson(MultipartFile file) throws Exception {
        InputStream inputStream = file.getInputStream();
        String content = h.a(inputStream);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)content)) {
            String userName = this.jimuTokenClient.getUsername();
            String tenantId = this.jimuTokenClient.getTenantId();
            a.info("\u5bfc\u5165\u5927\u5c4f\uff0cuserName\uff1a{}\uff0ctenantId\uff1a{}", (Object)userName, (Object)tenantId);
            HashMap<String, String> valueMapping = new HashMap<String, String>(5);
            JSONObject dataJson = JSONObject.parseObject((String)content);
            if (dataJson.containsKey((Object)"onl_drag")) {
                String reportDecode = dataJson.getString("onl_drag");
                String reportStr = URLDecoder.decode(reportDecode, "UTF-8");
                OnlDragPage onlDragPage = (OnlDragPage)JSONObject.parseObject((String)reportStr).toJavaObject(OnlDragPage.class);
                String originalReportId = onlDragPage.getId();
                onlDragPage.setId(String.valueOf(SnowflakeIdWorker.generateId()));
                onlDragPage.setTenantId(h.a(tenantId, 0));
                onlDragPage.setDelFlag(org.jeecg.modules.drag.a.a.h);
                onlDragPage.setUpdateCount(1);
                onlDragPage.setIzTemplate("0");
                onlDragPage.setCreateBy(userName);
                onlDragPage.setCreateTime(new Date());
                String type = onlDragPage.getType();
                onlDragPage.setType("0");
                this.onlDragPageDao.insert(onlDragPage);
                valueMapping.put(originalReportId, onlDragPage.getId());
                this.a(valueMapping, dataJson, onlDragPage);
                this.a(valueMapping, dataJson);
                String template = onlDragPage.getTemplate();
                if (h.d((Object)template)) {
                    JSONArray array = JSONArray.parseArray((String)template);
                    array.forEach(item -> {
                        JSONObject json = (JSONObject)item;
                        String pageCompId = (String)valueMapping.get(json.getString("pageCompId"));
                        if (h.d((Object)pageCompId)) {
                            json.put("pageCompId", valueMapping.get(json.getString("pageCompId")));
                        }
                    });
                    onlDragPage.setTemplate(array.toJSONString());
                }
                onlDragPage.setPath(String.format("/drag/page/view/%s", onlDragPage.getId()));
                this.onlDragPageDao.update(onlDragPage);
            }
        }
    }

    private void a(Map<String, String> valueMapping, JSONObject dataJson) throws Exception {
        if (dataJson.containsKey((Object)"onl_drag_db_list")) {
            String userName = this.jimuTokenClient.getUsername();
            String tenantId = this.jimuTokenClient.getTenantId();
            String dbListDecode = dataJson.getString("onl_drag_db_list");
            String dbListJsonString = URLDecoder.decode(dbListDecode, "UTF-8");
            List dbList = JSONObject.parseArray((String)dbListJsonString, OnlDragDatasetHead.class);
            if (!CollectionUtils.isEmpty((Collection)dbList)) {
                for (OnlDragDatasetHead db : dbList) {
                    String dbParamDecode;
                    String dbParamListJsonString;
                    List dbParamFieldList;
                    String dbParamKey;
                    String dbFieldDecode;
                    String dbFieldListJsonString;
                    List dbFieldList;
                    String originalId = db.getId();
                    OnlDragDatasetHead onlDragDatasetHead = this.onlDragDatasetHeadDao.get(originalId);
                    if (!h.c(onlDragDatasetHead)) continue;
                    db.setCreateBy(userName);
                    db.setCreateTime(new Date());
                    db.setTenantId(h.a(tenantId, 0));
                    this.onlDragDatasetHeadDao.insert(db);
                    String dbFieldKey = "onl_drag_db_field_list" + originalId;
                    if (dataJson.containsKey((Object)dbFieldKey) && CollectionUtil.isNotEmpty((Collection)(dbFieldList = JSONObject.parseArray((String)(dbFieldListJsonString = URLDecoder.decode(dbFieldDecode = dataJson.getString(dbFieldKey), "UTF-8")), OnlDragDatasetItem.class)))) {
                        for (OnlDragDatasetItem dbField : dbFieldList) {
                            OnlDragDatasetItem onlDragDatasetItem = this.onlDragDatasetItemDao.get(dbField.getId());
                            if (!h.c(onlDragDatasetItem)) continue;
                            dbField.setCreateBy(userName);
                            dbField.setCreateTime(new Date());
                            this.onlDragDatasetItemDao.insert(dbField);
                            String dictCode = this.a(dataJson, dbField.getDictCode());
                            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dictCode)) continue;
                            dbField.setDictCode(dictCode);
                            this.onlDragDatasetItemDao.update(dbField);
                        }
                    }
                    if (!dataJson.containsKey((Object)(dbParamKey = "onl_drag_db_param" + originalId)) || !CollectionUtil.isNotEmpty((Collection)(dbParamFieldList = JSONObject.parseArray((String)(dbParamListJsonString = URLDecoder.decode(dbParamDecode = dataJson.getString(dbParamKey), "UTF-8")), OnlDragDatasetParam.class)))) continue;
                    for (OnlDragDatasetParam dbParam : dbParamFieldList) {
                        OnlDragDatasetItem onlDragDatasetItem = this.onlDragDatasetItemDao.get(dbParam.getId());
                        if (!h.c(onlDragDatasetItem)) continue;
                        dbParam.setCreateBy(userName);
                        dbParam.setCreateTime(new Date());
                        this.onlDragDatasetParamDao.insert(dbParam);
                        String dictCode = this.a(dataJson, dbParam.getDictCode());
                        if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dictCode)) continue;
                        dbParam.setDictCode(dictCode);
                        this.onlDragDatasetParamDao.update(dbParam);
                    }
                }
            }
        }
    }

    private void a(Map<String, String> valueMapping, JSONObject dataJson, OnlDragPage onlDragPage) throws Exception {
        if (dataJson.containsKey((Object)"onl_drag_comps")) {
            String userName = this.jimuTokenClient.getUsername();
            String dbListDecode = dataJson.getString("onl_drag_comps");
            String dbListJsonString = URLDecoder.decode(dbListDecode, "UTF-8");
            List dragCompList = JSONObject.parseArray((String)dbListJsonString, OnlDragPageComp.class);
            if (!CollectionUtils.isEmpty((Collection)dragCompList)) {
                for (OnlDragPageComp dragPageComp : dragCompList) {
                    String originalId = dragPageComp.getId();
                    String compId = String.valueOf(SnowflakeIdWorker.generateId());
                    dragPageComp.setId(compId);
                    dragPageComp.setPageId(onlDragPage.getId());
                    dragPageComp.setCreateBy(userName);
                    dragPageComp.setCreateTime(new Date());
                    this.onlDragPageCompDao.insert(dragPageComp);
                    valueMapping.put(originalId, compId);
                }
            }
        }
    }

    private String a(JSONObject dataJson, String dictCode) {
        try {
            JimuReportDict reportDict;
            String key = "onl_drag_dict" + dictCode;
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dictCode) && dataJson.containsKey((Object)key) && h.c(reportDict = this.dictService.getByCode(dictCode))) {
                String userName = this.jimuTokenClient.getUsername();
                String tenantId = this.jimuTokenClient.getTenantId();
                String dictCodeDecode = dataJson.getString(key);
                String dictCodeJsonString = URLDecoder.decode(dictCodeDecode, "UTF-8");
                JimuReportDict dict = (JimuReportDict)JSONObject.parseObject((String)dictCodeJsonString).toJavaObject(JimuReportDict.class);
                String oldId = dict.getId();
                dict.setId(String.valueOf(SnowflakeIdWorker.generateId()));
                dict.setDictCode(dictCode);
                dict.setCreateBy(userName);
                dict.setCreateTime(new Date());
                dict.setTenantId(tenantId);
                this.dictService.save(dict);
                String dictItemlistStr = "onl_drag_dict_item" + oldId;
                String dictItemDecode = dataJson.getString(dictItemlistStr);
                String dictItemJsonString = URLDecoder.decode(dictItemDecode, "UTF-8");
                List dictItemList = JSONObject.parseArray((String)dictItemJsonString, JimuReportDictItem.class);
                dictItemList.forEach(dictItem -> {
                    dictItem.setId(String.valueOf(SnowflakeIdWorker.generateId()));
                    dictItem.setDictId(dict.getId());
                    dictItem.setCreateBy(userName);
                    dictItem.setCreateTime(new Date());
                    this.jimuDictItemService.save(dictItem);
                });
                return dict.getDictCode();
            }
        }
        catch (UnsupportedEncodingException e2) {
            a.error(e2.getMessage(), (Throwable)e2);
        }
        return "";
    }

    private void a(Map<String, Object> dataMap, String dictCode) {
        JimuReportDict dict;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dictCode) && h.d(dict = this.dictService.getByCode(dictCode))) {
            String dictEncoded = h.i(dict);
            dataMap.put("onl_drag_dict" + dictCode, dictEncoded);
            List dictItemList = this.jimuDictItemService.selectItemsByMainId(dict.getId());
            String dictItemListEncoded = h.i(dictItemList);
            dataMap.put("onl_drag_dict_item" + dict.getId(), dictItemListEncoded);
        }
    }

    private List<OnlDragPageComp> a(OnlDragPage targetPage) {
        ArrayList<OnlDragPageComp> onlDragPageCompList = new ArrayList<OnlDragPageComp>();
        String template = targetPage.getTemplate();
        JSONArray array = JSONArray.parseArray((String)template);
        if (array != null) {
            array.forEach(obj -> {
                JSONObject jsonObject = (JSONObject)obj;
                String pageCompId = jsonObject.getString("pageCompId");
                OnlDragPageComp onlDragPageComp = this.onlDragPageCompDao.get(pageCompId);
                if (onlDragPageComp != null) {
                    onlDragPageComp.setId(null);
                    onlDragPageComp.setPageId(targetPage.getId());
                    onlDragPageComp.setCreateTime(new Date());
                    this.onlDragPageCompDao.insert(onlDragPageComp);
                    jsonObject.put("pageCompId", (Object)onlDragPageComp.getId());
                }
            });
            targetPage.setTemplate(array.toJSONString());
            return onlDragPageCompList;
        }
        return null;
    }

    public void a(JSONArray array, String pageId) {
        for (int i2 = 0; i2 < array.size(); ++i2) {
            JSONObject json = array.getJSONObject(i2);
            OnlDragPageComp opc = new OnlDragPageComp();
            opc.setComponent(json.getString("component"));
            opc.setConfig(json.containsKey((Object)"config") ? json.getString("config") : "");
            opc.setPageId(pageId);
            this.onlDragPageCompDao.insert(opc);
            json.put("pageCompId", (Object)opc.getId());
            if (!json.containsKey((Object)"config")) continue;
            json.remove((Object)"config");
        }
    }

    @Override
    public DragPage<OnlDragPage> pageList(OnlDragPage onlDragPage, Integer pageNo, Integer pageSize) {
        MiniDaoPage<OnlDragPage> pageList = this.onlDragPageDao.pageList(onlDragPage, pageNo, pageSize);
        DragPage<OnlDragPage> list = new DragPage<OnlDragPage>(pageList);
        return list;
    }

    @Override
    public OnlDragPage getById(String id) {
        return this.onlDragPageDao.get(id);
    }

    @Override
    public OnlDragPage getByIdForVisitsNum(String id) {
        return this.onlDragPageDao.getByIdForVisitsNum(id);
    }

    @Override
    public Map getShareInfo(String id, String type) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        OnlDragPage onlDragPage = this.onlDragPageDao.get(id);
        map.put("title", onlDragPage.getName());
        map.put("path", onlDragPage.getPath());
        map.put("shareInfo", null);
        return map;
    }

    @Override
    public OnlDragPage getPageById(String id) {
        return this.onlDragPageDao.getById(id);
    }

    @Override
    public Integer count() {
        return this.onlDragPageDao.count();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveCompToPage(OnlDragPage onlDragPage) {
        this.onlDragPageDao.update(onlDragPage);
        String key = String.format("drag:cache:page::%s", onlDragPage.getId());
        if (this.redisUtil.a(key)) {
            this.redisUtil.a(new String[]{key});
        }
    }
}

