/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.drag.config.sign;

import com.alibaba.fastjson.JSONObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.jeecg.modules.drag.util.a;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component(value="dragSignatureAspect")
public class DragSignatureAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DragSignatureAspect.class);
    private static final long MAX_REQUEST = 600000L;
    private static final String X_SIGN = "X-SIGN";
    private static final String V_SIGN = "V-SIGN";
    private static final String TIMESTAMP = "X-TIMESTAMP";

    @Pointcut(value="execution(@org.jeecg.modules.drag.config.sign.SignatureValidation * *(..))")
    private void verifySignPointCut() {
    }

    @Before(value="verifySignPointCut()")
    public void doBasicProfiling(JoinPoint point) throws IOException {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = Objects.requireNonNull(attributes).getRequest();
        String sign = request.getHeader(V_SIGN);
        String timestamp = request.getHeader(TIMESTAMP);
        String xSign = request.getHeader(X_SIGN);
        long now = System.currentTimeMillis();
        if (StringUtils.isEmpty((String)timestamp)) {
            log.error("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25:X-TIMESTAMP\u4e3a\u7a7a\uff01");
            throw new IllegalArgumentException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25:X-TIMESTAMP\u4e3a\u7a7a\uff01");
        }
        long time = Long.parseLong(timestamp);
        if (now - time > 600000L) {
            log.error("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25:X-TIMESTAMP\u5df2\u8fc7\u671f\uff0c\u6ce8\u610f\u7cfb\u7edf\u65f6\u95f4\u548c\u670d\u52a1\u5668\u65f6\u95f4\u662f\u5426\u6709\u8bef\u5dee\uff01");
            throw new IllegalArgumentException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25:X-TIMESTAMP\u5df2\u8fc7\u671f");
        }
        if (StringUtils.isBlank((String)sign)) {
            throw new IllegalArgumentException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25:\u7b7e\u540d\u672a\u627e\u5230");
        }
        try {
            String generatedSign = this.generatedSignature(point, xSign);
            if (!sign.equals(generatedSign)) {
                throw new IllegalArgumentException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25:\u7b7e\u540d\u9519\u8bef");
            }
        }
        catch (Throwable throwable) {
            log.warn("\u7b7e\u540d\u5931\u8d25\u5f02\u5e38:" + throwable.getMessage(), throwable);
            throw new IllegalArgumentException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25:\u7b7e\u540d\u9519\u8bef");
        }
    }

    private String generatedSignature(JoinPoint point, String xSign) throws IOException {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = Objects.requireNonNull(attributes).getRequest();
        String method = request.getMethod().toUpperCase();
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("sign", xSign);
        params.put("_t", Instant.now().toString());
        if (!"GET".equals(method) && !"DELETE".equals(method)) {
            this.extractPostParams(point, params);
        }
        return a.a(params);
    }

    private void extractGetParams(HttpServletRequest request, SortedMap<String, String> params) {
        request.getParameterMap().forEach((key, values) -> {
            if (values != null && ((String[])values).length > 0 && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)values[0])) {
                params.put((String)key, values[0]);
            }
        });
    }

    private void extractPostParams(JoinPoint point, SortedMap<String, String> params) {
        List collect;
        Object[] args = point.getArgs();
        if (ArrayUtils.isNotEmpty((Object[])args) && (collect = Arrays.stream(args).filter(arg -> !(arg instanceof HttpServletRequest) && !(arg instanceof HttpServletResponse)).collect(Collectors.toList())) != null && collect.size() > 0) {
            Object element = collect.get(0);
            JSONObject jsonObject = null;
            try {
                if (element instanceof String || element instanceof JSONObject) {
                    jsonObject = JSONObject.parseObject((String)element.toString());
                } else {
                    String jsonString = JSONObject.toJSONString(element);
                    jsonObject = JSONObject.parseObject((String)jsonString);
                }
            }
            catch (Exception e2) {
                log.warn("\u7b7e\u540d\u751f\u6210 \u8f6c\u6362JSON \u65f6\u51fa\u73b0\u9519\u8bef: " + e2.getMessage());
            }
            Set keySet = jsonObject.keySet();
            String key2 = "";
            for (String key2 : keySet) {
                Object obj = jsonObject.get((Object)key2);
                if (!(obj instanceof String)) continue;
                params.put(key2, obj.toString());
            }
        }
    }
}

